# 22.2.快速入门指南

FreeBSD 可以在系统初始化期间挂载 ZFS 池和数据集。要启用它，请将以下行添加到/etc/rc.conf 中：

```
zfs_enable="YES"
```

然后启动服务：

```
# service zfs start
```

本节中的示例假定有三个 SCSI 磁盘，设备名称为 da0、da1 和 da2。使用 SATA 硬件的用户应改用 ada 设备名称。

### 22.2.1. 单磁盘池

创建一个简单的非冗余池，仅使用单个磁盘设备：

```
# zpool create example /dev/da0
```

要查看新池，请查看 df 的输出：

```
# df
Filesystem  1K-blocks    Used    Avail Capacity  Mounted on
/dev/ad0s1a   2026030  235230  1628718    13%    /
devfs               1       1        0   100%    /dev
/dev/ad0s1d  54098308 1032846 48737598     2%    /usr
example      17547136       0 17547136     0%    /example
```

此输出显示创建和挂载 example 池，并且现在作为文件系统可访问。为用户创建文件以供浏览：

```
# cd /example
# ls
# touch testfile
# ls -al
total 4
drwxr-xr-x   2 root  wheel    3 Aug 29 23:15 .
drwxr-xr-x  21 root  wheel  512 Aug 29 23:12 ..
-rw-r--r--   1 root  wheel    0 Aug 29 23:15 testfile
```

此池尚未使用任何高级 ZFS 功能和属性。要在此池上创建启用压缩的数据集：

```
# zfs create example/compressed
# zfs set compression=gzip example/compressed
```

example/compressed 数据集现在是一个 ZFS 压缩文件系统。尝试将一些大文件复制到 /example/compressed。

使用以下命令禁用压缩：

```
# zfs set compression=off example/compressed
```

卸载文件系统，请使用 zfs umount，然后使用 df 进行验证：

```
# zfs umount example/compressed
# df
Filesystem  1K-blocks    Used    Avail Capacity  Mounted on
/dev/ad0s1a   2026030  235232  1628716    13%    /
devfs               1       1        0   100%    /dev
/dev/ad0s1d  54098308 1032864 48737580     2%    /usr
example      17547008       0 17547008     0%    /example
```

若要重新挂载文件系统以使其再次可访问，请使用 zfs mount，然后使用 df 进行验证：

```
# zfs mount example/compressed
# df
Filesystem         1K-blocks    Used    Avail Capacity  Mounted on
/dev/ad0s1a          2026030  235234  1628714    13%    /
devfs                      1       1        0   100%    /dev
/dev/ad0s1d         54098308 1032864 48737580     2%    /usr
example             17547008       0 17547008     0%    /example
example/compressed  17547008       0 17547008     0%    /example/compressed
```

运行 mount 可显示池和文件系统：

```
# mount
/dev/ad0s1a on / (ufs, local)
devfs on /dev (devfs, local)
/dev/ad0s1d on /usr (ufs, local, soft-updates)
example on /example (zfs, local)
example/compressed on /example/compressed (zfs, local)
```

创建 ZFS 数据集后，可以像任何文件系统一样使用。在需要时，可以为每个数据集设置其他可用功能。下面的示例创建一个名为 data 的新文件系统。它假定文件系统包含重要文件，并配置其以存储每个数据块的两份副本。

```
# zfs create example/data
# zfs set copies=2 example/data
```

使用 df 查看数据和空间使用情况：

```
# df
Filesystem         1K-blocks    Used    Avail Capacity  Mounted on
/dev/ad0s1a          2026030  235234  1628714    13%    /
devfs                      1       1        0   100%    /dev
/dev/ad0s1d         54098308 1032864 48737580     2%    /usr
example             17547008       0 17547008     0%    /example
example/compressed  17547008       0 17547008     0%    /example/compressed
example/data        17547008       0 17547008     0%    /example/data
```

请注意，池中的所有文件系统具有相同的可用空间。在这些示例中使用 df 显示文件系统使用它们所需的空间，并且全部来自同一池。ZFS 消除了卷和分区等概念，能让多个文件系统共享同一池。

销毁不再需要的文件系统和池：

```
# zfs destroy example/compressed
# zfs destroy example/data
# zpool destroy example
```

### 22.2.2. RAID-Z

磁盘故障。避免磁盘故障数据丢失的方法之一是使用 RAID。ZFS 在其池设计中支持此功能。RAID-Z 池需要三个或更多磁盘，但提供比镜像池更多的可用空间。

此示例创建了一个 RAID-Z 池，指定要添加到池中的磁盘：

```
# zpool create storage raidz da0 da1 da2
```

|  | Sun™建议在 RAID-Z 配置中使用的设备数量应在三到九之间。对于需要由 10 个或更多磁盘组成的单个池的环境，考虑将其分成较小的 RAID-Z 组。如果有两个磁盘可用，ZFS 镜像提供必要的冗余。有关更多详细信息，请参阅 zpool(8)。|
| -- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

前面的示例创建了 storage zpool。此示例在该池中创建一个名为 home 的新文件系统：

```
# zfs create storage/home
```

启用压缩并存储目录和文件的额外副本：

```
# zfs set copies=2 storage/home
# zfs set compression=gzip storage/home
```

要将此设为用户的新主目录，请将用户数据复制到此目录，并创建适当的符号链接：

```
# cp -rp /home/* /storage/home
# rm -rf /home /usr/home
# ln -s /storage/home /home
# ln -s /storage/home /usr/home
```

用户数据现在存储在新创建的 /storage/home 目录中。通过添加新用户并以该用户身份登录进行测试。

创建一个文件系统快照，以便以后回滚：

```
# zfs snapshot storage/home@08-30-08
```

ZFS 创建数据集的快照，而不是单个目录或文件。

@ 字符是文件系统名称或卷名称之间的分隔符。在删除重要目录之前，备份文件系统，然后回滚到一个早期的快照，其中该目录仍然存在：

```
# zfs rollback storage/home@08-30-08
```

要列出所有可用的快照，请在文件系统的.zfs/snapshot 目录中运行 ls。例如，要查看已拍摄的快照：

```
# ls /storage/home/.zfs/snapshot
```

编写脚本定期对用户数据进行快照。随着时间的推移，快照可能会占用大量磁盘空间。使用以下命令删除先前的快照：

```
# zfs destroy storage/home@08-30-08
```

测试后，使用此命令将/storage/home 设为真正的/home：

```
# zfs set mountpoint=/home storage/home
```

运行 df 和 mount 以确认系统现在将文件系统视为真正的 /home：

```
# mount
/dev/ad0s1a on / (ufs, local)
devfs on /dev (devfs, local)
/dev/ad0s1d on /usr (ufs, local, soft-updates)
storage on /storage (zfs, local)
storage/home on /home (zfs, local)
# df
Filesystem   1K-blocks    Used    Avail Capacity  Mounted on
/dev/ad0s1a    2026030  235240  1628708    13%    /
devfs                1       1        0   100%    /dev
/dev/ad0s1d   54098308 1032826 48737618     2%    /usr
storage       26320512       0 26320512     0%    /storage
storage/home  26320512       0 26320512     0%    /home
```

RAID-Z 配置完成。通过将以下行添加到 /etc/periodic.conf，将每日关于创建的文件系统的状态更新添加到夜间的 periodic(8) 运行中：

```
daily_status_zfs_enable="YES"
```

### 22.2.3. 恢复 RAID-Z

每个软件 RAID 都有一种监视其 state 的方法。使用以下命令查看 RAID-Z 设备的状态：

```
# zpool status -x
```

如果所有池都是在线的，一切正常，消息将显示：

```
all pools are healthy
```

如果出现问题，也许是因为某个磁盘处于离线状态，池的状态看起来会是这样的：

```
  pool: storage
 state: DEGRADED
status: One or more devices has been taken offline by the administrator.
	Sufficient replicas exist for the pool to continue functioning in a
	degraded state.
action: Online the device using 'zpool online' or replace the device with
	'zpool replace'.
 scrub: none requested
config:

	NAME        STATE     READ WRITE CKSUM
	storage     DEGRADED     0     0     0
	  raidz1    DEGRADED     0     0     0
	    da0     ONLINE       0     0     0
	    da1     OFFLINE      0     0     0
	    da2     ONLINE       0     0     0

errors: No known data errors
```

"OFFLINE" 显示管理员使用 da1 下线：

```
# zpool offline storage da1
```

立即关闭计算机并更换 da1。打开计算机并将 da1 返回到池中：

```
# zpool replace storage da1
```

接下来，再次检查状态，这次不使用 -x 来显示所有池：

```
# zpool status storage
 pool: storage
 state: ONLINE
 scrub: resilver completed with 0 errors on Sat Aug 30 19:44:11 2008
config:

	NAME        STATE     READ WRITE CKSUM
	storage     ONLINE       0     0     0
	  raidz1    ONLINE       0     0     0
	    da0     ONLINE       0     0     0
	    da1     ONLINE       0     0     0
	    da2     ONLINE       0     0     0

errors: No known data errors
```

在这个例子中，一切正常。

### 22.2.4. 数据验证

ZFS 使用校验和来验证存储数据的完整性。创建文件系统会自动启用它们。

|  | 禁用校验和是可能的，但不推荐！ 校验和占用少量存储空间，提供数据完整性。大多数 ZFS 功能在禁用校验和情况下将无法正常工作。禁用这些校验和不会显着提高性能。|
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------------ |

验证数据校验和（称为 scrubbing）可确保 storage 池的完整性：

```
# zpool scrub storage
```

scrub 的持续时间取决于存储的数据量。存储量越大，验证的时间就会成比例延长。由于 scrubbing 需要大量 I/O 操作，ZFS 一次只能让运行一个 scrub。完成 scrub 后，使用 zpool status 查看状态：

```
# zpool status storage
 pool: storage
 state: ONLINE
 scrub: scrub completed with 0 errors on Sat Jan 26 19:57:37 2013
config:

	NAME        STATE     READ WRITE CKSUM
	storage     ONLINE       0     0     0
	  raidz1    ONLINE       0     0     0
	    da0     ONLINE       0     0     0
	    da1     ONLINE       0     0     0
	    da2     ONLINE       0     0     0

errors: No known data errors
```

显示最后一次洗盘的完成日期有助于决定何时开始下一次。定期洗盘有助于保护数据免受静默损坏，并确保池的完整性。

参考 zfs(8) 和 zpool(8) 获取其他 ZFS 选项。
