# 22.3.zpool 管理

ZFS 管理使用两个主要的实用程序。zpool 实用程序控制池的操作，能让添加、删除、替换和管理磁盘。zfs 实用程序能让创建、销毁和管理数据集，包括文件系统和卷。

### 创建和销毁存储池

创建 ZFS 存储池需要做出永久决策，因为在创建后无法更改存储池结构。最重要的决策是将物理磁盘分组成哪种类型的 vdev。有关可能选项的 vdev 类型列表，请参阅。创建存储池后，大多数 vdev 类型不能让向 vdev 添加磁盘。例外情况是镜像，它能让向 vdev 添加新磁盘，以及条带，通过将新磁盘连接到 vdev 而升级为镜像。虽然添加新的 vdev 会扩展存储池，但存储池布局在创建后不能更改。取而代之的是，备份数据，销毁存储池，然后重新创建。

创建一个简单的镜像池:

```
# zpool create mypool mirror /dev/ada1 /dev/ada2
# zpool status
  pool: mypool
 state: ONLINE
  scan: none requested
config:

        NAME        STATE     READ WRITE CKSUM
        mypool      ONLINE       0     0     0
          mirror-0  ONLINE       0     0     0
            ada1    ONLINE       0     0     0
            ada2    ONLINE       0     0     0

errors: No known data errors
```

使用单个命令创建多个 vdev，请在此示例中使用 vdev 类型关键字分隔的磁盘组： mirror

```
# zpool create mypool mirror /dev/ada1 /dev/ada2 mirror /dev/ada3 /dev/ada4
# zpool status
  pool: mypool
 state: ONLINE
  scan: none requested
config:

        NAME        STATE     READ WRITE CKSUM
        mypool      ONLINE       0     0     0
          mirror-0  ONLINE       0     0     0
            ada1    ONLINE       0     0     0
            ada2    ONLINE       0     0     0
          mirror-1  ONLINE       0     0     0
            ada3    ONLINE       0     0     0
            ada4    ONLINE       0     0     0

errors: No known data errors
```

池还可以使用分区而不是整个磁盘。将 ZFS 放在单独的分区中能让同一磁盘具有其他用途的分区。特别是，它能让添加带有引导代码和引导所需的文件系统的分区。这能让从也是池成员的磁盘引导。在 FreeBSD 上使用分区而不是整个磁盘时，ZFS 不会带来性能惩罚。使用分区还能让管理员对磁盘进行欠配置，使用不到完整容量的部分。如果将来更换的磁盘与原始磁盘的标称大小相同，实际上容量略小，较小的分区仍将适合，使用更换的磁盘。

使用分区创建 RAID-Z2 池：

```
# zpool create mypool raidz2 /dev/ada0p3 /dev/ada1p3 /dev/ada2p3 /dev/ada3p3 /dev/ada4p3 /dev/ada5p3
# zpool status
  pool: mypool
 state: ONLINE
  scan: none requested
config:

        NAME        STATE     READ WRITE CKSUM
        mypool      ONLINE       0     0     0
          raidz2-0  ONLINE       0     0     0
            ada0p3  ONLINE       0     0     0
            ada1p3  ONLINE       0     0     0
            ada2p3  ONLINE       0     0     0
            ada3p3  ONLINE       0     0     0
            ada4p3  ONLINE       0     0     0
            ada5p3  ONLINE       0     0     0

errors: No known data errors
```

销毁不再需要的池以重用磁盘。销毁池需要先卸载该池中的文件系统。如果任何数据集正在使用中，则卸载操作将失败而不会销毁池。使用 -f 强制销毁池。这可能会导致在这些数据集上有打开文件的应用程序出现未定义行为。

### 22.3.2. 添加和移除设备

有两种方法可以向池添加磁盘：使用 zpool attach 将磁盘附加到现有的 vdev，或者使用 zpool add 向池添加 vdev。某些 vdev 类型能让在创建后向 vdev 添加磁盘。

一个只有一个磁盘的池缺乏冗余性。它可以检测损坏，但无法修复，因为没有其他数据副本。复制属性可能能够从诸如坏扇区之类的小故障中恢复，但不像镜像或 RAID-Z 提供相同级别的保护。从仅包含单个磁盘 vdev 的池开始，使用 zpool attach 添加新磁盘到 vdev，创建镜像。也可以使用 zpool attach 向镜像组添加新磁盘，增加冗余性和读取性能。在用于池的磁盘上进行分区时，在第一个磁盘上复制布局到第二个。使用 gpart backup 和 gpart restore 使这个过程更容易。

将单个磁盘（条带）vdev ada0p3 升级为镜像，方法是附加 ada1p3：

```
# zpool status
  pool: mypool
 state: ONLINE
  scan: none requested
config:

        NAME        STATE     READ WRITE CKSUM
        mypool      ONLINE       0     0     0
          ada0p3    ONLINE       0     0     0

errors: No known data errors
# zpool attach mypool ada0p3 ada1p3
Make sure to wait until resilvering finishes before rebooting.

If you boot from pool 'mypool', you may need to update boot code on newly attached disk _ada1p3_.

Assuming you use GPT partitioning and _da0_ is your new boot disk you may use the following command:

        gpart bootcode -b /boot/pmbr -p /boot/gptzfsboot -i 1 da0
# gpart bootcode -b /boot/pmbr -p /boot/gptzfsboot -i 1 ada1
bootcode written to ada1
# zpool status
  pool: mypool
 state: ONLINE
status: One or more devices is currently being resilvered.  The pool will
        continue to function, possibly in a degraded state.
action: Wait for the resilver to complete.
  scan: resilver in progress since Fri May 30 08:19:19 2014
        527M scanned out of 781M at 47.9M/s, 0h0m to go
        527M resilvered, 67.53% done
config:

        NAME        STATE     READ WRITE CKSUM
        mypool      ONLINE       0     0     0
          mirror-0  ONLINE       0     0     0
            ada0p3  ONLINE       0     0     0
            ada1p3  ONLINE       0     0     0  (resilvering)

errors: No known data errors
# zpool status
  pool: mypool
 state: ONLINE
  scan: resilvered 781M in 0h0m with 0 errors on Fri May 30 08:15:58 2014
config:

        NAME        STATE     READ WRITE CKSUM
        mypool      ONLINE       0     0     0
          mirror-0  ONLINE       0     0     0
            ada0p3  ONLINE       0     0     0
            ada1p3  ONLINE       0     0     0

errors: No known data errors
```

当为 RAID-Z 等添加磁盘到现有 vdev 不可行时，另一种方法是向池中添加另一个 vdev。添加 vdev 通过在 vdev 之间分发写操作提供更高的性能。每个 vdev 提供其自己的冗余性。混合 vdev 类型，如 mirror 和 RAID-Z，是可能的，但不鼓励。将非冗余 vdev 添加到包含镜像或 RAID-Z vdev 的池可能会导致整个池上的数据丢失风险。分发写操作意味着非冗余磁盘的故障将导致对池中写入的每个块的一部分的丢失。

ZFS 在每个 vdev 上分布数据。例如，使用两个镜像 vdev，这实际上是一个 RAID 10，它将写入跨两组镜像进行条带化。ZFS 分配空间，以便每个 vdev 在同一时间达到 100%满。具有不同剩余空间量的 vdev 会降低性能，因为更多数据写入较少剩余空间的 vdev。

当将新设备附加到引导池时，请记得更新引导代码。

将第二个镜像组（ada2p3 和 ada3p3）附加到现有镜像：

```
# zpool status
  pool: mypool
 state: ONLINE
  scan: resilvered 781M in 0h0m with 0 errors on Fri May 30 08:19:35 2014
config:

        NAME        STATE     READ WRITE CKSUM
        mypool      ONLINE       0     0     0
          mirror-0  ONLINE       0     0     0
            ada0p3  ONLINE       0     0     0
            ada1p3  ONLINE       0     0     0

errors: No known data errors
# zpool add mypool mirror ada2p3 ada3p3
# gpart bootcode -b /boot/pmbr -p /boot/gptzfsboot -i 1 ada2
bootcode written to ada2
# gpart bootcode -b /boot/pmbr -p /boot/gptzfsboot -i 1 ada3
bootcode written to ada3
# zpool status
  pool: mypool
 state: ONLINE
  scan: scrub repaired 0 in 0h0m with 0 errors on Fri May 30 08:29:51 2014
config:

        NAME        STATE     READ WRITE CKSUM
        mypool      ONLINE       0     0     0
          mirror-0  ONLINE       0     0     0
            ada0p3  ONLINE       0     0     0
            ada1p3  ONLINE       0     0     0
          mirror-1  ONLINE       0     0     0
            ada2p3  ONLINE       0     0     0
            ada3p3  ONLINE       0     0     0

errors: No known data errors
```

从池中删除 vdevs 是不可能的，如果剩余的冗余足够，从镜像中移除磁盘是排他的。如果镜像组中只剩下一个磁盘，该组将不再是镜像，而变成条带，如果该剩余磁盘失效，会危及整个池。

从三路镜像组中移除一个磁盘：

```
# zpool status
  pool: mypool
 state: ONLINE
  scan: scrub repaired 0 in 0h0m with 0 errors on Fri May 30 08:29:51 2014
config:

        NAME        STATE     READ WRITE CKSUM
        mypool      ONLINE       0     0     0
          mirror-0  ONLINE       0     0     0
            ada0p3  ONLINE       0     0     0
            ada1p3  ONLINE       0     0     0
            ada2p3  ONLINE       0     0     0

errors: No known data errors
# zpool detach mypool ada2p3
# zpool status
  pool: mypool
 state: ONLINE
  scan: scrub repaired 0 in 0h0m with 0 errors on Fri May 30 08:29:51 2014
config:

        NAME        STATE     READ WRITE CKSUM
        mypool      ONLINE       0     0     0
          mirror-0  ONLINE       0     0     0
            ada0p3  ONLINE       0     0     0
            ada1p3  ONLINE       0     0     0

errors: No known data errors
```

### 22.3.3. 检查池的状态

池状态很重要。如果驱动器离线或者 ZFS 检测到读取、写入或校验和错误，相应的错误计数会增加。status 输出显示池中每个设备的配置和状态，以及整个池的状态。还显示要执行的操作和关于最后一个 scrub 的详细信息。

```
# zpool status
  pool: mypool
 state: ONLINE
  scan: scrub repaired 0 in 2h25m with 0 errors on Sat Sep 14 04:25:50 2013
config:

        NAME        STATE     READ WRITE CKSUM
        mypool      ONLINE       0     0     0
          raidz2-0  ONLINE       0     0     0
            ada0p3  ONLINE       0     0     0
            ada1p3  ONLINE       0     0     0
            ada2p3  ONLINE       0     0     0
            ada3p3  ONLINE       0     0     0
            ada4p3  ONLINE       0     0     0
            ada5p3  ONLINE       0     0     0

errors: No known data errors
```

### 22.3.4. 清除错误

当检测到错误时，ZFS 会增加读取、写入或校验和错误计数。使用 zpool clear<span> </span><em>mypool</em> 清除错误消息并重置计数。清除错误状态对于警报管理员池遇到错误时执行的自动化脚本非常重要。如果不清除旧错误，这些脚本可能无法报告进一步的错误。

### 22.3.5. 更换运作设备

可能有必要用不同的磁盘替换一个磁盘。在替换工作磁盘时，该过程会保持旧磁盘在线进行替换。存储池永远不会进入降级状态，降低数据丢失的风险。运行 zpool replace 会将数据从旧磁盘复制到新磁盘。操作完成后，ZFS 会将旧磁盘从 vdev 中断开连接。如果新磁盘大于旧磁盘，则可能可以扩展 zpool，使用新空间。请参阅扩展池。

在池中更换一个运作设备：

```
# zpool status
  pool: mypool
 state: ONLINE
  scan: none requested
config:

        NAME        STATE     READ WRITE CKSUM
        mypool      ONLINE       0     0     0
          mirror-0  ONLINE       0     0     0
            ada0p3  ONLINE       0     0     0
            ada1p3  ONLINE       0     0     0

errors: No known data errors
# zpool replace mypool ada1p3 ada2p3
Make sure to wait until resilvering finishes before rebooting.

When booting from the pool 'zroot', update the boot code on the newly attached disk 'ada2p3'.

Assuming GPT partitioning is used and [.filename]#da0# is the new boot disk, use the following command:

        gpart bootcode -b /boot/pmbr -p /boot/gptzfsboot -i 1 da0
# gpart bootcode -b /boot/pmbr -p /boot/gptzfsboot -i 1 ada2
# zpool status
  pool: mypool
 state: ONLINE
status: One or more devices is currently being resilvered.  The pool will
        continue to function, possibly in a degraded state.
action: Wait for the resilver to complete.
  scan: resilver in progress since Mon Jun  2 14:21:35 2014
        604M scanned out of 781M at 46.5M/s, 0h0m to go
        604M resilvered, 77.39% done
config:

        NAME             STATE     READ WRITE CKSUM
        mypool           ONLINE       0     0     0
          mirror-0       ONLINE       0     0     0
            ada0p3       ONLINE       0     0     0
            replacing-1  ONLINE       0     0     0
              ada1p3     ONLINE       0     0     0
              ada2p3     ONLINE       0     0     0  (resilvering)

errors: No known data errors
# zpool status
  pool: mypool
 state: ONLINE
  scan: resilvered 781M in 0h0m with 0 errors on Mon Jun  2 14:21:52 2014
config:

        NAME        STATE     READ WRITE CKSUM
        mypool      ONLINE       0     0     0
          mirror-0  ONLINE       0     0     0
            ada0p3  ONLINE       0     0     0
            ada2p3  ONLINE       0     0     0

errors: No known data errors
```

### 22.3.6. 处理故障设备

当池中的一个磁盘故障时，包含该磁盘的 vdev 进入降级状态。数据仍然可用，但由于 ZFS 从可用冗余计算丢失的数据，性能降低。要将 vdev 恢复到完全功能状态，请替换故障的物理设备。然后，ZFS 被指示开始重新银操作。ZFS 重新计算故障设备上的数据，并将其写入替换设备。完成后，vdev 恢复到在线状态。

如果 vdev 没有任何冗余，或者设备故障且没有足够的冗余来补偿，则池进入故障状态。除非足够的设备可以重新连接池，否则池将变得无法操作，需要从备份中恢复数据。

当更换失败的磁盘时，失败磁盘的名称更改为新磁盘的 GUID。如果更换设备与原设备名称相同，则不需要新设备名称参数。

使用 zpool replace 替换故障磁盘：

```
# zpool status
  pool: mypool
 state: DEGRADED
status: One or more devices could not be opened.  Sufficient replicas exist for
        the pool to continue functioning in a degraded state.
action: Attach the missing device and online it using 'zpool online'.
   see: http://illumos.org/msg/ZFS-8000-2Q
  scan: none requested
config:

        NAME                    STATE     READ WRITE CKSUM
        mypool                  DEGRADED     0     0     0
          mirror-0              DEGRADED     0     0     0
            ada0p3              ONLINE       0     0     0
            316502962686821739  UNAVAIL      0     0     0  was /dev/ada1p3

errors: No known data errors
# zpool replace mypool 316502962686821739 ada2p3
# zpool status
  pool: mypool
 state: DEGRADED
status: One or more devices is currently being resilvered.  The pool will
        continue to function, possibly in a degraded state.
action: Wait for the resilver to complete.
  scan: resilver in progress since Mon Jun  2 14:52:21 2014
        641M scanned out of 781M at 49.3M/s, 0h0m to go
        640M resilvered, 82.04% done
config:

        NAME                        STATE     READ WRITE CKSUM
        mypool                      DEGRADED     0     0     0
          mirror-0                  DEGRADED     0     0     0
            ada0p3                  ONLINE       0     0     0
            replacing-1             UNAVAIL      0     0     0
              15732067398082357289  UNAVAIL      0     0     0  was /dev/ada1p3/old
              ada2p3                ONLINE       0     0     0  (resilvering)

errors: No known data errors
# zpool status
  pool: mypool
 state: ONLINE
  scan: resilvered 781M in 0h0m with 0 errors on Mon Jun  2 14:52:38 2014
config:

        NAME        STATE     READ WRITE CKSUM
        mypool      ONLINE       0     0     0
          mirror-0  ONLINE       0     0     0
            ada0p3  ONLINE       0     0     0
            ada2p3  ONLINE       0     0     0

errors: No known data errors
```

### 22.3.7. 池体磨损

定期清洗游泳池，最好每个月至少一次。scrub 操作会对磁盘造成大量负担，在运行时会降低性能。避开高需求时段进行 scrub，或使用 vfs.zfs.scrub_delay 来调整 scrub 的相对优先级，以防止其减慢其他工作负载的速度。

```
# zpool scrub mypool
# zpool status
  pool: mypool
 state: ONLINE
  scan: scrub in progress since Wed Feb 19 20:52:54 2014
        116G scanned out of 8.60T at 649M/s, 3h48m to go
        0 repaired, 1.32% done
config:

        NAME        STATE     READ WRITE CKSUM
        mypool      ONLINE       0     0     0
          raidz2-0  ONLINE       0     0     0
            ada0p3  ONLINE       0     0     0
            ada1p3  ONLINE       0     0     0
            ada2p3  ONLINE       0     0     0
            ada3p3  ONLINE       0     0     0
            ada4p3  ONLINE       0     0     0
            ada5p3  ONLINE       0     0     0

errors: No known data errors
```

如果需要，运行 zpool scrub -s<span> </span><em>mypool</em> 来取消一次清洗操作。

### 22.3.8. 自愈

存储在数据块中的校验和使文件系统能够自我修复。此功能将自动修复数据，其校验和与存储池中另一设备上记录的校验和不匹配。例如，具有两个磁盘的镜像配置，其中一个驱动器开始发生故障，无法正确存储数据。当长时间未访问数据时，如长期存档存储，情况会变得更糟。传统文件系统需要运行类似于 fsck(8)的命令来检查和修复数据。这些命令需要时间，在严重情况下，管理员必须决定执行哪种修复操作。当 ZFS 检测到具有不匹配校验和的数据块时，它会尝试从镜像磁盘读取数据。如果该磁盘可以提供正确的数据，ZFS 将将其提供给应用程序，并更正具有错误校验和的磁盘上的数据。这在正常存储池操作期间无需系统管理员的任何交互即可发生。

下一个示例通过创建磁盘/dev/ada0 和/dev/ada1 的镜像池展示了这种自我修复行为。

```
# zpool create healer mirror /dev/ada0 /dev/ada1
# zpool status healer
  pool: healer
 state: ONLINE
  scan: none requested
config:

    NAME        STATE     READ WRITE CKSUM
    healer      ONLINE       0     0     0
      mirror-0  ONLINE       0     0     0
       ada0     ONLINE       0     0     0
       ada1     ONLINE       0     0     0

errors: No known data errors
# zpool list
NAME     SIZE  ALLOC   FREE   CKPOINT  EXPANDSZ   FRAG   CAP  DEDUP  HEALTH  ALTROOT
healer   960M  92.5K   960M         -         -     0%    0%  1.00x  ONLINE  -
```

将一些重要数据复制到池中，以利用自我修复功能保护数据免受错误，并为稍后比较创建池的校验和。

```
# cp /some/important/data /healer
# zfs list
NAME     SIZE  ALLOC   FREE    CAP  DEDUP  HEALTH  ALTROOT
healer   960M  67.7M   892M     7%  1.00x  ONLINE  -
# sha1 /healer > checksum.txt
# cat checksum.txt
SHA1 (/healer) = 2753eff56d77d9a536ece6694bf0a82740344d1f
```

模拟数据损坏，通过向镜像中的一个磁盘开头写入随机数据来实现。为了防止 ZFS 在检测到数据损坏时修复数据，在损坏之前导出池，在损坏之后重新导入池。

|  | 这是一个危险的操作，可能会摧毁重要数据，这里仅用于演示。在存储池正常运行期间，请勿尝试此操作。此示例中的有意损坏不应在具有非 ZFS 文件系统的任何磁盘上运行。请仅使用池中已有的磁盘设备名称。确保池有适当的备份，并在运行命令前进行测试！ |
| -- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

```
# zpool export healer
# dd if=/dev/random of=/dev/ada1 bs=1m count=200
200+0 records in
200+0 records out
209715200 bytes transferred in 62.992162 secs (3329227 bytes/sec)
# zpool import healer
```

池状态显示一个设备遇到了错误。注意，从池中读取数据的应用程序未收到任何错误数据。ZFS 从 ada0 设备提供了具有正确校验和的数据。要找到校验和错误的设备，请查找 CKSUM 列包含非零值的设备。

```
# zpool status healer
    pool: healer
   state: ONLINE
  status: One or more devices has experienced an unrecoverable error.  An
          attempt was made to correct the error.  Applications are unaffected.
  action: Determine if the device needs to be replaced, and clear the errors
          using 'zpool clear' or replace the device with 'zpool replace'.
     see: http://illumos.org/msg/ZFS-8000-4J
    scan: none requested
  config:

      NAME        STATE     READ WRITE CKSUM
      healer      ONLINE       0     0     0
        mirror-0  ONLINE       0     0     0
         ada0     ONLINE       0     0     0
         ada1     ONLINE       0     0     1

errors: No known data errors
```

ZFS 检测到错误，并通过未受影响的 ada0 镜像磁盘中的冗余处理该错误。通过与原始数据的校验和比较，可以确定池是否再次一致。

```
# sha1 /healer >> checksum.txt
# cat checksum.txt
SHA1 (/healer) = 2753eff56d77d9a536ece6694bf0a82740344d1f
SHA1 (/healer) = 2753eff56d77d9a536ece6694bf0a82740344d1f
```

在池数据仍然匹配时，在故意篡改之前和之后生成校验和。这展示了 ZFS 如何在校验和不同时自动检测和更正任何错误。请注意，只有在池中存在足够的冗余时才能实现这一点。单设备组成的池没有自我修复能力。这也是为什么 ZFS 中校验和如此重要的原因；不要因任何原因禁用它们。ZFS 不需要 fsck(8)或类似的文件系统一致性检查程序来检测和更正此问题，并在存在问题时保持池可用。现在需要进行一次检查操作以覆盖 ada1 上的损坏数据。

```
# zpool scrub healer
# zpool status healer
  pool: healer
 state: ONLINE
status: One or more devices has experienced an unrecoverable error.  An
            attempt was made to correct the error.  Applications are unaffected.
action: Determine if the device needs to be replaced, and clear the errors
            using 'zpool clear' or replace the device with 'zpool replace'.
   see: http://illumos.org/msg/ZFS-8000-4J
  scan: scrub in progress since Mon Dec 10 12:23:30 2012
        10.4M scanned out of 67.0M at 267K/s, 0h3m to go
        9.63M repaired, 15.56% done
config:

    NAME        STATE     READ WRITE CKSUM
    healer      ONLINE       0     0     0
      mirror-0  ONLINE       0     0     0
       ada0     ONLINE       0     0     0
       ada1     ONLINE       0     0   627  (repairing)

errors: No known data errors
```

检查操作从 ada0 读取数据，并在 ada1 上重写任何具有错误校验和的数据，通过 zpool status 显示。操作完成后，池状态将更改为:

```
# zpool status healer
  pool: healer
 state: ONLINE
status: One or more devices has experienced an unrecoverable error.  An
        attempt was made to correct the error.  Applications are unaffected.
action: Determine if the device needs to be replaced, and clear the errors
             using 'zpool clear' or replace the device with 'zpool replace'.
   see: http://illumos.org/msg/ZFS-8000-4J
  scan: scrub repaired 66.5M in 0h2m with 0 errors on Mon Dec 10 12:26:25 2012
config:

    NAME        STATE     READ WRITE CKSUM
    healer      ONLINE       0     0     0
      mirror-0  ONLINE       0     0     0
       ada0     ONLINE       0     0     0
       ada1     ONLINE       0     0 2.72K

errors: No known data errors
```

After the scrubbing operation completes with all the data synchronized from ada0 to ada1, [clear](https://docs.freebsd.org/en/books/handbook/zfs/#zfs-zpool-clear) the error messages from the pool status by running `zpool clear`.

```
# zpool clear healer
# zpool status healer
  pool: healer
 state: ONLINE
  scan: scrub repaired 66.5M in 0h2m with 0 errors on Mon Dec 10 12:26:25 2012
config:

    NAME        STATE     READ WRITE CKSUM
    healer      ONLINE       0     0     0
      mirror-0  ONLINE       0     0     0
       ada0     ONLINE       0     0     0
       ada1     ONLINE       0     0     0

errors: No known data errors
```

The pool is now back to a fully working state, with all error counts now zero.

### 22.3.9. Growing a Pool

每个 vdev 中最小的设备限制了冗余池的可用大小。用较大的设备替换最小的设备。完成替换或 resilver 操作后，池可以增长以利用新设备的容量。例如，考虑一个 1 TB 驱动器和一个 2 TB 驱动器的镜像。可用空间为 1 TB。当用另一个 2 TB 驱动器替换 1 TB 驱动器时，resilvering 过程将现有数据复制到新驱动器上。由于两个设备现在都具有 2 TB 容量，镜像的可用空间增加到 2 TB。

通过在每个设备上使用 zpool online -e 开始扩展。扩展所有设备后，额外的空间变为池可用。

### 导入和导出池

在将存储池移动到另一个系统之前导出它们。ZFS 卸载所有数据集，将每个设备标记为已导出，但仍然锁定以防止其他磁盘使用。这能让在支持 ZFS 的其他机器、其他操作系统甚至不同的硬件架构上导入存储池（但有一些注意事项，请参阅 zpool(8)）。当数据集有打开文件时，使用 zpool export -f 强制导出存储池。请谨慎使用。数据集将被强制卸载，可能导致那些数据集上有打开文件的应用程序出现意外行为。

导出未使用的存储池：

```
# zpool export mypool
```

导入存储池会自动挂载数据集。如果这是不希望的行为，请使用 zpool import -N 来阻止。zpool import -o 为此特定导入设置临时属性。zpool import altroot= 能让使用基本挂载点而不是文件系统根目录导入存储池。如果存储池最近在另一个系统上使用过且未正确导出，请使用 zpool import -f 强制导入。zpool import -a 导入所有似乎未被其他系统使用的存储池。

列出所有可用于导入的池：

```
# zpool import
   pool: mypool
     id: 9930174748043525076
  state: ONLINE
 action: The pool can be imported using its name or numeric identifier.
 config:

        mypool      ONLINE
          ada2p3    ONLINE
```

使用替代根目录导入池：

```
# zpool import -o altroot=/mnt mypool
# zfs list
zfs list
NAME                 USED  AVAIL  REFER  MOUNTPOINT
mypool               110K  47.0G    31K  /mnt/mypool
```

### 升级存储池 22.3.11。

在升级 FreeBSD 之后，或者从使用旧版本的系统导入池时，需手动将池升级到最新的 ZFS 版本以支持新功能。在升级之前考虑池是否可能在旧系统上导入。升级是一个单向过程。升级旧池是可能的，但是无法降级具有新功能的池。

将 v28 池升级以支持 Feature Flags ：

```
# zpool status
  pool: mypool
 state: ONLINE
status: The pool is formatted using a legacy on-disk format.  The pool can
        still be used, but some features are unavailable.
action: Upgrade the pool using 'zpool upgrade'.  Once this is done, the
        pool will no longer be accessible on software that does not support feat
        flags.
  scan: none requested
config:

        NAME        STATE     READ WRITE CKSUM
        mypool      ONLINE       0     0     0
          mirror-0  ONLINE       0     0     0
	    ada0    ONLINE       0     0     0
	    ada1    ONLINE       0     0     0

errors: No known data errors
# zpool upgrade
This system supports ZFS pool feature flags.

The following pools are formatted with legacy version numbers and are upgraded to use feature flags.
After being upgraded, these pools will no longer be accessible by software that does not support feature flags.

VER  POOL
---  ------------
28   mypool

Use 'zpool upgrade -v' for a list of available legacy versions.
Every feature flags pool has all supported features enabled.
# zpool upgrade mypool
This system supports ZFS pool feature flags.

Successfully upgraded 'mypool' from version 28 to feature flags.
Enabled the following features on 'mypool':
  async_destroy
  empty_bpobj
  lz4_compress
  multi_vdev_crash_dump
```

在 zpool upgrade 完成之前，ZFS 的新功能将不可用。使用 zpool upgrade -v 查看升级提供的新功能，以及已支持哪些功能。

将游泳池升级以支持新的功能标志：

```
# zpool status
  pool: mypool
 state: ONLINE
status: Some supported features are not enabled on the pool. The pool can
        still be used, but some features are unavailable.
action: Enable all features using 'zpool upgrade'. Once this is done,
        the pool may no longer be accessible by software that does not support
        the features. See zpool-features(7) for details.
  scan: none requested
config:

        NAME        STATE     READ WRITE CKSUM
        mypool      ONLINE       0     0     0
          mirror-0  ONLINE       0     0     0
	    ada0    ONLINE       0     0     0
	    ada1    ONLINE       0     0     0

errors: No known data errors
# zpool upgrade
This system supports ZFS pool feature flags.

All pools are formatted using feature flags.

Some supported features are not enabled on the following pools. Once a
feature is enabled the pool may become incompatible with software
that does not support the feature. See zpool-features(7) for details.

POOL  FEATURE
---------------
zstore
      multi_vdev_crash_dump
      spacemap_histogram
      enabled_txg
      hole_birth
      extensible_dataset
      bookmarks
      filesystem_limits
# zpool upgrade mypool
This system supports ZFS pool feature flags.

Enabled the following features on 'mypool':
  spacemap_histogram
  enabled_txg
  hole_birth
  extensible_dataset
  bookmarks
  filesystem_limits
```

```
# gpart bootcode -b /boot/pmbr -p /boot/gptzfsboot -i 1 ada1
```

对使用 EFI 进行引导的系统，执行以下命令：

```
# gpart bootcode -p /boot/boot1.efifat -i 1 ada1
```

将引导码应用于池中的所有可引导磁盘。有关更多信息，请参阅 gpart(8)。

### 22.3.12. 显示记录的池历史

ZFS 记录改变池的命令，包括创建数据集、修改属性或替换磁盘。查看有关池创建的历史非常有用，还可以检查执行特定操作的用户及其时间。历史记录不保存在日志文件中，而是作为池的一部分。查看此历史记录的命令恰如其分地称为 zpool history ：

```
# zpool history
History for 'tank':
2013-02-26.23:02:35 zpool create tank mirror /dev/ada0 /dev/ada1
2013-02-27.18:50:58 zfs set atime=off tank
2013-02-27.18:51:09 zfs set checksum=fletcher4 tank
2013-02-27.18:51:18 zfs create tank/backup
```

输出显示 zpool 和 zfs 命令在某种方式上改变池，以及时间戳。不包括像 zfs list 这样的命令。当未指定池名称时，ZFS 显示所有池的历史记录。

zpool history 在提供选项 -i 或 -l 时可以显示更多信息。-i 显示用户发起的事件以及内部记录的 ZFS 事件。

```
# zpool history -i
History for 'tank':
2013-02-26.23:02:35 [internal pool create txg:5] pool spa 28; zfs spa 28; zpl 5;uts  9.1-RELEASE 901000 amd64
2013-02-27.18:50:53 [internal property set txg:50] atime=0 dataset = 21
2013-02-27.18:50:58 zfs set atime=off tank
2013-02-27.18:51:04 [internal property set txg:53] checksum=7 dataset = 21
2013-02-27.18:51:09 zfs set checksum=fletcher4 tank
2013-02-27.18:51:13 [internal create txg:55] dataset = 39
2013-02-27.18:51:18 zfs create tank/backup
```

通过添加 -l 来显示更多详细信息。以长格式显示历史记录，包括发出命令的用户名和发生更改的主机名等信息。

```
# zpool history -l
History for 'tank':
2013-02-26.23:02:35 zpool create tank mirror /dev/ada0 /dev/ada1 [user 0 (root) on :global]
2013-02-27.18:50:58 zfs set atime=off tank [user 0 (root) on myzfsbox:global]
2013-02-27.18:51:09 zfs set checksum=fletcher4 tank [user 0 (root) on myzfsbox:global]
2013-02-27.18:51:18 zfs create tank/backup [user 0 (root) on myzfsbox:global]
```

输出显示 root 用户使用磁盘 /dev/ada0 和 /dev/ada1 创建了镜像池。在池创建后的命令中还显示主机名 myzfsbox。在将池从一个系统导出并导入到另一个系统时，主机名显示变得重要。可以通过为每个命令记录的主机名区分在另一个系统上发出的命令。

将两种选项 zpool history 结合起来，为任何给定的池提供尽可能详细的信息。池历史在查找执行的操作或需要更详细的调试输出时提供有价值的信息。

### 22.3.13. 性能监控

内置监视系统可以实时显示池 I/O 统计信息。它显示池中的可用空间和已使用空间量，每秒执行的读取和写入操作次数，以及使用的 I/O 带宽。默认情况下，ZFS 监视并显示系统中的所有池。提供池名称以限制监视到该池。一个基本示例：

```
# zpool iostat
               capacity     operations    bandwidth
pool        alloc   free   read  write   read  write
----------  -----  -----  -----  -----  -----  -----
data         288G  1.53T      2     11  11.3K  57.1K
```

持续查看 I/O 活动，请在最后一个参数指定一个数字，表示更新之间等待的秒数间隔。每个间隔后都会打印下一个统计行。按 Ctrl+C 停止此连续监视。在间隔后的命令行上给出第二个数字，以指定要显示的统计信息总数。

使用 -v 显示更详细的 I/O 统计信息。池中的每个设备都会显示统计信息行。这对于查看在每个设备上执行的读写操作非常有用，并可以帮助确定是否有任何个别设备减慢了池的速度。此示例显示了一个具有两个设备的镜像池：

```
# zpool iostat -v
                            capacity     operations    bandwidth
pool                     alloc   free   read  write   read  write
-----------------------  -----  -----  -----  -----  -----  -----
data                      288G  1.53T      2     12  9.23K  61.5K
  mirror                  288G  1.53T      2     12  9.23K  61.5K
    ada1                     -      -      0      4  5.61K  61.7K
    ada2                     -      -      1      4  5.04K  61.7K
-----------------------  -----  -----  -----  -----  -----  -----
```

### 22.3.14. 分割存储池

ZFS 可以将由一个或多个镜像 vdev 组成的池分割成两个池。除非另有指定，否则 ZFS 会分离每个镜像的最后一个成员，并创建一个包含相同数据的新池。确保首先使用 -n 进行试运行操作。这将显示所请求操作的详细信息，但实际上不执行操作。这有助于确认操作是否符合用户的意图。
