# 22.6.高级主题

### 22.6.1. 调整

调整可调参数，使 ZFS 在不同工作负载下表现最佳。

* vfs.zfs.arc.max 从 13.x 开始（ vfs.zfs.arc_max 适用于 12.x）- ARC 的上限大小。默认值为所有 RAM 减去 1 GB，或所有 RAM 的 5/8，以较大者为准。如果系统运行任何其他守护程序或进程可能需要内存，请使用较低的值。可以使用 sysctl(8) 在运行时调整此值，并在 /boot/loader.conf 或 /etc/sysctl.conf 中设置。
* vfs.zfs.arc.meta_limit 从 13.x 开始（ vfs.zfs.arc_meta_limit 适用于 12.x）- 限制用于存储元数据的 ARC 使用量。默认值为总 RAM 的四分之一。如果工作负载涉及大量文件和目录的操作，或频繁的元数据操作，增加此值将提高性能，但会减少文件数据在 ARC 中的容纳量。可以使用 sysctl(8) 在运行时调整此值，并在 /boot/loader.conf 或 /etc/sysctl.conf 中设置。
* vfs.zfs.arc.min 从 13.x 开始（ vfs.zfs.arc_min 适用于 12.x）- 降低 ARC 的大小。默认值为一半的 vfs.zfs.arc.meta_limit。调整此值以防止其他应用程序将整个 ARC 压力过大。可以使用 sysctl(8) 在运行时和在 /boot/loader.conf 或 /etc/sysctl.conf 中调整此值。
* vfs.zfs.vdev.cache.size - 为池中的每个设备预先分配的一定数量的内存，作为缓存。使用的内存总量将是此值乘以设备数量。在启动时和在 /boot/loader.conf 中设置此值。
* vfs.zfs.min_auto_ashift - 降低在池创建时自动使用的 ashift （扇区大小）。该值是 2 的幂。9 的默认值代表 2^9 = 512，即 512 字节的扇区大小。为避免写放大并获得最佳性能，请将此值设置为池中设备使用的最大扇区大小。
  常见驱动器具有 4 KB 扇区。在这些驱动器上使用默认 ashift 会导致写放大。单个 4 KB 写入包含的数据实际上会以八个 512 字节写入。ZFS 在创建池时会尝试从所有设备读取原生扇区大小，但具有 4 KB 扇区的驱动器报告其扇区为 512 字节以实现兼容性。在创建池之前将 2^12 = 4096 设置为 12 （ 2^12 = 4096 ），可以强制 ZFS 在这些驱动器上使用 4 KB 块以获得最佳性能。
  强制使用 4 KB 块在计划进行磁盘升级的池中也很有用。未来的磁盘将使用 4 KB 扇区，ashift 值在创建池后无法更改。
  在一些特定情况下，较小的 512 字节块大小可能更可取。与 512 字节磁盘一起用于数据库或作为虚拟机存储时，小型随机读取期间的数据传输较少。这在使用较小的 ZFS 记录大小时可以提供更好的性能。
* vfs.zfs.prefetch_disable - 禁用预取。值为 0 启用，1 禁用。默认为 0，除非系统内存少于 4 GB。预取通过将比请求更大的块读入 ARC 中，希望很快需要这些数据来工作。如果工作负载有大量随机读取，禁用预取可能通过减少不必要的读取来提高性能。随时使用 sysctl(8) 调整此值。
* vfs.zfs.vdev.trim_on_init - 控制是否对添加到池中的新设备运行 TRIM 命令。这确保了 SSD 的最佳性能和寿命，但需要额外时间。如果设备已经安全擦除，禁用此设置将使新设备的添加速度更快。随时使用 sysctl(8) 调整此值。
* vfs.zfs.vdev.max_pending - 限制每个设备的挂起 I/O 请求数量。较高的值将保持设备命令队列满，并可能提供更高的吞吐量。较低的值将减少延迟。随时使用 sysctl(8) 调整此值。
* vfs.zfs.top_maxinflight - 顶层 vdev 每个的最大未完成 I/O 数。限制命令队列的深度以防止高延迟。此限制是针对每个顶层 vdev 的，意味着限制独立应用于每个镜像、RAID-Z 或其他 vdev。随时使用 sysctl(8) 调整此值。
* vfs.zfs.l2arc_write_max - 每秒写入 L2ARC 的数据量。通过限制写入设备的数据量，此可调节控制器延长了 SSD 的寿命。随时使用 sysctl(8) 调整此值。
* vfs.zfs.l2arc_write_boost - 将此可调节控制器的值加到 vfs.zfs.l2arc_write_max 并增加对 SSD 的写入速度，直至从 L2ARC 驱逐第一个块。此“Turbo Warmup 阶段”减少了在重启后从空 L2ARC 中的性能损失。随时使用 sysctl(8) 调整此值。
* vfs.zfs.scrub_delay - 在 scrub 过程中每个 I/O 之间延迟的滴答数。为确保 scrub 不会干扰池的正常运行，如果有任何其他 I/O 正在进行，scrub 将在每个命令之间延迟。此值控制由 scrub 生成的总 IOPS（每秒 I/O 次数）的限制。设置的粒度由 kern.hz 的值确定，默认为每秒 1000 滴答。更改此设置会导致不同的有效 IOPS 限制。默认值为 4，导致限制为：1000 滴答/秒 / 4 = 250 IOPS。使用值为 20 将导致限制为：1000 滴答/秒 / 20 = 50 IOPS。池上的最近活动限制了 scrub 的速度，由 vfs.zfs.scan_idle 确定。随时使用 sysctl(8) 调整此值。
* vfs.zfs.resilver_delay - 在 resilver 过程中每个 I/O 之间插入的延迟毫秒数。为确保 resilver 不会干扰池的正常运行，如果有任何其他 I/O 正在进行，resilver 将在每个命令之间延迟。此值控制由 resilver 生成的总 IOPS（每秒 I/O 次数）的限制。ZFS 通过 kern.hz 的值（默认为每秒 1000 滴答）确定设置的粒度。更改此设置会导致不同的有效 IOPS 限制。默认值为 2，导致限制为：1000 滴答/秒 / 2 = 500 IOPS。如果另一个设备故障可能导致池故障，造成数据丢失，则将池恢复到在线状态可能更为重要。值为 0 将使 resilver 操作具有与其他操作相同的优先级，加快恢复过程。池上的其他最近活动限制了 resilver 的速度，由 vfs.zfs.scan_idle 确定。随时使用 sysctl(8) 调整此值。
* vfs.zfs.scan_idle - 在考虑池处于空闲状态之前经过的毫秒数。当池处于空闲状态时，ZFS 会禁用 scrub 和 resilver 的速率限制。随时使用 sysctl(8) 调整此值。
* vfs.zfs.txg.timeout - 事务组之间的最长秒数。当前事务组写入池，并且如果自上一个事务组以来已经过去了这么长的时间，则会启动一个新的事务组。如果写入足够的数据，事务组可能会更早触发。默认值为 5 秒。较大的值可能通过延迟异步写操作来改善读取性能，但这可能会导致写入事务组时性能不均匀。随时使用 sysctl(8)调整此值。

### 22.6.2. i386 上的 ZFS

ZFS 提供的一些功能消耗大量内存，并且在具有有限 RAM 的系统上可能需要进行调整以实现更高的效率。

#### 22.6.2.1. 存储器

作为较低值，总系统存储器应至少为一千兆字节。推荐的 RAM 量取决于池的大小以及 ZFS 使用的功能。一个经验法则是每 1 TB 存储空间需要 1 GB RAM。如果使用去重功能，一个经验法则是每 TB 存储空间需要 5 GB RAM 用于去重。虽然一些用户使用较少 RAM 运行 ZFS，但在负载较重的系统下，可能会因内存耗尽而发生紧急情况。对于低于推荐 RAM 要求的系统，可能需要进一步调整 ZFS。

#### 22.6.2.2. 内核配置

由于 i386™ 平台的地址空间限制，i386™ 架构上的 ZFS 用户必须将此选项添加到定制内核配置文件中，重新构建内核，然后重启：

 选项 KVA_PAGES=512

这将扩展内核地址空间，能让 vm.kvm_size 可调参数超出 1 GB 的限制，或者对于 PAE，超出 2 GB 的限制。要找到此选项的最合适值，请将所需地址空间以兆字节为单位除以四。在此示例中 512 为 2 GB。

#### 22.6.2.3。加载机调整

在所有 FreeBSD 架构上增加 kmem 地址空间。具有 1 GB 物理内存的测试系统受益于将这些选项添加到 /boot/loader.conf，然后重启：

vm.kmem_size="330M" vm.kmem_size_max="330M" vfs.zfs.arc.max="40M" vfs.zfs.vdev.cache.size="5M"

有关 ZFS 相关调优建议的更详细列表，请参阅 https://wiki.freebsd.org/ZFSTuningGuide。
