# 24.3.使用 macOS® 上的 VMware Fusion 安装 FreeBSD

VMware Fusion for Mac® 是一款商业软件产品，适用于运行 macOS® 12 或更高版本的 Apple® Mac® 计算机。FreeBSD 是一个完全支持的客户操作系统。在 macOS® 上安装了 VMware Fusion 之后，用户就可以配置虚拟机，然后安装所需的客户操作系统。

### 在 VMware Fusion 上安装 FreeBSD 24.3.1 版

第一步是启动 VMware Fusion，加载虚拟机库。点击 +→New 创建虚拟机：

![vmware freebsd01](https://docs.freebsd.org/images/books/handbook/virtualization/vmware-freebsd01.png)

这将加载新虚拟机助理。选择创建自定义虚拟机，然后点击继续：

![vmware freebsd02](https://docs.freebsd.org/images/books/handbook/virtualization/vmware-freebsd02.png)

选择其他作为操作系统，当提示时选择 FreeBSD X 或 FreeBSD X 64 位，作为版本：

![vmware freebsd03](https://docs.freebsd.org/images/books/handbook/virtualization/vmware-freebsd03.png)

选择固件（建议使用 UEFI）：

![vmware freebsd04](https://docs.freebsd.org/images/books/handbook/virtualization/vmware-freebsd04.png)

选择创建新的虚拟磁盘并单击“继续”：

![vmware freebsd05](https://docs.freebsd.org/images/books/handbook/virtualization/vmware-freebsd05.png)

检查配置并单击完成：

![vmware freebsd06](https://docs.freebsd.org/images/books/handbook/virtualization/vmware-freebsd06.png)

选择虚拟机的名称和应该保存的目录：

![vmware freebsd07](https://docs.freebsd.org/images/books/handbook/virtualization/vmware-freebsd07.png)

按下 Command+E 打开虚拟机设置，然后单击 CD/DVD：

![vmware freebsd08](https://docs.freebsd.org/images/books/handbook/virtualization/vmware-freebsd08.png)

选择 FreeBSD 的 ISO 镜像或来自 CD/DVD：

![vmware freebsd09](https://docs.freebsd.org/images/books/handbook/virtualization/vmware-freebsd09.png)

启动虚拟机：

![vmware freebsd10](https://docs.freebsd.org/images/books/handbook/virtualization/vmware-freebsd10.png)

像平常安装 FreeBSD：

![vmware freebsd11](https://docs.freebsd.org/images/books/handbook/virtualization/vmware-freebsd11.png)

若安装完成，就可以修改虚拟机的设置，比如内存使用量以及虚拟机可以访问的 CPU 数量：

|  | 虚拟机运行时无法修改虚拟机的系统硬件设置。|
| -- | -------------------------------------------- |

![vmware freebsd12](https://docs.freebsd.org/images/books/handbook/virtualization/vmware-freebsd12.png)

光驱设备的状态。通常在不再需要时，光盘/ DVD/ ISO 会被从虚拟机断开连接。

![vmware freebsd09](https://docs.freebsd.org/images/books/handbook/virtualization/vmware-freebsd09.png)

最后要更改的是虚拟机将如何连接到网络。要允许虚拟机从除主机以外的其他机器进行连接，请选择直接连接到物理网络（桥接）。否则，共享主机的互联网连接（NAT）是首选的，这样虚拟机可以访问互联网，但网络无法访问虚拟机。

![vmware freebsd13](https://docs.freebsd.org/images/books/handbook/virtualization/vmware-freebsd13.png)

修改设置后，启动新安装的 FreeBSD 虚拟机。

### 在 VMware Fusion 上配置 FreeBSD 24.3.2。

在 macOS® X 上使用 VMware Fusion 成功安装 FreeBSD 后，可以采取一些配置步骤来优化虚拟化操作系统。

1. 设置启动加载程序变量，最重要的步骤是减少 kern.hz 的可调参数，以减少在 VMware Fusion 环境下 FreeBSD 的 CPU 利用率。这可以通过将以下行添加到/boot/loader.conf 文件中来实现：

    ```
    kern.hz=100
    ```

    没有此设置，空闲的 FreeBSD VMware Fusion 客户端将使用大约相当于单处理器 iMac®15%的 CPU。更改后，使用率将接近 5%。
2. 创建新的内核配置文件可以从定制的内核配置文件中删除所有 FireWire 和 USB 设备驱动程序。VMware Fusion 提供了一个虚拟网络适配器，由 em(4)驱动程序使用，因此除 em(4)外的所有网络设备都可以从内核中删除。
3. 配置网络最基本的网络设置使用 DHCP 将虚拟机连接到主机 Mac®相同的局域网。这可以通过将 ifconfig_em0="DHCP" 添加到/etc/rc.conf 来实现。高级网络设置在高级网络中有说明。
4. 安装驱动程序和 open-vm-tools 为了在 VMWare 上平稳运行 FreeBSD，应安装驱动程序：

    ```
    # pkg install xf86-video-vmware xf86-input-vmmouse open-vm-tools
    ```
