# 24.4.使用 VirtualBox™ 安装 FreeBSD

FreeBSD 在 VirtualBox™中作为一个客户端运行得非常好。这款虚拟化软件适用于大多数常见的操作系统，包括 FreeBSD 本身。

虚拟盒™ 客户附件提供支持：

* 剪贴板共享。
* 鼠标指针集成。
* 主机时间同步。
* 窗口缩放。
* 无缝模式。

|  | 这些命令在 FreeBSD guest 中运行。|
| -- | ----------------------------------- |

首先，在 FreeBSD guest 中安装 emulators/virtualbox-ose-additions 软件包或port。这将安装port：

```
# cd /usr/ports/emulators/virtualbox-ose-additions && make install clean
```

将这些行添加到/etc/rc.conf 中：

```
vboxguest_enable="YES"
vboxservice_enable="YES"
```

如果使用 ntpd(8) 或 ntpdate(8)，请禁用主机时间同步：

```
vboxservice_flags="--disable-timesync"
```

Xorg 将自动识别 vboxvideo 驱动程序。也可以在 /etc/X11/xorg.conf 中手动输入：

```
Section "Device"
	Identifier "Card0"
	Driver "vboxvideo"
	VendorName "InnoTek Systemberatung GmbH"
	BoardName "VirtualBox Graphics Adapter"
EndSection
```

要使用 vboxmouse 驱动程序，请调整 /etc/X11/xorg.conf 中的鼠标部分：

```
Section "InputDevice"
	Identifier "Mouse0"
	Driver "vboxmouse"
EndSection
```

通过挂载它们使用 mount_vboxvfs 可以访问主机和虚拟机之间用于文件传输的共享文件夹。可以使用 VirtualBox GUI 在主机上创建共享文件夹，也可以通过 vboxmanage 进行创建。例如，要为名为 BSDBox 的虚拟机在 /mnt/bsdboxshare 下创建一个名为 myshare 的共享文件夹，请运行：

```
# vboxmanage sharedfolder add 'BSDBox' --name myshare --hostpath /mnt/bsdboxshare
```

请注意，共享文件夹名称不能包含空格。在客户系统内部挂载共享文件夹，如下所示：

```
# mount_vboxvfs -w myshare /mnt
```
