# 24.5.在 FreeBSD 上安装 VirtualBox™

VirtualBox™ 是一个积极开发的完整虚拟化套件，适用于大多数操作系统，包括 Windows®、macOS®、Linux® 和 FreeBSD。它同样能够运行 Windows® 或类 UNIX® 的客户机。它作为开源软件发布，但也有闭源组件可在单独的扩展包中使用。这些组件包括对 USB 2.0 设备的支持。有关更多信息，请参阅 VirtualBox™ 维基的下载页面。目前，这些扩展不适用于 FreeBSD。

### 24.5.1. 安装 VirtualBox™

VirtualBox™ 可作为 FreeBSD 软件包或在 emulators/virtualbox-ose 中作为 port 提供。可以使用以下命令安装 port：

```
# cd /usr/ports/emulators/virtualbox-ose
# make install clean
```

在 port 的配置菜单中，一个有用的选项是 GuestAdditions 程序套件。这些程序在客户操作系统中提供了许多有用的功能，如鼠标指针集成（能让在主机和客户之间共享鼠标，无需按特殊键盘快捷键切换）和更快的视频渲染，特别是在 Windows® 客户中。在安装客户端完成后，客户端附加功能可在“设备”菜单中找到。

第一次启动 VirtualBox™ 之前需要进行一些配置更改。port 安装一个内核模块到 /boot/modules，必须加载到正在运行的内核中：

```
# kldload vboxdrv
```

为了确保模块在重启后始终被加载，请将此行添加到 /boot/loader.conf：

```
vboxdrv_load="YES"
```

要使用允许桥接或主机专用网络的内核模块，请将此行添加到 /etc/rc.conf 并重启计算机：

```
vboxnet_enable="YES"
```

在安装 VirtualBox™时会创建 vboxusers 组。所有需要访问 VirtualBox™的用户都必须添加为该组的成员。pw 可用于添加新成员：

```
# pw groupmod vboxusers -m yourusername
```

/dev/vboxnetctl 的默认权限较为严格，需要更改以用于桥接网络：

```
# chown root:vboxusers /dev/vboxnetctl
# chmod 0660 /dev/vboxnetctl
```

要使这个权限更改永久生效，请将以下行添加到/etc/devfs.conf 中：

```
own     vboxnetctl root:vboxusers
perm    vboxnetctl 0660
```

启动 VirtualBox™，从 Xorg 会话中输入：

```
% VirtualBox
```

有关配置和使用 VirtualBox™ 的更多信息，请参阅官方网站。有关 FreeBSD 特定信息和故障排除说明，请参阅 FreeBSD wiki 中的相关页面。

### 24.5.2. VirtualBox™ USB 支持

VirtualBox™ 可以配置为将 USB 设备传递给客户操作系统。OSE 版本的主控制器仅能模拟 USB 1.1 设备，直到支持 USB 2.0 和 3.0 设备的扩展包在 FreeBSD 上可用为止。

要使 VirtualBox™ 感知连接到计算机的 USB 设备，用户需要成为 operator 组的成员。

```
# pw groupmod operator -m yourusername
```

然后，将以下内容添加到 /etc/devfs.rules，或者如果该文件尚不存在，则创建此文件。

```
[system=10]
add path 'usb/*' mode 0660 group operator
```

要加载这些新规则，请将以下内容添加到 /etc/rc.conf 文件中：

```
devfs_system_ruleset="system"
```

 然后，重启 devfs：

```
# service devfs restart
```

重启登录会话和 VirtualBox™ 以使这些更改生效，并根据需要创建 USB 过滤器。

### 24.5.3. VirtualBox™ 宿主 DVD/CD 访问

通过共享物理驱动器来实现客户机对宿主 DVD/CD 驱动器的访问。在 VirtualBox™ 中，可以在虚拟机的设置中的存储窗口中设置此功能。如有需要，首先创建一个空的 IDECD/DVD 设备。然后从弹出菜单中为虚拟 CD/DVD 驱动器选择宿主驱动器。一个标记为 Passthrough 的复选框将出现。这能让虚拟机直接使用硬件。例如，只有选择此选项才能使用音频 CD 或刻录机。

为了用户能够使用 VirtualBox™ DVD/CD 功能，他们需要访问 /dev/xpt0，/dev/cdN 和 /dev/passN。通常通过将用户添加到 operator 组来实现此功能。必须通过向 /etc/devfs.conf 添加以下行来更正对这些设备的权限：

```
perm cd* 0660
perm xpt0 0660
perm pass* 0660
```

```
# service devfs restart
```
