# 24.7.基于 FreeBSD 的 Xen™ 虚拟机

Xen 是一款基于 GPLv2 许可的 Intel®和 ARM®架构的类型 1 虚拟机监控程序。自 FreeBSD 8.0 以来，FreeBSD 已经包含了 i386™和 AMD® 64 位 DomU 以及 Amazon EC2 非特权域（虚拟机）支持，并在 FreeBSD 11.0 中包括了 Dom0 控制域（宿主）支持。在 FreeBSD 11 中，对 para-virtualized（PV）域的支持已被移除，改为支持硬件虚拟化（HVM）域，这能提供更好的性能。

Xen™ 是一种裸金属虚拟化程序，这意味着它是在 BIOS 之后加载的第一个程序。然后启动一个特权的特殊客户端，称为 Domain-0（简称为 Dom0 ）。Dom0 利用其特权直接访问底层物理硬件，使其成为高性能解决方案。它能够直接访问磁盘控制器和网络适配器。Xen™ 管理工具用于管理和控制 Xen™ 虚拟化程序，Dom0 还用于创建、列出和销毁虚拟机。Dom0 为非特权域提供虚拟磁盘和网络，通常称为 DomU。Xen™ Dom0 可以与其他虚拟化解决方案的服务控制台进行比较，而 DomU 是运行各个客户端虚拟机的地方。

Xen™ 可以在不同的 Xen™ 服务器之间迁移虚拟机。当两个 Xen 主机共享相同的底层存储时，迁移可以在不必先关闭虚拟机的情况下完成。相反，迁移是在 DomU 运行时执行的，无需重启或计划停机时间。这在维护场景或升级窗口中非常有用，以确保 DomU 提供的服务仍在提供。Xen™ 的许多其他功能列在 Xen Wiki 概述页面上。请注意，并非所有功能都在 FreeBSD 上得到支持。

### 24.7.1. Xen™ Dom0 的硬件要求

要在主机上运行 Xen™虚拟机监控程序，需要一定的硬件功能。硬件虚拟化域需要主机处理器中的扩展页表（EPT）和输入/输出内存管理单元（IOMMU）支持。

|  | 要运行 FreeBSD Xen™ Dom0，必须使用传统引导（BIOS）引导该计算机。|
| -- | ------------------------------------------------------------------- |

### 24.7.2. Xen™ Dom0 控制域设置

用户应安装基于 Xen™ 4.18 的 emulators/xen-kernel 和 sysutils/xen-tools 软件包。

安装 Xen 软件包后，必须编辑配置文件以准备 Dom0 集成。在 /etc/sysctl.conf 中添加条目以禁用内存页线缆的限制。否则，具有更高内存需求的 DomU VM 可能无法运行。

```
# echo 'vm.max_wired=-1' >> /etc/sysctl.conf
```

另一个与内存相关的设置涉及更改 /etc/login.conf，将 memorylocked 选项设置为 unlimited。否则，创建 DomU 域可能会失败，显示 Cannot allocate memory 错误。在修改 /etc/login.conf 后，运行 cap_mkdb 更新能力数据库。有关详细信息，请参阅资源限制。

```
# sed -i '' -e 's/memorylocked=64K/memorylocked=unlimited/' /etc/login.conf
# cap_mkdb /etc/login.conf
```

在/etc/ttys 中添加 Xen™控制台的条目:

```
# echo 'xc0     "/usr/libexec/getty Pc"         xterm   onifconsole  secure' >> /etc/ttys
```

在/boot/loader.conf 中选择 Xen™内核会激活 Dom0。Xen™还需要来自主机的 CPU 和内存等资源，用于自身和其他 DomU 域。CPU 和内存的需求量取决于个体需求和硬件能力。在本例中，为 Dom0 提供了 8 GB 的内存和 4 个虚拟 CPU。串行控制台也被激活，并定义了日志选项。

用于 Xen 4.7 软件包的以下命令:

```
# echo 'hw.pci.mcfg=0' >> /boot/loader.conf
# echo 'if_tap_load="YES"' >> /boot/loader.conf
# echo 'xen_kernel="/boot/xen"' >> /boot/loader.conf
# echo 'xen_cmdline="dom0_mem=8192M dom0_max_vcpus=4 dom0pvh=1 console=com1,vga com1=115200,8n1 guest_loglvl=all loglvl=all"' >> /boot/loader.conf
```

对于 Xen 版本 4.11 及更高版本，应改用以下命令：

```
# echo 'if_tap_load="YES"' >> /boot/loader.conf
# echo 'xen_kernel="/boot/xen"' >> /boot/loader.conf
# echo 'xen_cmdline="dom0_mem=8192M dom0_max_vcpus=4 dom0=pvh console=com1,vga com1=115200,8n1 guest_loglvl=all loglvl=all"' >> /boot/loader.conf
```

|  | Xen™ 为 DomU VMs 创建的日志文件存储在 /var/log/xen。如果遇到问题，请务必检查该目录的内容。|
| -- | --------------------------------------------------------------------------------------------- |

在系统启动期间激活 xencommons 服务：

```
# sysrc xencommons_enable=yes
```

这些设置足以启动一个启用 Dom0 的系统。然而，对于 DomU 虚拟机来说，它缺少网络功能。为了解决这个问题，请使用系统的主网卡定义一个桥接接口，DomU 虚拟机可以使用它连接到网络。将 em0 替换为主机网络接口名称。

```
# sysrc cloned_interfaces="bridge0"
# sysrc ifconfig_bridge0="addm em0 SYNCDHCP"
# sysrc ifconfig_em0="up"
```

重启主机以加载 Xen™ 内核并启动 Dom0。

```
# reboot
```

成功启动 Xen™ 内核并再次登录系统后，Xen™ 管理工具 xl 用于显示有关域的信息。

```
# xl list
Name                                        ID   Mem VCPUs      State   Time(s)
Domain-0                                     0  8192     4     r-----     962.0
```

输出确认 Dom0（称为 Domain-0 ）具有 ID 0 并正在运行。它还具有在 /boot/loader.conf 中定义的内存和虚拟 CPU。更多信息可以在 Xen™ 文档中找到。现在可以创建 DomU 客户 VM。

### 24.7.3. Xen™ DomU 客户 VM 配置

非特权域包括配置文件和虚拟或物理硬盘。DomU 的虚拟磁盘存储可以是由 truncate(1) 创建的文件或 ZFS 卷，如“创建和销毁卷”中所述。在这个示例中，使用了一个 20 GB 的卷。使用 ZFS 卷、FreeBSD ISO 映像、1 GB RAM 和两个虚拟 CPU 创建了一个 VM。ISO 安装文件使用 fetch(1) 检索并保存在名为 freebsd.iso 的本地文件中。

```
# fetch https://download.freebsd.org/releases/ISO-IMAGES/14.0/FreeBSD-14.0-RELEASE-amd64-bootonly.iso -o freebsd.iso
```

创建一个名为 xendisk0 的 20 GB 的 ZFS 卷，用作 VM 的磁盘空间。

```
# zfs create -V20G -o volmode=dev zroot/xendisk0
```

在文件中定义新的 DomU 客户 VM。还定义了一些特定的设置，如名称、键盘映射和 VNC 连接详细信息。以下是 freebsd.cfg，其中包含此示例的最小 DomU 配置：

```
# cat freebsd.cfg
builder = "hvm" 
name = "freebsd" 
memory = 1024 
vcpus = 2 
vif = [ 'mac=00:16:3E:74:34:32,bridge=bridge0' ] 
disk = [
'/dev/zvol/tank/xendisk0,raw,hda,rw', 
'/root/freebsd.iso,raw,hdc:cdrom,r' 
  ]
vnc = 1 
vnclisten = "0.0.0.0"
serial = "pty"
usbdevice = "tablet"
```

这些行将进行更详细的解释：

|  | 定义要使用的虚拟化类型。hvm 指的是硬件辅助虚拟化或硬件虚拟机。客体操作系统可以在具有虚拟化扩展的 CPU 上无需修改地运行，几乎与在物理硬件上运行时一样性能。generic 是默认值，创建一个 PV 域。         |
| -- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
|  | 用于区分此虚拟机与在同一 Dom0 上运行的其他虚拟机的名称。必需的。                                                                                                                                       |
|  | 要为 VM 提供的以兆字节为单位的 RAM 数量。此量减去超控程序的可用内存总量，而不是 Dom0 的内存。                                                                                                         |
|  | 宿主机上可用于虚拟机客户机的虚拟 CPU 数量。为了获得最佳性能，请不要为客户机创建比主机上物理 CPU 数量更多的虚拟 CPU。                                                                                   |
|  | 虚拟网络适配器。这是连接到主机网络接口的桥接器。mac 参数是设置在虚拟网络接口上的 MAC 地址。此参数是可选的，如果没有提供 MAC 地址，Xen™ 将生成一个随机的 MAC 地址。                                   |
|  | 用于此虚拟机的磁盘、文件或 ZFS 卷的完整路径。选项和多个磁盘定义用逗号分隔。                                                                                                                            |
|  | 定义从中安装初始操作系统的启动介质。在此示例中，这是之前下载的 ISO 镜像。请参阅 Xen™ 文档，了解其他类型的设备和设置选项。                                                                           |
|  | 控制 VNC 连接到 DomU 串行控制台的选项。依次，这些是：激活 VNC 支持，定义要监听的 IP 地址，串行控制台的设备节点，以及用于鼠标精确定位和其他输入方法的输入方法。keymap 定义要使用的键盘映射表，默认情况下为 english。|

在创建具有所有必要选项的文件后，通过将其传递给 xl create 作为参数来创建 DomU。

```
# xl create freebsd.cfg
```

|  | 每次重启 Dom0 时，必须再次传递配置文件给 xl create，以重新创建 DomU。默认情况下，重启后只会创建 Dom0，而不会创建各个 VM。由于 VM 将操作系统存储在虚拟磁盘上，因此 VM 可以从上次停止的地方继续。虚拟机配置可能随时间而变化（例如，当增加更多内存时）。必须正确备份虚拟机配置文件并使其可用，以便在需要时重新创建来宾 VM。|
| -- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

xl list 的输出确认了 DomU 已被创建。

```
# xl list
Name                                        ID   Mem VCPUs      State   Time(s)
Domain-0                                     0  8192     4     r-----  1653.4
freebsd                                      1  1024     1     -b----   663.9
```

要开始安装基本操作系统，请启动 VNC 客户端，将其定向到主机的主网络地址或指向 freebsd.cfg 中定义的 IP 地址行。在安装操作系统后，关闭 DomU 并断开 VNC 查看器。编辑 freebsd.cfg，删除包含 cdrom 定义的行，或在该行开头插入 # 字符对其进行注释。要加载此新配置，需要使用 xl destroy 删除旧的 DomU，并传递名称或 ID 作为参数。然后，使用修改后的 freebsd.cfg 重新创建它。

```
# xl destroy freebsd
# xl create freebsd.cfg
```

机器可以使用 VNC 查看器再次访问。这次，它将从已安装操作系统的虚拟磁盘启动，并可用作虚拟机。

### 24.7.4. 故障排除

本节包含基本信息，以帮助解决在将 FreeBSD 用作 Xen™ 主机或客户机时遇到的问题。

#### 24.7.4.1. 主机引导故障排除

请注意，以下故障排除技巧适用于 Xen™ 4.11 或更新版本。如果你仍在使用 Xen™ 4.7 并且遇到问题，请考虑迁移到更新版本的 Xen™。

为了排除主机引导问题，你可能需要串行电缆或调试 USB 电缆。可以通过向 loader.conf 中找到的 xen_cmdline 选项添加选项来获取详细的 Xen™ 引导输出。一些相关的调试选项包括：

* iommu=debug ：可用于打印有关 iommu 的附加诊断信息。
* dom0=verbose ：可用于打印有关 dom0 构建过程的附加诊断信息。
* sync_console ：用于强制同步控制台输出的标志。用于调试以避免由于速率限制而丢失消息，非常有用。绝不要在生产环境中使用此选项，因为它可以能让恶意的客户端通过控制台对 Xen™执行 DoS 攻击。

FreeBSD 也应该以详细模式启动，以便识别任何问题。要激活详细启动，请运行此命令：

```
# echo 'boot_verbose="YES"' >> /boot/loader.conf
```

如果这些选项都没有帮助解决问题，请将串行启动日志发送到 freebsd-xen@FreeBSD.org 和 xen-devel@lists.xenproject.org 以进行进一步分析。

#### 24.7.4.2. 客户端创建故障排除

创建来宾时也可能出现问题，以下尝试为那些试图诊断来宾创建问题的人提供一些帮助。

创建来宾失败的最常见原因是 xl 命令输出某些错误并以与 0 不同的返回代码退出。如果提供的错误不足以帮助识别问题，则还可以通过重复使用 v 选项从 xl 处获得更详细的输出。

```
# xl -vvv create freebsd.cfg
Parsing config from freebsd.cfg
libxl: debug: libxl_create.c:1693:do_domain_create: Domain 0:ao 0x800d750a0: create: how=0x0 callback=0x0 poller=0x800d6f0f0
libxl: debug: libxl_device.c:397:libxl__device_disk_set_backend: Disk vdev=xvda spec.backend=unknown
libxl: debug: libxl_device.c:432:libxl__device_disk_set_backend: Disk vdev=xvda, using backend phy
libxl: debug: libxl_create.c:1018:initiate_domain_create: Domain 1:running bootloader
libxl: debug: libxl_bootloader.c:328:libxl__bootloader_run: Domain 1:not a PV/PVH domain, skipping bootloader
libxl: debug: libxl_event.c:689:libxl__ev_xswatch_deregister: watch w=0x800d96b98: deregister unregistered
domainbuilder: detail: xc_dom_allocate: cmdline="", features=""
domainbuilder: detail: xc_dom_kernel_file: filename="/usr/local/lib/xen/boot/hvmloader"
domainbuilder: detail: xc_dom_malloc_filemap    : 326 kB
libxl: debug: libxl_dom.c:988:libxl__load_hvm_firmware_module: Loading BIOS: /usr/local/share/seabios/bios.bin
...
```

如果详细输出无法帮助诊断问题，则 /var/log/xen 中还有 QEMU 和 Xen™ toolstack 日志。请注意，域的名称会附加到日志名称中，因此如果域命名为 freebsd，则应找到 /var/log/xen/xl-freebsd.log 和可能是 /var/log/xen/qemu-dm-freebsd.log。两个日志文件都可能包含有用的调试信息。如果所有这些都无法解决问题，请将面临的问题描述和尽可能多的信息发送至 freebsd-xen@FreeBSD.org 和 xen-devel@lists.xenproject.org，以获取帮助。
