# 25.2.使用本地化

本地化设置基于三个组成部分：语言代码、国家代码和编码。区域设置名称由这些部分构成如下：

```
LanguageCode_CountryCode.Encoding
```

语言代码和国家代码用于确定国家和特定的语言变体。常见的语言和国家代码提供了一些 LanguageCode_CountryCode 的示例：

表 1. 常见的语言和国家代码

| LanguageCode\_Country Code | 说明           |
| ------------------------------- | ---------------- |
|en_US|English, United States|
|ru_RU|Russian, Russia|
|zh_TW|Traditional Chinese, Taiwan|

可以通过键入以下内容来查看所有可用区域设置：

```
% locale -a | more
```

要确定当前区域设置：

```
% locale
```

特定于语言的字符集，如 ISO8859-1、ISO8859-15、KOI8-R 和 CP437，在 multibyte(3)中有说明。字符集的活动列表可以在 IANA 注册表中找到。

一些语言，如中文或日文，无法用 ASCII 字符表示，需要使用宽字符或多字节字符进行扩展语言编码。宽字符或多字节编码的示例包括 EUC 和 Big5。旧应用程序可能会将这些编码误认为控制字符，而新应用程序通常能够识别这些字符。根据实现方式，用户可能需要使用宽字符或多字节字符支持编译应用程序，或正确配置它。

|  | FreeBSD 使用与 Xorg 兼容的区域设置编码。|
| -- | ------------------------------------------ |

本节的其余部分说明了在 FreeBSD 系统上配置区域设置的各种方法。下一节将讨论查找和编译具有 i18n 支持的应用程序时需要考虑的事项。

### 25.2.1. 为登录设置区域设置 Shell

区域设置是在用户的 ~/.login_conf 中配置的，或者是在用户的启动文件中配置的：~/.profile、~/.bashrc 或者 ~/.cshrc。

必须设置两个环境变量：

* LANG，用于设置区域设置
* MM_CHARSET，用于设置应用程序使用的 MIME 字符集

除了用户的shell配置外，还应为特定应用程序配置和 Xorg 配置设置这些变量。

有两种方法可用于进行所需的变量赋值：登录类方法（建议的方法）和启动文件方法。下面的两节展示了如何使用这两种方法。

#### 25.2.1.1. 登录类方法

这种方法是推荐的方法，因为它为每个可能的 shell 分配所需的区域设置和 MIME 字符集。这种设置可以由每个用户执行，也可以由超级用户为所有用户配置。

这个最小示例在个人用户的主目录的 .login_conf 中设置了 Latin-1 编码的两个变量：

```
me:\
	:charset=ISO-8859-1:\
	:lang=de_DE.ISO8859-1:
```

这是一个用户的 ~/.login_conf 示例，设置了 BIG-5 编码的繁体中文变量。需要更多变量，因为一些应用程序不正确地尊重中文、日文和韩文的区域设置变量：

```
#Users who do not wish to use monetary units or time formats
#of Taiwan can manually change each variable
me:\
	:lang=zh_TW.Big5:\
	:setenv=LC_ALL=zh_TW.Big5,LC_COLLATE=zh_TW.Big5,LC_CTYPE=zh_TW.Big5,LC_MESSAGES=zh_TW.Big5,LC_MONETARY=zh_TW.Big5,LC_NUMERIC=zh_TW.Big5,LC_TIME=zh_TW.Big5:\
	:charset=big5:\
	:xmodifiers="@im=gcin": #Set gcin as the XIM Input Server
```

或者，超级用户可以为系统的所有用户配置本地化。在/etc/login.conf 中使用以下变量来设置区域设置和 MIME 字符集：

```
language_name|Account Type Description:\
	:charset=MIME_charset:\
	:lang=locale_name:\
	:tc=default:
```

因此，前面的 Latin-1 示例将如下所示：

```
german|German Users Accounts:\
	:charset=ISO-8859-1:\
	:lang=de_DE.ISO8859-1:\
	:tc=default:
```

有关这些变量的更多详细信息，请参阅 login.conf(5)。请注意，它已经包含预定义的俄语类。

每当编辑/etc/login.conf 时，请记住执行以下命令以更新能力数据库：

```
# cap_mkdb /etc/login.conf
```

|  | 对于最终用户，cap_mkdb 命令将需要在他们的~/.login_conf 上运行，以使任何更改生效。|
| -- | ------------------------------------------------------------------------------------ |

##### 25.2.1.1.1. 更改登录类别的实用工具

除了手动编辑 /etc/login.conf 外，还有几种工具可用于设置新创建用户的区域设置。

当使用 vipw 添加新用户时，请指定语言以设置区域设置：

```
user:password:1111:11:language:0:0:User Name:/home/user:/bin/sh
```

当使用 adduser 添加新用户时，默认语言可以预先配置为所有新用户，或者针对单个用户指定。

如果所有新用户使用相同的语言，请在 /etc/adduser.conf 中设置 defaultclass=<em>language</em>。

要在创建用户时覆盖此设置，请在此提示处输入所需的区域设置：

```
Enter login class: default []:
```

或者在调用 adduser 时指定要设置的区域设置：

```
# adduser -class language
```

如果要使用 pw 来添加新用户，请按照以下步骤指定区域设置：

```
# pw useradd user_name -L language
```

要更改现有用户的登录类别，可以使用 chpass。以超级用户身份调用它，并将要编辑的用户名作为参数提供。

```
# chpass user_name
```

#### 25.2.1.2. Shell 启动文件方法

此第二种方法不建议使用，因为每个使用的shell都需要手动配置，每个shell都有不同的配置文件和不同的语法。例如，要为 sh shell设置德语语言，可以将以下行添加到~/.profile 中，以仅为该用户设置shell。还可以将这些行添加到/etc/profile 或/usr/share/skel/dot.profile 中，以为所有用户设置该shell：

```
LANG=de_DE.ISO8859-1; export LANG
MM_CHARSET=ISO-8859-1; export MM_CHARSET
```

然而，配置文件的名称和使用的语法对于 csh shell有所不同。这些是用于~/.login、/etc/csh.login 或/usr/share/skel/dot.login 的等效设置：

```
setenv LANG de_DE.ISO8859-1
setenv MM_CHARSET ISO-8859-1
```

使事情复杂化的是，在~/.xinitrc 中配置 Xorg 所需的语法还取决于shell。第一个示例是为 sh shell，第二个示例是为 csh shell。

```
LANG=de_DE.ISO8859-1; export LANG
```

```
setenv LANG de_DE.ISO8859-1
```

### 25.2.2. 控制台设置

控制台提供了几种本地化字体可供选择。要查看可用字体的列表，请键入 ls /usr/share/syscons/fonts。要配置控制台字体，请在 /etc/rc.conf 中指定字体名称，不包括 .fnt 后缀：

```
font8x16=font_name
font8x14=font_name
font8x8=font_name
```

可通过将以下内容添加到 /etc/rc.conf 中来设置键盘映射和屏幕映射：

```
scrnmap=screenmap_name
keymap=keymap_name
keychange="fkey_number sequence"
```

要查看可用屏幕映像的列表，请输入 ls /usr/share/syscons/scrnmaps。在指定 screenmap_name 时，请不要包含 .scm 后缀。通常需要具有相应映射字体的屏幕映像，作为在 VGA 适配器的字体字符矩阵上将位 8 扩展到位 9 的解决方案，以便将字母移出伪图形区域，如果屏幕字体使用位 8 列。

要查看可用键盘映像的列表，请输入 ls /usr/share/syscons/keymaps。在指定 keymap_name 时，请不要包含 .kbd 后缀。要在不重启的情况下测试键盘映像，请使用 kbdmap(1)。

通常需要 keychange 条目，以将功能键编程为与所选终端类型匹配，因为功能键序列无法在键盘映像中定义。

接下来，在/etc/ttys 中为所有虚拟终端项设置正确的控制台终端类型。定义了用于字符集的终端类型概述了可用的终端类型。

表 2. 字符集的定义终端类型

| 字符集                  | 终端类型 |
| ------------------------- | ---------- |
| ISO8859-1 或 ISO8859-15 | `cons25l1`         |
| ISO8859-2               | `cons25l2`         |
| ISO8859-7               | `cons25l7`         |
| KOI8-R                  | `cons25r`         |
| KOI8-U                  | `cons25u`         |
| CP437（VGA 默认）       | `cons25`         |
| US-ASCII                | `cons25w`         |

对于具有宽字符或多字节字符的语言，请从 FreeBSD 定制中安装该语言的控制台。可用的软件包总结在来自 FreeBSD 定制的可用控制台中。安装后，请参考软件包的 pkg-message 或 man 页面获取配置和使用说明。

表 3. 来自 FreeBSD 定制的可用控制台

| 语言              | Port 位置 |
| ------------------- | ----------- |
| Traditional Chinese (BIG-5) | [chinese/big5con](https://cgit.freebsd.org/ports/tree/chinese/big5con/)              |
| Chinese/Japanese/Korean     | [chinese/cce](https://cgit.freebsd.org/ports/tree/chinese/cce/)              |
| Chinese/Japanese/Korean     | [chinese/zhcon](https://cgit.freebsd.org/ports/tree/chinese/zhcon/)              |
| Japanese                    | [chinese/kon2](https://cgit.freebsd.org/ports/tree/chinese/kon2/)              |
| Japanese                    | [japanese/kon2-14dot](https://cgit.freebsd.org/ports/tree/japanese/kon2-14dot/)              |
| Japanese                    | [japanese/kon2-16dot](https://cgit.freebsd.org/ports/tree/japanese/kon2-16dot/)              |


如果在 /etc/rc.conf 啟用了滑鼠，可能需要進行額外配置。默認情況下，syscons(4) 驅動程序的鼠標光標佔用字符集中的 0xd0 - 0xd3 範圍。如果語言使用此範圍，請通過將以下行添加到 /etc/rc.conf 來移動光標的範圍：

```
mousechar_start=3
```

### 25.2.3. Xorg 設置

X 窗口系统说明了如何安装和配置 Xorg。当为本地化配置 Xorg 时，FreeBSD Ports 中提供了额外的字体和输入法。应用程序特定的 i18n 设置，如字体和菜单，可以在 ~/.Xresources 中调整，并应能让用户在图形应用程序菜单中查看其选择的语言。

X 输入法 (XIM) 协议是输入非英文字符的 Xorg 标准。可用输入法概述了 FreeBSD Ports 中可用的输入法应用程序。还提供了额外的 Fcitx 和 Uim 应用程序。

可用输入法方法表四

| 语言   | 输入法 |
| -------- | -------- |
| Chinese    | [chinese/gcin](https://cgit.freebsd.org/ports/tree/chinese/gcin/)             |
| Chinese    | [chinese/ibus-chewing](https://cgit.freebsd.org/ports/tree/chinese/ibus-chewing/)             |
| Chinese    | [chinese/ibus-pinyin](https://cgit.freebsd.org/ports/tree/chinese/ibus-pinyin/)             |
| Chinese    | [chinese/oxim](https://cgit.freebsd.org/ports/tree/chinese/oxim/)             |
| Chinese    | [chinese/scim-fcitx](https://cgit.freebsd.org/ports/tree/chinese/scim-fcitx/)             |
| Chinese    | [chinese/scim-pinyin](https://cgit.freebsd.org/ports/tree/chinese/scim-pinyin/)             |
| Chinese    | [chinese/scim-tables](https://cgit.freebsd.org/ports/tree/chinese/scim-tables/)             |
| Japanese   | [japanese/ibus-anthy](https://cgit.freebsd.org/ports/tree/japanese/ibus-anthy/)             |
| Japanese   | [japanese/ibus-mozc](https://cgit.freebsd.org/ports/tree/japanese/ibus-mozc/)             |
| Japanese   | [japanese/ibus-skk](https://cgit.freebsd.org/ports/tree/japanese/ibus-skk/)             |
| Japanese   | [japanese/im-ja](https://cgit.freebsd.org/ports/tree/japanese/im-ja/)             |
| Japanese   | [japanese/kinput2](https://cgit.freebsd.org/ports/tree/japanese/kinput2/)             |
| Japanese   | [japanese/scim-anthy](https://cgit.freebsd.org/ports/tree/japanese/scim-anthy/)             |
| Japanese   | [japanese/scim-canna](https://cgit.freebsd.org/ports/tree/japanese/scim-canna/)             |
| Japanese   | [japanese/scim-honoka](https://cgit.freebsd.org/ports/tree/japanese/scim-honoka/)             |
| Japanese   | [japanese/scim-honoka-plugin-romkan](https://cgit.freebsd.org/ports/tree/japanese/scim-honoka-plugin-romkan/)             |
| Japanese   | [japanese/scim-honoka-plugin-wnn](https://cgit.freebsd.org/ports/tree/japanese/scim-honoka-plugin-wnn/)             |
| Japanese   | [japanese/scim-prime](https://cgit.freebsd.org/ports/tree/japanese/scim-prime/)             |
| Japanese   | [japanese/scim-skk](https://cgit.freebsd.org/ports/tree/japanese/scim-skk/)             |
| Japanese   | [japanese/scim-tables](https://cgit.freebsd.org/ports/tree/japanese/scim-tables/)             |
| Japanese   | [japanese/scim-tomoe](https://cgit.freebsd.org/ports/tree/japanese/scim-tomoe/)             |
| Japanese   | [japanese/scim-uim](https://cgit.freebsd.org/ports/tree/japanese/scim-uim/)             |
| Japanese   | [japanese/skkinput](https://cgit.freebsd.org/ports/tree/japanese/skkinput/)             |
| Japanese   | [japanese/skkinput3](https://cgit.freebsd.org/ports/tree/japanese/skkinput3/)             |
| Japanese   | [japanese/uim-anthy](https://cgit.freebsd.org/ports/tree/japanese/uim-anthy/)             |
| Korean     | [korean/ibus-hangul](https://cgit.freebsd.org/ports/tree/korean/ibus-hangul/)             |
| Korean     | [korean/imhangul](https://cgit.freebsd.org/ports/tree/korean/imhangul/)             |
| Korean     | [korean/nabi](https://cgit.freebsd.org/ports/tree/korean/nabi/)             |
| Korean     | [korean/scim-hangul](https://cgit.freebsd.org/ports/tree/korean/scim-hangul/)             |
| Korean     | [korean/scim-tables](https://cgit.freebsd.org/ports/tree/korean/scim-tables/)             |
| Vietnamese | [vietnamese/xvnkb](https://cgit.freebsd.org/ports/tree/vietnamese/xvnkb/)             |
| Vietnamese | [vietnamese/x-unikey](https://cgit.freebsd.org/ports/tree/vietnamese/x-unikey/)             |
