# 25.4.特定语言的区域配置

本节提供了定制系统以俄语为主要语言的配置示例。然后提供了一些其他语言本地化的附加资源。

### 25.4.1. 俄语（KOI8-R 编码）

本节显示了本地化 FreeBSD 系统为俄语所需的特定设置。有关每种设置的完整说明，请参阅《使用本地化》。

要为登录用户shell设置此区域设置，请在每个用户的 ~/.login_conf 中添加以下行：

```
me:My Account:\
	:charset=KOI8-R:\
	:lang=ru_RU.KOI8-R:
```

配置控制台，请将以下行添加到 /etc/rc.conf 文件中：

```
keymap="ru.utf-8"
scrnmap="utf-82cp866"
font8x16="cp866b-8x16"
font8x14="cp866-8x14"
font8x8="cp866-8x8"
mousechar_start=3
```

对于 /etc/ttys 中的每个 ttyv 条目，使用 cons25r 作为终端类型。

要配置打印，需要使用特殊的输出过滤器将 KOI8-R 转换为 CP866，因为大多数带有俄语字符的打印机都带有硬件代码页 CP866。FreeBSD 包含一个默认的过滤器用于此目的，路径为 /usr/libexec/lpr/ru/koi2alt。要使用此过滤器，请将以下条目添加到 /etc/printcap 文件中：

```
lp|Russian local line printer:\
	:sh:of=/usr/libexec/lpr/ru/koi2alt:\
	:lp=/dev/lpt0:sd=/var/spool/output/lpd:lf=/var/log/lpd-errs:
```

参考 printcap(5)以获取更详细的解释。

要在挂载的 MS-DOS®文件系统中配置对俄罗斯文件名的支持，请在向/etc/fstab 添加条目时包括 -L 和区域设置名称:

```
/dev/ad0s2      /dos/c  msdos   rw,-Lru_RU.KOI8-R 0 0
```

参考 mount_msdosfs(8)获取更多详细信息。

要为 Xorg 配置俄语字体，请安装 x11-fonts/xorg-fonts-cyrillic 软件包。然后，检查/etc/X11/xorg.conf 中的 "Files" 部分。必须在任何其他 FontPath 条目之前添加以下行：

```
FontPath   "/usr/local/lib/X11/fonts/cyrillic"
```

额外的西里尔字体可在ports 中找到。

要激活俄语键盘，请在/etc/xorg.conf 的 "Keyboard" 部分中添加以下内容：

```
Option "XkbLayout"   "us,ru"
Option "XkbOptions"  "grp:toggle"
```

确保在该文件中注释掉 XkbDisable。

对于 grp:toggle 使用右 Alt 键，对于 grp:ctrl_shift_toggle 使用 Ctrl+Shift。对于 grp:caps_toggle 使用 CapsLock 键。旧的 CapsLock 功能仅在 LAT 模式下仍可使用 Shift+CapsLock。由于某种未知原因，grp:caps_toggle 在 Xorg 中无法正常工作。

如果键盘上有"Windows®"键，并且一些非字母键映射不正确，请将以下行添加到/etc/xorg.conf 中：

```
Option "XkbVariant" ",winkeys"
```

|  | 俄罗斯的 XKB 键盘可能无法与非本地化的应用程序配合使用。最小本地化的应用程序应该在程序早期调用 XtSetLanguageProc (NULL, NULL, NULL); 函数。|
| -- | -------------------------------------------------------------------------------------------------------------------------------------------- |

请参阅 http://koi8.pp.ru/xwin.html 了解更多关于本地化 Xorg 应用程序的指令。关于 KOI8-R 编码的更一般信息，请参考 http://koi8.pp.ru/。

### 25.4.2. 附加语言特定资源

本节列出了一些配置其他区域设置的附加资源。

传统中文-台湾

FreeBSD 台湾项目在 http://netlab.cse.yzu.edu.tw/~statue/freebsd/zh-tut/ 上有一篇关于 FreeBSD 的中文 HOWTO。

希腊语本地化

FreeBSD 中的希腊支持完整文章仅在官方 FreeBSD 希腊文档的一部分中提供。

日语和韩语本地化

对于日语，请参考 http://www.jp.FreeBSD.org/，对于韩语，请参考 http://www.kr.FreeBSD.org/。

非英语 FreeBSD 文档

一些 FreeBSD 贡献者已将 FreeBSD 文档的部分翻译成其他语言。它们可通过 FreeBSD 网站上的链接或/usr/share/doc 中获得。
