# 26.5.追踪开发分支


FreeBSD 有两个开发分支：FreeBSD-CURRENT 和 FreeBSD-STABLE。

本部分提供了对每个分支及其预期受众的解释，以及如何使系统与每个相应分支保持最新的说明。

### 26.5.1. 使用 FreeBSD-CURRENT

FreeBSD-CURRENT 是 FreeBSD 开发的“最前沿”，FreeBSD-CURRENT 用户需要具有较高的技术技能。希望跟踪开发分支的非技术用户应该选择跟踪 FreeBSD-STABLE。

FreeBSD-CURRENT 是 FreeBSD 的最新源代码，包括正在进行中的工作，实验性更改以及可能存在于下一个官方发布版本中的过渡机制。虽然许多 FreeBSD 开发人员每天都会编译 FreeBSD-CURRENT 源代码，但在某些时间段内，该源代码可能无法构建。这些问题会尽快解决，但 FreeBSD-CURRENT 是否带来灾难或新功能取决于代码何时同步。

FreeBSD-CURRENT 可供三个主要利益群体使用：

1. FreeBSD 社区成员，他们正在积极开发源代码树的某个部分。
2. 自由的 BSD 社区成员是积极的测试者。他们愿意花时间解决问题，就 FreeBSD 的变化和整体方向提出主题建议，并提交补丁。
3. 希望留意事物、用当前源作为参考目的，或偶尔发表评论或代码贡献的用户。

FreeBSD-CURRENT 不应被视为在下一个发布版之前获得新功能的快速途径，因为预发布功能尚未经过充分测试，很可能包含错误。它不是获取错误修复的快速方式，因为任何给定的提交与修复现有错误一样可能引入新错误。FreeBSD-CURRENT 在任何情况下都不是“官方支持的”。

跟踪 FreeBSD-CURRENT：

1. 加入 FreeBSD-CURRENT 邮件列表和 src 仓库主分支提交消息列表。这对于查看人们对系统当前状态的评论和接收有关 FreeBSD-CURRENT 当前状态的重要公告至关重要。src 仓库主分支提交消息列表记录每次更改的提交日志条目，以及可能引起的任何相关信息。
    要加入这些列表，请转到 FreeBSD 列表服务器，单击要订阅的列表，然后按照说明操作。为了跟踪整个源代码树的更改，而不仅仅是 FreeBSD-CURRENT 的更改，请订阅 src 仓库所有分支的提交消息。
2. 与 FreeBSD-CURRENT 源进行同步。通常，git 用于从 FreeBSD Git 存储库的 main 分支检出-CURRENT 代码（有关详细信息，请参见“使用 Git”）。
3. 由于存储库的大小，一些用户选择仅同步对他们感兴趣的源代码部分或为其贡献补丁的部分。然而，计划从源代码编译操作系统的用户必须下载整个 FreeBSD-CURRENT，而不仅仅是选择的部分。在编译 FreeBSD-CURRENT 之前，请仔细阅读/usr/src/Makefile，并遵循“从源代码更新 FreeBSD”的说明。阅读 FreeBSD-CURRENT 邮件列表和/usr/src/UPDATING 以随时了解其他引导过程，有时在通往下一个版本时变得必要。
4. 要积极参与！鼓励 FreeBSD-CURRENT 用户提交他们的增强建议或错误修复。随附代码的建议始终受欢迎。

### 26.5.2. 使用 FreeBSD-STABLE

FreeBSD-STABLE 是制作主要版本的开发分支。更改以较慢的速度进入此分支，并且通常假定它们首先在 FreeBSD-CURRENT 中经过测试。这仍然是一个开发分支，并且在任何给定时间，FreeBSD-STABLE 的源代码可能适用于一般用途，也可能不适用。它只是另一个工程开发跟踪，而不是终端用户的资源。那些没有资源执行测试的用户应该运行最近的 FreeBSD 版本。

那些对跟踪或贡献 FreeBSD 开发过程特别感兴趣，尤其是与下一个 FreeBSD 版本相关的人，应该考虑追踪 FreeBSD-STABLE。

尽管 FreeBSD-STABLE 分支应该在任何时候都可以编译和运行，但无法保证这一点。由于运行 FreeBSD-STABLE 的人比运行 FreeBSD-CURRENT 的人更多，不可避免地会发现一些在 FreeBSD-CURRENT 中未曾出现的错误和边缘情况。因此，不应盲目跟踪 FreeBSD-STABLE。特别重要的是，在没有在开发或测试环境中彻底测试代码的情况下，不要将任何生产服务器更新到 FreeBSD-STABLE。

要跟踪 FreeBSD-STABLE：

1. 加入 FreeBSD-STABLE 邮件列表，以便了解可能出现在 FreeBSD-STABLE 中的构建依赖项或其他需要特别关注的问题。开发人员还会在这个邮件列表中发布公告，当他们考虑一些有争议的修复或更新时，用户可以通过这个邮件列表提出任何相关问题。加入跟踪的分支的相关 git 列表。例如，跟踪 13-STABLE 分支的用户应该加入 src 仓库稳定分支的提交消息列表。该列表记录了每个更改的提交日志条目，以及可能的副作用的任何相关信息。
    要加入这些列表，请访问 FreeBSD 列表服务器，单击要订阅的列表，然后按照说明操作。要跟踪整个源代码树的更改，请订阅 src 存储库所有分支的提交消息。
2. 要安装新的 FreeBSD-STABLE 系统，请从 FreeBSD 镜像站点安装最新的 FreeBSD-STABLE 发布版，或者使用从 FreeBSD-STABLE 构建的每月快照。有关快照的更多信息，请参阅 www.freebsd.org/snapshots。要编译或升级现有的 FreeBSD 系统到 FreeBSD-STABLE，请使用 git 检出所需分支的源代码。分支名称（例如 stable/13 ）列在 www.freebsd.org/releng 上。
3. 在编译或升级到 FreeBSD-STABLE 之前，请仔细阅读/usr/src/Makefile，并按照 更新 FreeBSD from Source 中的说明操作。阅读 FreeBSD-STABLE 邮件列表和/usr/src/UPDATING，以便及时了解其他引导程序，有时在通往下一个发布版的道路上是必要的。

### 26.5.3. N 字母

在追踪错误时，了解用于创建显示问题的系统的源代码的哪些版本是很重要的。FreeBSD 提供了编译到内核中的版本信息。uname(1) 检索此信息，例如：

```
% uname -v
FreeBSD 14.0-CURRENT #112 main-n247514-031260d64c18: Tue Jun 22 20:43:19 MDT 2021     fred@machine:/usr/home/fred/obj/usr/home/fred/git/head/amd64.amd64/sys/FRED
```

最后一个字段提供有关内核名称、构建内核的人以及编译位置的信息。查看第四个字段，由几个部分组成：

```
main-n247514-031260d64c18

main
n247514
031260d64c18

```

|  | Git 分支名称。注意：n-数字的比较仅适用于项目发布的分支（ main，stable/XX 和 releng/XX ）。本地分支将具有 n-数字，这些数字将重叠其父分支的提交。|
| -- | --------------------------------------------------------------------------------------------------------------------------------------------------- |
|  | n-数字是从包含在该行中的 Git 哈希开始，向后计算到 Git 存储库开始的提交的线性计数。                                                 |
|  | 检出树的 Git 哈希                                                                                                                                 |
|  | 有时，当内核在具有未提交更改的树中构建时，-dirty 的后缀会存在。在此示例中不存在，因为 FRED 内核是从原始检出构建的。               |

git rev-list 命令用于查找与 Git 哈希对应的 n-数字。例如：

```
% git rev-list --first-parent --count 031260d64c18 
247514 
```

|  | git 哈希以进行翻译（上面示例中的哈希被重复使用） |
| -- | -------------------------------------------------- |
|  | N 号.                                            |

通常这个数字并不那么重要。然而，当 bug 修复提交时，这个数字可以帮助快速确定当前运行系统中是否存在该修复。开发人员通常会引用提交的哈希值（或提供包含该哈希值的 URL），而不是 N 号，因为哈希值是一个易于识别变更的标识符，而 N 号则不是。安全公告和勘误通知也会注明一个 N 号，你可以直接将其与你的系统进行比较。当你需要使用浅克隆的 Git 版本库时，由于 git rev-list 命令统计了版本库中所有的修订，浅克隆会忽略掉这个 N 号，因此无法可靠地进行比较。
