# 26.6.从源代码更新 FreeBSD

通过从源代码编译更新 FreeBSD，相比二进制更新，有几个优点。可以通过选项构建代码以利用特定硬件。可以使用非默认设置构建基本系统的部分，或者在不需要或不需要的地方完全省略它们。构建过程更新系统需要更长时间，但能完全定制，以生成定制版本的 FreeBSD。

### 26.6.1. 快速入门

这是一个快速参考，用于说明通常用于通过从源代码构建来更新 FreeBSD 的步骤。后面的部分将更详细地说明这个过程。

```
# etcupdate extract 
# etcupdate diff 
```

||引导 /etc 文件库的数据库;有关更多信息，请参见 etcupdate(8)。|| --| --------------------------------------------------------------------------------------------------------------------------------------------------------------| ||引导后检查差异。修剪任何不再需要的本地更改，以减少未来更新中冲突的机会。|

* 更新和构建

  ```
  # git pull -C /usr/src  
  check /usr/src/UPDATING  
  # cd /usr/src  
  # make -j4 buildworld  
  # make -j4 kernel  
  # shutdown -r now  
  # etcupdate -p   
  # cd /usr/src  
  # make installworld  
  # etcupdate -B   
  # shutdown -r now  
  ```

|  | 获取源代码的最新版本。有关获取和更新源代码的更多信息，请参阅有关获取和更新源代码的信息。|
| -- | ------------------------------------------------------------------------------------------ |
|  | 在构建源代码之前或之后，请检查 /usr/src/UPDATING 以获取任何需要的手动步骤。    |
|  | 前往源目录。                                                              |
|  | 编译整个世界，除了内核。                                                  |
|  | 编译并安装内核。这相当于 make buildkernel installkernel。                |
|  | 重启系统到新内核。                                                    |
|  | 升级和合并在 /etc/ 中安装之前所需的配置文件。                             |
|  | 进入源目录。                                                              |
|  | 安装世界。                                                                |
|  | 更新并合并 /etc/ 中的配置文件。                                           |
|  | 重启系统以使用新构建的世界和内核。                                    |

### 26.6.2. 准备源更新

阅读 /usr/src/UPDATING。在更新之前或之后必须执行的任何手动步骤都在此文件中说明。

### 26.6.3. 更新源

FreeBSD 源代码位于/usr/src/。更新此源代码的首选方法是通过 Git 版本控制系统。验证源代码是否在版本控制下：

```
# cd /usr/src
# git remote --v
origin  https://git.freebsd.org/src.git (fetch)
origin  https://git.freebsd.org/src.git (push)
```

这表明/usr/src/已在版本控制下，并且可以使用 git(1)进行更新：

```
# git pull -C /usr/src
```

如果目录长时间未更新，更新过程可能需要一些时间。完成后，源代码将是最新的，并且可以开始下一节中说明的构建过程。

|  | 获得来源：<br /><br />如果输出显示 fatal: not a git repository，那里的文件丢失或是用不同的方法安装的。需要对来源进行新的检出。|
| -- | ------------------------------------------------------------------------------------------------------------------------- |

表 1. FreeBSD 版本和存储库分支

| 内核版本号输出 | 存储库路径 | 说明                                                                                                                                                                                                                                                                                               |
| ---------------- | ------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `<em>X.Y</em>-RELEASE`               | `releng/<em>X.Y</em>`           | 发行版本加上仅关键安全性和错误修补程序。建议大多数用户使用此分支。                                                                                                                                                                                                                  |
| `<em>X.Y</em>-STABLE`               | `stable/<em>X</em>`           | 发行版本加上该分支上的所有额外开发。STABLE 指的是应用程序二进制接口（ABI）不会更改，因此为早期版本编译的软件仍然可以运行。例如，为在之后编译的 FreeBSD 10-STABLE 上运行而编译的软件仍将在 FreeBSD 10.1 上运行。<br />STABLE 分支偶尔会有可能影响用户的错误或不兼容性，尽管这些问题通常会很快得到修复。|
| `<em>X</em>-CURRENT`               | `main`           | FreeBSD 的最新未发布开发版本。CURRENT 分支可能存在重大错误或不兼容性，仅推荐给高级用户使用。                                                                                                                                                                                        |

使用 uname(1)确定 FreeBSD 的版本：

```
# uname -r
13.2-RELEASE
```

根据 FreeBSD 版本和存储库分支，用于更新 13.2-RELEASE 的源具有存储库路径 releng/13.2。在检出源代码时使用该路径：

```
# mv /usr/src /usr/src.bak 
# git clone --branch releng/13.2 https://git.FreeBSD.org/src.git /usr/src 
```

|  | 将旧目录移出。如果此目录中没有本地修改，则可以将其删除。                     |
| -- | --------------------------------------------------------------------------------------------- |
|  | 从 FreeBSD 版本和存储库分支的路径添加到存储库 URL。第三个参数是本地系统上源代码的目标目录。|

### 26.6.4。从源代码构建

世界或操作系统的所有部分都是经过编译的。首先这样做是为了提供最新的工具来构建内核。然后构建内核本身：

```
# cd /usr/src
# make buildworld
# make buildkernel
```

编译的代码被写入 /usr/obj。

这些是基本步骤。说明了控制构建的其他选项。

#### 26.6.4.1. Performing a Clean Build

Some versions of the FreeBSD build system leave previously-compiled code in the temporary object directory, /usr/obj. This can speed up later builds by avoiding recompiling code that has not changed. To force a clean rebuild of everything, use `cleanworld` before starting a build:

```
# make cleanworld
```

#### 26.6.4.2. Setting the Number of Jobs

增加多核处理器上构建作业数量可以提高构建速度。使用 sysctl hw.ncpu 确定核心数量。处理器各不相同，不同版本的 FreeBSD 使用的构建系统也不同，因此测试是确定不同作业数量如何影响构建速度的唯一方法。作为起点，考虑核心数量的一半到两倍之间的值。作业数量由 -j 指定。

示例 1. 增加构建作业数量

使用四个作业构建世界和内核：

```
# make -j4 buildworld buildkernel
```

#### 26.6.4.3. 仅构建内核

如果源代码已更改，则必须完成 buildworld。之后，可以随时运行 buildkernel 来构建内核。仅构建内核：

```
# cd /usr/src
# make buildkernel
```

#### 26.6.4.4. 构建定制内核

标准的 FreeBSD 内核基于一个名为 GENERIC 的内核配置文件。GENERIC 内核包含最常用的设备驱动程序和选项。有时，构建自定义内核是有用或必要的，可以添加或删除设备驱动程序或选项以满足特定需求。

例如，开发具有严重受限 RAM 的小型嵌入式计算机的人可以删除不需要的设备驱动程序或选项，使内核略微变小。

内核配置文件位于/usr/src/sys/arch/conf/，其中 arch 是从 uname -m 输出的内容。在大多数计算机上，这是 amd64，得到的配置文件目录是/usr/src/sys/amd64/conf/。

|  | /usr/src 可以被删除或重新创建，因此最好将定制内核配置文件保存在单独的目录中，如/root。将内核配置文件链接到 conf 目录中。如果该目录被删除或覆盖，可以将内核配置重新链接到新目录中。|
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |

可以通过复制 GENERIC 配置文件来创建自定义配置文件。在此示例中，新的自定义内核用于存储服务器，因此命名为 STORAGESERVER：

```
# cp /usr/src/sys/amd64/conf/GENERIC /root/STORAGESERVER
# cd /usr/src/sys/amd64/conf
# ln -s /root/STORAGESERVER .
```

/root/STORAGESERVER 然后进行编辑，根据 config(5)中显示的内容添加或删除设备或选项。

通过在命令行上将 KERNCONF 设置为内核配置文件来构建定制内核：

```
# make buildkernel KERNCONF=STORAGESERVER
```

### 26.6.5. 安装已编译的代码

在完成 buildworld 和 buildkernel 步骤之后，安装新的内核和系统。

```
# cd /usr/src
# make installkernel
# shutdown -r now
# cd /usr/src
# make installworld
# shutdown -r now
```

如果构建了定制内核，则还必须设置 KERNCONF 以使用新的定制内核：

```
# cd /usr/src
# make installkernel KERNCONF=STORAGESERVER
# shutdown -r now
# cd /usr/src
# make installworld
# shutdown -r now
```

### 26.6.6. 完成更新

完成更新的最后几个任务。任何修改过的配置文件将与新版本合并，过时的库将被定位并移除，然后系统将重启。

#### 26.6.6.1. 使用 etcupdate(8)合并配置文件

etcupdate(8)是一种用于管理不作为 installworld 的一部分更新的文件的工具，例如位于/etc/中的文件。它通过对对这些文件所做更改与本地版本的三向合并来管理更新。etcupdate(8)的设计旨在最大程度减少用户干预量。

```
# etcupdate diff
```

该命令允许用户审计配置更改。

如果 etcupdate(8)无法自动合并文件，则可以通过手动交互来解决合并冲突：

```
# etcupdate resolve
```

```
# etcupdate extract 
# etcupdate diff 
```

||引导库存/等等文件数据库; 有关更多信息，请参阅 etcupdate(8)。| --| ---------------------------------------------------------------------------------------------| ||在引导后检查差异。修剪不再需要的任何本地更改，以减少将来更新中冲突的机会。

#### 26.6.6.2. 检查过期文件和库

更新后可能会留下一些过时的文件或目录。这些文件可能位于：

```
# make check-old
```

 并删除：

```
# make delete-old
```

也可能会留下一些过时的库。可以使用以下方法检测到这些库：

```
# make check-old-libs
```

 并且在删除

```
# make delete-old-libs
```

当这些旧库被删除后，仍在使用这些旧库的程序将停止工作。这些程序必须在删除旧库后重新构建或替换。

```
# make BATCH_DELETE_OLD_FILES=yes delete-old-libs
```

#### 26.6.6.3. 更新后重启

更新后的最后一步是重启计算机，以使所有更改生效：

```
# shutdown -r now
```
