# 26.7.多台机器的追踪

当多台机器需要跟踪同一个源代码树时，让每台系统都下载源代码并重新构建会浪费磁盘空间、网络带宽和 CPU 资源。解决方案是让一台机器完成大部分工作，而其他机器通过 NFS 挂载这些工作。本节概述了这样做的一种方法。有关使用 NFS 的更多信息，请参阅网络文件系统（NFS）。

首先，确定一组将运行相同二进制文件的机器，称为构建集的机器。每台机器可以有自定义内核，但将运行相同的用户空间二进制文件。从该中，选择一台机器作为构建机器，用于构建世界和内核。理想情况下，这是一台速度快且有足够剩余 CPU 运行的机器 make buildworld 和 make buildkernel。

选择一台机器作为测试机器，在将软件更新放入生产之前进行测试。这必须是一台可以在较长时间内停机的机器。它可以是构建机器，但不一定是。

此构建集中的所有机器都需要通过 NFS 从构建机器挂载 /usr/obj 和 /usr/src。对于多个构建集，/usr/src 应位于一个构建机器上，并在其他机器上通过 NFS 挂载。

确保构建集中的所有机器上的 /etc/make.conf 和 /etc/src.conf 与构建机器上的内容一致。这意味着构建机器必须构建基本系统的所有部分，以便任何构建集中的机器都能安装。此外，每台构建机器应在其 /etc/make.conf 中使用 KERNCONF 设置其内核名称，并在其 KERNCONF 中列出所有内核，优先列出其自己的内核。构建机器必须在 /usr/src/sys/arch/conf 中拥有每台机器的内核配置文件。

在构建机器上，按照《从源码更新 FreeBSD》中说明的方法构建内核和系统世界，但不要在构建机器上安装任何东西。相反，在测试机器上安装构建的内核。在测试机器上，通过 NFS 挂载 /usr/src 和 /usr/obj。然后，运行 shutdown now 进入单用户模式以安装新的内核和世界，并像往常一样运行 etcupdate。完成后，重启以返回到正常的多用户操作。

在验证测试机器上的一切正常后，使用相同的过程在构建集中的每台其他机器上安装新软件。

相同的方法可以用于ports树。第一步是通过 NFS 将/usr/ports共享给构建集中的所有机器。要配置/etc/make.conf 以共享 distfiles，请将 DISTDIR 设置为一个通用共享目录，该目录可被 NFS 挂载映射到的任何用户 root 写入。如果要本地构建ports，则每台机器应将 WRKDIRPREFIX 设置为本地构建目录。或者，如果构建系统要构建并向构建集中的机器分发软件包，请将构建系统上的 PACKAGES 设置为类似于 DISTDIR 的目录。
