# 26.8.在非 FreeBSD 主机上进行构建

历史上，构建 FreeBSD 需要一个 FreeBSD 主机。如今，FreeBSD 可以在 Linux 发行版和 macOS 上构建。

在非 FreeBSD 主机上构建 FreeBSD 的建议是使用 tools/build/make.py 脚本。该脚本充当 bmake 的包装器，bmake 是 FreeBSD 使用的 make 实现。它确保引导所需的工具，包括实际的 FreeBSD 的 make(1)，并正确配置构建环境。特别是，它设置外部工具链变量，如 XCC，XLD 等。此外，该脚本可以将任何附加命令参数传递给 bmake，例如用于并行构建或特定 make 目标的 -j 4。

|  | 最近版本的 bmake 也可以替代 tools/build/make.py 脚本。但在这种情况下，需要手动设置所需的环境变量（获取它们列表的最简单方法是运行 tools/build/make.py --debug ）。|
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

否则，构建 FreeBSD 所需的先决条件列表相当简短。实际上，它只需安装几个依赖项。

在 macOS 上，唯一的依赖是 LLVM。必要的依赖项可以通过软件包管理器（例如 Homebrew）安装：

```
brew install llvm
```

在 Linux 发行版上，安装 Clang 版本 10.0 或更新版本以及 libarchive 和 libbz2 的头文件（通常打包为 libarchive-dev 和 libbz2-dev）。

安装了依赖项之后，主机应该能够构建 FreeBSD。

例如，以下 tools/build/make.py 调用构建了世界：

```
MAKEOBJDIRPREFIX=/tmp/obj tools/build/make.py -j 8 TARGET=arm64 TARGET_ARCH=aarch64 buildworld
```

它在 8 个 CPU 上为目标 aarch64:arm64 构建了世界，并使用 /tmp/obj 作为目标文件。请注意，在非 FreeBSD 主机上构建时，变量 MAKEOBJDIRPREFIX 、 TARGET 和 TARGET_ARCH 是必需的。另外，请确保创建由 MAKEOBJDIRPREFIX 环境变量指向的目标目录。

有关更多详细信息，请参考 arch(7) 和 build(7)。
