# 27.2.实现上的差异

虽然 FreeBSD 中的 DTrace 与 Solaris™ 中的类似，但仍存在差异。主要区别在于，在 FreeBSD 中，DTrace 被实现为一组内核模块，只有在加载这些模块后才能使用 DTrace。要加载所有必要的模块：

```
# kldload dtraceall
```

从 FreeBSD 10.0-RELEASE 开始，当运行 dtrace 时，模块会自动加载。

FreeBSD 使用 DDB_CTF 内核选项来启用从内核模块和内核本身加载 CTF 数据的支持。CTF 是 Solaris™ 紧凑 C 类型格式，封装了类似于 DWARF 和古老的 stabs 的调试信息的简化形式。CTF 数据是由 ctfconvert 和 ctfmerge 构建工具添加到二进制文件中的。ctfconvert 实用程序解析对象中的 DWARFELF debug sections created by the compiler and ctfmerge merges CTFELF 节，将其转换为可执行文件或共享库。

FreeBSD 拥有比 Solaris™更多不同的提供者。最显著的是 dtmalloc 提供者，在 FreeBSD 内核上能按类型跟踪 malloc()。Solaris™中的一些提供者，例如 cpc 和 mib，在 FreeBSD 中不存在。这些在将来的 FreeBSD 版本中可能会出现。此外，在两个操作系统中都可用的一些提供者是不兼容的，因为它们的探测具有不同的参数类型。因此，在 Solaris™上编写的 D 脚本可能无法在 FreeBSD 上不经修改地工作，反之亦然。

由于安全差异，只有 root 可以在 FreeBSD 上使用 DTrace。Solaris™具有一些低级安全检查，在 FreeBSD 中尚不存在。因此，/dev/dtrace/dtrace 严格限制于 root。

DTrace 属于 Common Development and Distribution License（ CDDL ）许可证。要在 FreeBSD 上查看此许可证，请参阅/usr/src/cddl/contrib/opensolaris/OPENSOLARIS.LICENSE 或在线查看 http://opensource.org/licenses/CDDL-1.0。虽然带有 DTrace 支持的 FreeBSD 内核是 BSD 许可的，但在以二进制形式分发模块或加载二进制文件时使用 CDDL。
