# 27.3.开启 DTrace 支持

在 FreeBSD 9.2 和 10.0 中，DTrace 支持已内建到 GENERIC 内核中。使用之前版本的 FreeBSD 的用户或更喜欢在内核中静态编译 DTrace 支持的用户应向自定义内核配置文件中添加以下行，并根据《配置 FreeBSD 内核》中的说明重新编译内核：

```
options         KDTRACE_HOOKS
options         DDB_CTF
makeoptions	DEBUG=-g
makeoptions	WITH_CTF=1
```

使用 AMD64 架构的用户也应添加此行：

```
options         KDTRACE_FRAME
```

此选项提供对 FBT 的支持。虽然 DTrace 可以在没有此选项的情况下工作，但对函数边界跟踪的支持将受到限制。

FreeBSD 系统重启到新内核后，或者使用 kldload dtraceall 加载了 DTrace 内核模块，系统将需要支持 Korn shell，因为 DTrace 工具包中有几个实用程序是用 ksh 写的。确保安装了 shells/ksh93 包或 port。也可以在 shells/pdksh 或 shells/mksh 下运行这些工具。

终于，安装当前的 DTrace Toolkit，这是一系列用于收集系统信息的现成脚本。这些脚本可以检查打开的文件、内存，CPU 使用情况等等。FreeBSD 10 将一些这些脚本安装到/usr/share/dtrace 中。在其他的 FreeBSD 版本上，或者要安装完整的 DTrace Toolkit，可以使用 sysutils/dtrace-toolkit 软件包或port。

|  | 在/usr/share/dtrace 中找到的脚本已经专门移植到了 FreeBSD。并非 DTrace Toolkit 中的所有脚本在 FreeBSD 上都能原样工作，一些脚本可能需要一些工作才能在 FreeBSD 上运行。|
| -- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

DTrace Toolkit 包括用 DTrace 特殊语言编写的许多脚本。这种语言被称为 D 语言，它非常类似于 C++。对语言的深入讨论超出了本文档的范围，详细内容请参阅 Illumos 动态跟踪指南。
