# 28.1.概述

本章涉及在 FreeBSD 中使用 USB 设备模式和 USB On The Go (USB OTG)。其中包括虚拟串行控制台、虚拟网络接口和虚拟 USB 驱动器。

在支持 USB 设备模式或 USB OTG（像许多嵌入式板卡内置的那样）的硬件上运行时，FreeBSD 的 USB 堆栈可以在设备模式下运行。设备模式使计算机能够呈现自身为不同类型的 USB 设备类别，包括串行设备、网络适配器和大容量存储设备，或它们的组合。像笔记本电脑或台式机这样的 USB 主机能够像访问物理 USB 设备一样访问它们。设备模式有时被称为“USB 小工具模式”。

硬件提供设备模式功能有两种基本方式：使用单独的“客户端port”，仅支持设备模式，以及使用 USB OTG（port），可以同时提供设备和主机模式。对于 USB OTG（ports），USB 堆栈会根据连接到port上的设备自动切换主机侧和设备侧。将类似存储设备的 USB 设备连接到port会导致 FreeBSD 切换到主机模式。将计算机等 USB 主机连接到port会导致 FreeBSD 切换到设备模式。单用途的“客户端ports”始终在设备模式下工作。

FreeBSD 向 USB 主机呈现的内容取决于 hw.usb.template sysctl。一些模板提供单个设备，例如串行终端；其他提供多个设备，可以同时使用。一个例子是模板 10，它提供大容量存储设备、串行控制台和网络接口。请参阅 usb_template(4)以获取可用值列表。

注意，在某些情况下，取决于硬件和主机操作系统，为了使主机注意到配置更改，必须将其物理断开连接并重新连接，或以特定于系统的方式强制重新扫描 USB 总线。当 FreeBSD 在主机上运行时，可以使用 usbconfig(8) reset。如果 USB 主机已连接到 USBOTG 插座，则在加载 usb_template.ko 后也必须执行此操作。

阅读本章后，你将了解：

* 如何在 FreeBSD 上设置 USB 设备模式功能。
* 如何在 FreeBSD 上配置虚拟串行port。
* 如何从各种操作系统连接到虚拟串行port。
* 如何配置 FreeBSD 以提供虚拟 USB 网络接口。
* 如何配置 FreeBSD 以提供虚拟 USB 存储设备。
