# 28.2.USB 虚拟串行端口

### 28.2.1.配置 USB 设备模式序列Ports

通过模板号 3、8 和 10 提供虚拟串行port支持。请注意，模板 3 可与 Microsoft Windows 10 一起使用，无需特殊驱动程序和 INF 文件。其他主机操作系统适用于这三个模板。必须加载 usb_template(4) 和 umodem(4) 内核模块。

要启用 USB 设备模式串行ports，请将这些行添加到 /etc/ttys：

```
ttyU0	"/usr/libexec/getty 3wire"	vt100	onifconsole secure
ttyU1	"/usr/libexec/getty 3wire"	vt100	onifconsole secure
```

然后将这些行添加到 /etc/devd.conf：

```
notify 100 {
	match "system"		"DEVFS";
	match "subsystem"	"CDEV";
	match "type"		"CREATE";
	match "cdev"		"ttyU[0-9]+";
	action "/sbin/init q";
};
```

如果 devd(8) 已经在运行，请重新加载配置：

```
# service devd restart
```

确保在启动时加载必要的模块并设置正确的模板，通过将这些行添加到 /boot/loader.conf（如果文件不存在则创建）：

```
umodem_load="YES"
hw.usb.template=3
```

若要在不重启的情况下加载模块并设置模板，请使用：

```
# kldload umodem
# sysctl hw.usb.template=3
```

### 28.2.2. 从 FreeBSD 连接到 USB 设备模式串行 Ports

要连接到配置为提供 USB 设备模式串行 ports 的板，将 USB 主机（如笔记本电脑）连接到板的 USB OTG 或 USB 客户端 port。在主机上使用 pstat -t 来列出终端行。在列表的末尾附近，你应该看到一个 USB 串行 port，例如 "ttyU0"。要打开连接，请使用：

```
# cu -l /dev/ttyU0
```

按下几次回车键后，你将看到一个登录提示。

### 连接到 macOS 上的 USB 设备模式串行 Ports

要连接到配置为提供 USB 设备模式串行 ports 的板，将 USB 主机（如笔记本电脑）连接到板的 USB OTG 或 USB 客户端 port。要打开连接，请使用：

```
# cu -l /dev/cu.usbmodemFreeBSD1
```

### 从 Linux 连接到 USB 设备模式串行 Ports

要连接配置为提供 USB 设备模式串行 ports 的板，将 USB 主机（例如笔记本电脑）连接到板的 USB OTG 或 USB 客户端 port。要打开连接，请使用：

```
# minicom -D /dev/ttyACM0
```

### 28.2.5. 从 Microsoft Windows 10 连接到 USB 设备模式串行 Ports

要连接配置为提供 USB 设备模式串行 ports 的板，将 USB 主机（例如笔记本电脑）连接到板的 USB OTG 或 USB 客户端 port。要打开连接，你需要一个串行终端程序，例如 PuTTY。要检查 Windows 使用的 COM port 名称，请运行设备管理器，展开 "Ports (COM & LPT)"。你将看到类似于 "USB 串行设备 (COM4)" 的名称。运行你选择的串行终端程序，例如 PuTTY。在 PuTTY 对话框中设置 "连接类型" 为 "串行"，在 "串行行" 对话框中输入从设备管理器获取的 COMx，然后点击打开。
