# 28.4.USB 虚拟存储设备

|  | cfumass(4)驱动程序是一种 USB 设备模式驱动程序，首次在 FreeBSD 12.0 中提供。|
| -- | ----------------------------------------------------------------------------- |

模板 0 和 10 提供了大容量存储目标。必须加载 usb_template(4) 和 cfumass(4) 内核模块。cfumass(4) 接口与 CTL 子系统配合，该子系统也用于 iSCSI 或光纤通道目标。在主机端，USB 大容量存储发起者只能访问单个逻辑单元（LUN 0）。

### 28.4.1. 使用 cfumass 启动脚本配置 USB 大容量存储目标

设置只读 USB 存储目标的最简单方法是使用 cfumass rc 脚本。要以这种方式配置它，请将要呈现给 USB 主机机器的文件复制到 /var/cfumass 目录，并将此行添加到 /etc/rc.conf 中：

```
cfumass_enable="YES"
```

通过运行此命令，可以在不重启的情况下配置目标。

```
# service cfumass start
```

与串行和网络功能不同，模板不应设置为 0 或 10 在/boot/loader.conf 中。这是因为在设置模板之前必须设置 LUN。当启动时，cfumass 启动脚本会自动设置正确的模板编号。

### 28.4.2. 使用其他方式配置 USB 大容量存储

本章的其余部分详细说明了在不使用 cfumass rc 文件的情况下设置目标的方法。例如，如果有人想提供一个可写的逻辑单元号（LUN），这是必需的。

USB 大容量存储设备在运行时不需要 ctld(8)守护程序，尽管如果需要可以使用。这与 iSCSI 不同。因此，有两种配置目标的方法：ctladm(8)或 ctld(8)。这两种方法都需要加载 cfumass.ko 内核模块。该模块可以手动加载：

```
# kldload cfumass
```

如果 cfumass.ko 没有内建到内核中，/boot/loader.conf 可以设置为在引导时加载该模块：

```
cfumass_load="YES"
```

可以在没有 ctld(8)守护程序的情况下创建一个 LUN：

```
# ctladm create -b block -o file=/data/target0
```

这将把镜像文件/data/target0 呈现为一个 LUN 给 USB 主机。在执行命令之前，文件必须存在。要在系统启动时配置 LUN，请将命令添加到/etc/rc.local 中。

ctld(8)也可以用来管理 LUN。创建/etc/ctl.conf，向/etc/rc.conf 添加一行以确保在启动时自动启动 ctld(8)，然后启动守护程序。

这是一个简单的/etc/ctl.conf 配置文件示例。有关选项的完整说明，请参阅 ctl.conf(5)。

```
target naa.50015178f369f092 {
	lun 0 {
		path /data/target0
		size 4G
	}
}
```

该示例创建一个具有单个 LUN 的单个目标。naa.50015178f369f092 是由 32 个随机十六进制数字组成的设备标识符。path 行定义了备份 LUN 文件或 zvol 的完整路径。在启动 ctld(8)之前，该文件必须存在。第二行是可选的，用于指定 LUN 的大小。

要确保 ctld(8)守护程序在启动时运行，请将此行添加到/etc/rc.conf 中：

```
ctld_enable="YES"
```

现在启动 ctld(8)，运行此命令：

```
# service ctld start
```

当 ctld(8) 守护进程启动时，它会读取 /etc/ctl.conf 文件。如果在守护进程启动后编辑了此文件，请重新加载更改，以立即生效：

```
# service ctld reload
```
