# 29.2.串行术语和硬件

以下术语常用于串行通信：

bps

每秒位元數 (bps) 是數據傳輸的速率。

DTE

数据终端设备（DTE）是串行通信中的两个端点之一。一个例子是计算机。

DCE

数据通信设备（DCE）是串行通信中的另一个端点。通常是调制解调器或串行终端。

RS-232

最初定义硬件串行通信的原始标准。后来改名为 TIA-232。

在涉及通信数据速率时，本节不使用波特率一词。波特率是指在一段时间内进行的电气状态转换的次数，而 bps 是要使用的正确术语。

要将串行终端连接到 FreeBSD 系统，计算机上需要一个串行port和正确的电缆连接到串行设备。已熟悉串行硬件和布线的用户可以安全地跳过本节。

### 29.2.1. 串行电缆和Ports

有几种不同类型的串行电缆。最常见的两种类型是空模拟电缆和标准 RS-232 电缆。硬件文档应说明所需电缆的类型。

这两种类型的电缆在连接线与连接器的连接方式上有所不同。每根导线代表一个信号，定义的信号总结在 RS-232C 信号名称中。标准串行电缆直接传递所有 RS-232C 信号。例如，电缆一端的“发送数据”引脚连接到另一端的“发送数据”引脚。这是用于将调制解调器连接到 FreeBSD 系统的电缆类型，并且也适用于某些终端。

空讯号电缆将一个连接器端的“发送数据”引脚与另一端的“接收数据”引脚进行切换。连接器可以是 DB-25 或 DB-9。

可以使用 DB-25 到 DB-25 空讯号电缆、DB-9 到 DB-9 空讯号电缆和 DB-9 到 DB-25 空讯号电缆中总结的引脚连接来构建空讯号电缆。虽然标准要求直通引脚 1 到引脚 1 的“保护地”线路，但通常会省略。一些终端仅使用引脚 2、3 和 7，而其他终端需要不同的配置。如果有疑问，请参考硬件的文档。

RS-232C 信号名称表 1

| 缩写词 | 名称         |
| -------- | -------------- |
| RD     | 已收到的数据 |
| TD     | 发送的数据   |
| DTR    | 数据终端就绪 |
| DSR    | 数据集就绪   |
| DCD    | 数据载体检测 |
| SG     | 信号地       |
| RTS    | 请求发送     |
| CTS    | 清除发送     |

Table 2. DB-25 to DB-25 Null-Modem Cable|Signal

| 针脚 |    | 针脚   | 信号 |     |
| ------ | ---- | -------- | ------ | ----- |
| SG   | 7  | 连接到 | 7    | SG  |
| TD   | 2  | 连接到 | 3    | RD  |
| RD   | 3  | 连接到 | 2    | TD  |
| RTS  | 4  | 连接到 | 5    | CTS |
| CTS  | 5  | 连接到 | 4    | RTS |
| DTR  | 20 | 连接到 | 6    | DSR |
| DTR  | 20 | 连接到 | 8    | DCD |
| DSR  | 6  | 连接到 | 20   | DTR |
| DCD  | 8  | 连接到 | 20   | DTR |

表 3。DB-9 到 DB-9 空调调制电缆

| 信号 | 引脚号 |        | 针脚 # | 信号 |
| ------ | -------- | -------- | -------- | ------ |
| RD   | 2      | 连接至 | 3      | TD   |
| TD   | 3      | 连接到 | 2      | RD   |
| DTR  | 4      | 连接到 | 6      | DSR  |
| DTR  | 4      | 连接到 | 1      | DCD  |
| SG   | 5      | 连接到 | 5      | SG   |
| DSR  | 6      | 连接到 | 4      | DTR  |
| DCD  | 1      | 连接到 | 4      | DTR  |
| RTS  | 7      | 连接到 | 8      | CTS  |
| CTS  | 8      | 连接到 | 7      | RTS  |

表 4。DB-9 到 DB-25 空调调制电缆

| 信号 | 引脚 # |        | 引脚 # | 信号 |
| ------ | -------- | -------- | -------- | ------ |
| RD   | 2      | 连接到 | 2      | TD   |
| TD   | 3      | 连接到 | 3      | RD   |
| DTR  | 4      | 连接到 | 6      | DSR  |
| DTR  | 4      | 连接到 | 8      | DCD  |
| SG   | 5      | 连接到 | 7      | SG   |
| DSR  | 6      | 连接到 | 20     | DTR  |
| DCD  | 1      | 连接到 | 20     | DTR  |
| RTS  | 7      | 连接到 | 5      | CTS  |
| CTS  | 8      | 连接到 | 4      | RTS  |

|  | 当一个端口连接到另一端的一对端口时，通常使用一根短线连接这对端口的连接器，并使用一根长线连接到另一个单独的端口。|
| -- | ------------------------------------------------------------------------------------------------------------------ |

串行ports是在 FreeBSD 主机计算机和终端之间传输数据的设备。有几种类型的串行ports存在。在购买或构建电缆之前，请确保它适配终端和 FreeBSD 系统上的ports。

大多数终端都有 DB-25 ports。个人计算机可能有 DB-25 或 DB-9 ports。多端口串行卡可能有 RJ-12 或 RJ-45/ ports。查看随附硬件的文档，了解port类型的规格，或通过视觉验证port的类型。

在 FreeBSD 中，每个串行port通过/dev 中的条目进行访问。有两种不同类型的条目：

* 呼入ports命名为/dev/ttyuN，其中 N 是port号，从零开始。如果终端连接到第一个串行port（COM1），请使用/dev/ttyu0 来引用终端。如果终端在第二个串行port（COM2）上，则使用/dev/ttyu1 等等。通常，呼入port用于终端。呼入ports要求串行线正确断开"数据载波检测"信号。
* 在 FreeBSD 8.X 及更高版本上，Call-out ports 被命名为/dev/cuauN，在 FreeBSD 7.X 及更低版本上则为/dev/cuadN。通常情况下，Call-out ports 不用于终端，而是用于调制解调器。如果串行电缆或终端不支持“数据载波检测”信号，可以使用 Call-out port。

FreeBSD 还提供初始化设备（/dev/ttyuN.init 和/dev/cuauN.init 或/dev/cuadN.init）和锁定设备（/dev/ttyuN.lock 和/dev/cuauN.lock 或/dev/cuadN.lock）。初始化设备用于每次打开port时初始化通信port参数，例如对于使用 RTS/CTS 信号的调制解调器的 crtscts 流控制信号。锁定设备用于锁定ports上的标志，防止用户或程序更改某些参数。有关终端设置、锁定和初始化设备以及设置终端选项的信息，请参阅 termios(4)、uart(4)和 stty(1)。

### 29.2.2. 串行Port配置

默认情况下，FreeBSD 支持四个串行端口，通常称为 COM1、COM2、COM3 和 COM4。FreeBSD 还支持一些简单的多串行接口卡，例如 BocaBoard 1008 和 2016，以及更智能的多串行卡，如 Digiboard 生产的卡。然而，默认内核只查找标准的 COM 端口。

要查看系统是否识别串行端口，请查看以 uart 开头的系统引导消息：

```
# grep uart /var/run/dmesg.boot
```

如果系统没有识别所有需要的串行端口，可以在 /boot/device.hints 中添加额外的条目。该文件已经包含了 COM1 的 hint.uart.0.* 条目和 COM2 的 hint.uart.1.* 条目。当为 COM3 添加一个 port 条目时，请使用 0x3E8，对于 COM4 使用 0x2E8。常见的 IRQ 地址是 COM3 的 5，COM4 的 9。

为了确定port使用的默认终端 I/O 设置，请指定其设备名称。本例确定 COM2 上 call-in 的设置：

```
# stty -a -f /dev/ttyu1
```

系统范围内的串行设备初始化由/etc/rc.d/serial 控制。此文件会影响串行设备的默认设置。要更改设备的设置，请使用 stty。默认情况下，更改后的设置有效，直到关闭设备，再次打开设备时，设备会恢复为默认设置。要永久更改默认设置，请打开并调整初始化设备的设置。例如，要打开 CLOCAL 模式，进行 8 位通信，并为 ttyu5 启用 XON/XOFF 流控制，请输入：

```
# stty -f /dev/ttyu5.init clocal cs8 ixon ixoff
```

要防止应用程序更改某些设置，请对锁定设备进行调整。例如，要将 ttyu5 的速度锁定为 57600 bps，请输入：

```
# stty -f /dev/ttyu5.lock 57600
```

现在，任何打开 ttyu5 并尝试更改port速度的应用程序都将被困在 57600 bps。
