# 29.3.终端

终端提供了一种方便和低成本的方式，可以在没有连接到计算机控制台或网络的情况下访问 FreeBSD 系统。本节介绍如何在 FreeBSD 中使用终端。

最初的 UNIX®系统没有控制台。相反，用户登录并通过连接到计算机串口的终端运行程序。

在几乎每个类 UNIX®操作系统中，包括 FreeBSD，仍然存在在串口上建立登录会话的能力。通过使用连接到未使用串口的终端，用户可以登录并运行通常可以在控制台或 xterm 窗口中运行的任何文本程序。

许多终端可以连接到 FreeBSD 系统。一个旧的备用计算机可以被用作有线连接到运行 FreeBSD 的更强大的计算机的终端。这可以将原本可能是单用户计算机变成功能强大的多用户系统。

FreeBSD 支持三种类型的终端：

 傻瓜终端

傻瓜终端是连接到计算机的专用硬件，通过串行线路连接。它们被称为“傻瓜”，因为它们只有足够的计算能力来显示、发送和接收文本。在这些设备上无法运行任何程序。相反，愚蠢的终端连接到运行所需程序的计算机。

有许多制造商生产的各种类型的哑终端，几乎任何一种都可以与 FreeBSD 一起使用。一些高端终端甚至可以显示图形，但只有某些软件包才能利用这些高级功能。

哑终端在工作环境中很流行，工人们不需要访问图形应用程序。

作为终端的计算机

由于哑终端仅具有显示、发送和接收文本的能力，任何多余的计算机都可以成为哑终端。所需的只是正确的电缆和一些终端模拟软件，可以在计算机上运行。

这种配置可能很有用。例如，如果一个用户正在忙于在 FreeBSD 系统的控制台上工作，另一个用户可以同时从连接到 FreeBSD 系统的终端的性能较弱的个人计算机上进行一些仅限文本的工作。

FreeBSD 基本系统中至少有两个实用程序可用于通过串行连接工作：cu(1)和 tip(1)。

例如，要从运行 FreeBSD 的客户端系统连接到另一个系统的串行连接：

```
# cu -l /dev/cuauN
```

Ports 从零开始编号。这意味着 COM1 是/dev/cuau0。

通过Ports 可以获得其他程序，例如 comms/minicom。

 X 终端

X 终端是可用的最复杂的终端种类之一。与连接到串行 port 不同，它们通常连接到像以太网这样的网络。而不仅仅被限制于文本应用程序，它们可以显示任何 Xorg 应用程序。

本章不涉及 X 终端的设置、配置或使用。

### 29.3.1. 终端配置

本节说明如何配置 FreeBSD 系统以在串行终端上启用登录会话。假定系统识别连接到终端的串行设备 port，并且终端使用正确的电缆连接。

在 FreeBSD 中，init 读取 /etc/ttys 并在可用终端上启动一个 getty 进程。getty 进程负责读取登录名并启动 login 程序。在 FreeBSD 系统上能让登录的终端列在 /etc/ttys 中。例如，第一个虚拟控制台 ttyv0 在此文件中有一个条目，能让在控制台上登录。该文件还包含其他虚拟控制台、串行 ports 和伪终端的条目。对于硬连线终端，串行 port 的 /dev 条目会被列出，不包含 /dev 部分。例如，/dev/ttyv0 被列为 ttyv0。

默认的 /etc/ttys 配置支持前四个串行 ports，即 ttyu0 到 ttyu3：

```
ttyu0   "/usr/libexec/getty std.115200"   dialup  off secure
ttyu1   "/usr/libexec/getty std.115200"   dialup  off secure
ttyu2   "/usr/libexec/getty std.115200"   dialup  off secure
ttyu3   "/usr/libexec/getty std.115200"   dialup  off secure
```

当连接终端到这些 ports 中的一个时，修改默认条目以设置所需的速度和终端类型，使设备 on 并且，如有需要，更改port 的 secure 设置。如果终端连接到另一个port，请为port添加条目。

在 /etc/ttys 中配置终端条目配置两个终端。第一条目配置连接到 COM2 的 Wyse-50。第二个条目配置运行模拟 VT-100 终端的 Procomm 终端软件的旧计算机。计算机连接到多 port 串行卡上的第六个串行 port。

示例 1。配置终端条目

```
ttyu1  "/usr/libexec/getty std.38400"  wy50   on insecure
ttyu5   "/usr/libexec/getty std.19200"  vt100  on insecure
```

第一个字段指定串行终端的设备名称。

第二个字段告诉 getty 初始化和打开线路，设置线路速度，提示用户名，然后执行 login 程序。可选的 getty 类型配置终端线路上的特性，如 bps 速率和奇偶校验。可用的 getty 类型列在/etc/gettytab 中。在几乎所有情况下，以 std 开头的 getty 类型将适用于有线终端，因为这些条目忽略奇偶校验。每个 bps 速率从 110 到 115200 都有一个 std 条目。更多信息，请参阅 gettytab（5）。设置 getty 类型时，请确保与终端使用的通信设置相匹配。对于本示例，Wyse-50 不使用奇偶校验，以 38400 bps 连接。计算机不使用奇偶校验，以 19200 bps 连接。

第三个字段是终端类型。对于拨号 ports，通常使用 unknown 或 dialup，因为用户可以使用几乎任何类型的终端或软件进行拨号。由于有线终端的终端类型不会改变，可以指定来自 /etc/termcap 的真实终端类型。在此示例中，Wyse-50 使用真实终端类型，而运行 Procomm 的计算机设置为模拟 VT-100。

第四个字段指定是否应启用 port。要在此 port 上启用登录，必须将此字段设置为 on。

最后一个字段用于指定 port 是否安全。将 port 标记为 secure 表示它足够受信任，能让 root 从该 port 登录。不安全的 ports 不能让 root 登录。在不安全的 port 上，用户必须从非特权账户登录，然后使用 su 或类似机制获取超级用户特权，如“超级用户账户”中所述。出于安全原因，建议将此设置更改为 insecure。

在对 /etc/ttys 进行任何更改后，向 init 进程发送 SIGHUP（挂断）信号，以强制它重新读取其配置文件：

```
# kill -HUP 1
```

由于 init 总是在系统上运行的第一个进程，因此它的进程 ID 总是 1。

如果一切设置正确，所有电缆都连接好，并且终端已经启动，那么每个终端上现在应该运行一个 getty 进程，并且每个终端都应该有登录提示。

### 29.3.2. 诊断连接问题

即使在设置终端时注意细节，仍然可能出现问题。以下是一些常见症状和一些建议性修复措施的列表。

如果没有出现登录提示符，请确保终端已插好电并已上电。如果是个人电脑充当终端，请确保它在正确的串行端口上运行终端模拟软件。

确保电缆牢固连接到终端和 FreeBSD 计算机。确保它是正确类型的电缆。

确保终端和 FreeBSD 就 bps 速率和奇偶校验设置达成一致。对于视频显示终端，请确保对比度和亮度控件调高。如果是打印终端，请确保有充足的纸张和墨水。

使用 ps 确保一个 getty 进程正在运行并为终端提供服务。例如，以下列表显示第二个串行port，ttyu1 上正在运行一个 getty，并且正在使用/etc/gettytab 中的 std.38400 条目。

```
# ps -axww|grep ttyu
22189  d1  Is+    0:00.03 /usr/libexec/getty std.38400 ttyu1
```

如果没有 getty 进程在运行，请确保在 /etc/ttys 中启用 port。记得在修改 /etc/ttys 后运行 kill -HUP 1。

如果 getty 进程正在运行，但终端仍不显示登录提示，或者显示提示但无法接受键入的输入，则终端或电缆可能不支持硬件握手。尝试将 /etc/ttys 中的条目从 std.38400 更改为 3wire.38400，然后在修改 /etc/ttys 后运行 kill -HUP 1。3wire 条目类似于 std，但会忽略硬件握手。当使用 3wire 时，bps 也可能需要减少或启用软件流控制以防止缓冲区溢出。

如果显示垃圾而不是登录提示，请确保终端和 FreeBSD 对于 bps 率和奇偶校验设置达成一致。检查 getty 进程，以确保使用正确的 getty 类型。如果没有，请编辑 /etc/ttys 并运行 kill -HUP 1。

如果字符显示为双倍，并且在键入密码时显示密码，请将终端或终端模拟软件从“半双工”或“本地回显”切换到“全双工”。
