# 29.4.拨入服务

配置 FreeBSD 系统用于拨入服务与配置终端类似，不同之处在于使用调制解调器而不是终端设备。FreeBSD 支持外部和内部调制解调器。

外置调制解调器更方便，因为它们通常可以通过存储在非易失性 RAM 中的参数进行配置，并且它们通常提供发光指示灯，显示重要的 RS-232 信号的状态，指示调制解调器是否正常运行。

内置调制解调器通常缺乏非易失性 RAM，因此它们的配置可能仅限于设置 DIP 开关。如果内置调制解调器有任何信号指示灯，则在系统盖板安装好后很难查看。

使用外置调制解调器时，需要合适的电缆。标准的 RS-232C 串行电缆应该足够。

FreeBSD 在 2400 bps 以上的速度下需要 RTS 和 CTS 信号进行流量控制，CD 信号用于检测呼叫是否已经接通或线路是否已挂断，并需要 DTR 信号在会话结束后重置调制解调器。有些电缆并没有连接所有需要的信号，所以如果登录会话在挂断线路后仍然存在，可能是电缆有问题。有关这些信号的更多信息，请参考串行电缆和Ports。

与其他类 UNIX®操作系统一样，FreeBSD 使用硬件信号来判断呼叫是否已经接通或线路是否已挂断，并在呼叫结束后挂断和重置调制解调器。FreeBSD 避免向调制解调器发送命令或等待调制解调器发送状态报告。

FreeBSD 支持基于 NS8250、NS16450、NS16550 和 NS16550A 的 RS-232C（CCITT V.24）通信接口。8250 和 16450 设备具有单字符缓冲区。16550 设备提供了 16 字符缓冲区，可以提高系统性能。普通的 16550 设备中存在缺陷，无法使用 16 字符缓冲区，因此尽可能使用 16550A 设备。由于单字符缓冲区设备需要操作系统执行更多工作，所以更倾向于使用 16550A 为基础的串行接口卡。如果系统有许多活动串行ports或将承受重负载，基于 16550A 的卡对于低错误率通信更为适合。

本节的其余部分演示了如何配置调制解调器以接收传入连接，如何与调制解调器通信，并提供一些故障排除技巧。

### 29.4.1. 调制解调器配置

与终端一样，init 为每个配置的串行 port 生成一个用于拨入连接的进程。当用户拨号调制解调器的线路并且调制解调器连接时，调制解调器会报告“载波检测”信号。内核注意到已检测到载波并指示 getty 打开 port 并以指定的初始线路速度显示 login: 提示符。在典型配置中，如果接收到垃圾字符，通常是由于调制解调器的连接速度与配置速度不同，getty 会尝试调整线路速度，直到接收到合理的字符。用户输入其登录名后，getty 执行 login，通过要求用户输入密码然后启动用户的 shell 完成登录过程。

有关拨号调制解调器有两种思路。一种配置方法是设置调制解调器和系统，以便无论远程用户以何种速度拨号，拨入 RS-232 接口始终以固定速度运行。这种配置的好处是远程用户总是能立即看到系统登录提示。缺点是系统不知道用户的真实数据速率，因此像 Emacs 这样的全屏程序不会调整其屏幕绘制方法，以提供更好的响应速度给速度较慢的连接。

第二种方法是根据远程用户的连接速度配置 RS-232 接口以变化其速度。由于 getty 不理解任何特定调制解调器的连接速度报告，它在初始速度给出 login: 消息，并观察返回的字符。如果用户看到垃圾数据，他们应该按回车键，直到看到可识别的提示符。如果数据速率不匹配，getty 将看到用户输入的任何内容都是垃圾数据，尝试下一个速度，并再次给出 login: 提示符。通常，用户只需按下一两个按键就能看到一个良好的提示符。这种登录顺序看起来不如固定速度方法干净，但在低速连接上，用户应该能获得更好的全屏程序交互响应。

当将调制解调器的数据通信速率锁定在特定速度时，不需要对 /etc/gettytab 进行任何更改。然而，对于匹配速度配置，可能需要添加额外的条目以定义用于调制解调器的速度。此示例配置一个速率为 14.4 千比特每秒的调制解调器，顶部接口速率为 19.2 千比特每秒，使用 8 位、无校验连接。它配置 getty 以在 V.32bis 连接上开始通信速率为 19.2 千比特每秒，然后循环遍历 9600 bps、2400 bps、1200 bps、300 bps，并回到 19.2 千比特每秒。通信速率循环使用了 nx= （下一个表）功能。每行使用 tc= （表续行）条目来获取特定数据速率的其余设置。

```
#
# Additions for a V.32bis Modem
#
um|V300|High Speed Modem at 300,8-bit:\
        :nx=V19200:tc=std.300:
un|V1200|High Speed Modem at 1200,8-bit:\
        :nx=V300:tc=std.1200:
uo|V2400|High Speed Modem at 2400,8-bit:\
        :nx=V1200:tc=std.2400:
up|V9600|High Speed Modem at 9600,8-bit:\
        :nx=V2400:tc=std.9600:
uq|V19200|High Speed Modem at 19200,8-bit:\
        :nx=V9600:tc=std.19200:
```

对于 28.8 千比特每秒的调制解调器，或者为了利用 14.4 千比特每秒调制解调器上的压缩功能，使用更高的通信速率，就像在这个示例中所见的那样：

```
#
# Additions for a V.32bis or V.34 Modem
# Starting at 57.6 Kbps
#
vm|VH300|Very High Speed Modem at 300,8-bit:\
        :nx=VH57600:tc=std.300:
vn|VH1200|Very High Speed Modem at 1200,8-bit:\
        :nx=VH300:tc=std.1200:
vo|VH2400|Very High Speed Modem at 2400,8-bit:\
        :nx=VH1200:tc=std.2400:
vp|VH9600|Very High Speed Modem at 9600,8-bit:\
        :nx=VH2400:tc=std.9600:
vq|VH57600|Very High Speed Modem at 57600,8-bit:\
        :nx=VH9600:tc=std.57600:
```

对于没有基于 16550A 的串行ports、慢 CPU 或负载严重的系统，此配置可能会在 57.6 千比特每秒产生 uart ”传输暂存器溢出“错误。

/etc/ttys 的配置类似于配置终端条目，但传递给 getty 的参数不同，并且用于终端类型的是 dialup。用进程 init 替换 xxx 将在设备上运行：

```
ttyu0   "/usr/libexec/getty xxx"   dialup on
```

dialup 终端类型可以更改。例如，将 vt102 设置为默认终端类型能让用户在其远程系统上使用 VT102 仿真。

对于锁定速度配置，请使用/etc/gettytab 中列出的有效类型指定速度。此示例是针对一个调制解调器，其port速度锁定在 19.2 Kbps：

```
ttyu0   "/usr/libexec/getty std.19200"   dialup on
```

在匹配速度配置中，条目需要引用 /etc/gettytab 中适当的起始 "auto-baud" 条目。继续上面的例子，对于以 19.2 Kbps 开始的匹配速度调制解调器，请使用此条目：

```
ttyu0   "/usr/libexec/getty V19200"   dialup on
```

在编辑 /etc/ttys 后，在调制解调器正确配置并连接之前等待信号 init ：

```
# kill -HUP 1
```

高速调制解调器，如 V.32、V.32bis 和 V.34 调制解调器，使用硬件（ RTS/CTS ）流控制。使用 stty 为调制解调器 port 设置硬件流控制标志。此示例在 COM2 的拨入和拨出初始化设备上设置 crtscts 标志：

```
# stty -f /dev/ttyu1.init crtscts
# stty -f /dev/cuau1.init crtscts
```

### 29.4.2. 故障排除

本节提供一些关于无法连接到 FreeBSD 系统的拨号调制解调器故障排除的技巧。

将调制解调器连接到 FreeBSD 系统并启动系统。如果调制解调器有状态指示灯，请观察当系统控制台出现 login: 提示时调制解调器的 DTR 指示灯是否亮起。如果它亮起，这应该意味着 FreeBSD 在适当的通信 port 上启动了 getty 进程，并且正在等待调制解调器接受呼叫。

如果 DTR 指示灯不亮，请通过控制台登录到 FreeBSD 系统，并键入 ps ax 以查看 FreeBSD 是否在正确的port上运行进程：

```
  114 ??  I      0:00.10 /usr/libexec/getty V19200 ttyu0
```

如果第二列包含 d0 而不是 ??，并且调制解调器尚未接受呼叫，则意味着 getty 已经在通信port上完成了其打开。这可能表明存在与布线或调制解调器配置不正确有关的问题，因为 getty 在调制解调器断开信号被断言之前不应该能够打开通信port。

如果没有等待打开port的 getty 进程，请仔细检查/etc/ttys 中port的条目是否正确。另外，检查/var/log/messages 以查看是否有来自 init 或 getty 的任何日志消息。

接下来，请尝试拨入系统。确保在远程系统上使用 8 位，无校验位和 1 个停止位。如果提示未立即出现，或者提示显示垃圾信息，请尝试每秒按一次回车键。如果仍然没有 login: 提示，请尝试发送 BREAK。当使用高速调制解调器时，在锁定拨号调制解调器接口速度后再次拨号。

如果仍然没有 login: 提示，请再次检查/etc/gettytab，并仔细检查：

* 在/etc/ttys 中条目中指定的初始功能名称与/etc/gettytab 中功能的名称匹配。
* 每个 nx= 条目都与另一个 gettytab 能力名称匹配。
* 每个 tc= 条目都与另一个 gettytab 能力名称匹配。

如果 FreeBSD 系统上的调制解调器没有响应，请确保调制解调器配置为在 DTR 断开时接听电话。如果调制解调器似乎配置正确，请通过检查调制解调器的指示灯来验证 DTR 线是否被断开。

如果仍然不起作用，请尝试发送电子邮件到 FreeBSD 普通问题邮件列表，说明调制解调器和问题。
