# 29.5.拨出服务

以下是让主机通过调制解调器连接到另一台计算机的提示。这适用于与远程主机建立终端会话。

如果使用 PPP 遇到问题，这种连接方式可以帮助你从互联网获取文件。如果 PPP 无法正常工作，请使用终端会话通过 FTP 获取所需文件，然后使用 zmodem 将其传输到计算机。

### 29.5.1. 使用标准的 Hayes 调制解调器

泛用的 Hayes 拨号器已经内建于 tip。在/etc/remote 中使用 at=hayes。

Hayes 驱动程序不够智能，无法识别较新调制解调器消息的一些高级功能，如 BUSY，NO DIALTONE 或 CONNECT 115200。在使用 ATX0&W 时关闭这些消息。

tip 的拨号超时为 60 秒。调制解调器应该使用更短的时间，否则 tip 会认为存在通信问题。尝试 ATS7=45&W。

### 29.5.2. 使用 AT 命令

在 /etc/remote 中创建一个“直接”条目。例如，如果调制解调器连接到第一个串口 port，/dev/cuau0，请使用以下行：

```
cuau0:dv=/dev/cuau0:br#19200:pa=none
```

在 br 能力中使用调制解调器支持的最高 bps 率。然后，键入 tip cuau0 连接到调制解调器。

或者，使用以下命令将 cu 作为 root。

```
# cu -lline -sspeed
```

line 是串行 port，例如 /dev/cuau0，速度是速度，例如 57600。输入完成 AT 指令后，请输入 ~. 退出。

### 29.5.3. @ 标记不起作用

电话号码能力中的 @ 标记告诉 tip 在 /etc/phones 中查找电话号码。但是，像 /etc/remote 这样的能力文件中的 @ 标记也是特殊字符，因此需要用反斜杠进行转义：

```
pn=\@
```

### 29.5.4. 从命令行拨号

在/etc/remote 中放入一个“通用”条目。例如：

```
tip115200|Dial any phone number at 115200 bps:\
        :dv=/dev/cuau0:br#115200:at=hayes:pa=none:du:
tip57600|Dial any phone number at 57600 bps:\
        :dv=/dev/cuau0:br#57600:at=hayes:pa=none:du:
```

现在应该可以工作了：

```
# tip -115200 5551234
```

喜欢 cu 而不是 tip 的用户，可以使用通用的 cu 条目：

```
cu115200|Use cu to dial any number at 115200bps:\
        :dv=/dev/cuau1:br#57600:at=hayes:pa=none:du:
```

 并键入：

```
# cu 5551234 -s 115200
```

### 29.5.5. 设置 bps 率

将 tip1200 或 cu1200 的条目放入，但可以使用与 br 功能兼容的任何 bps 速率。tip 认为一个良好的默认值是 1200 bps，这就是为什么它寻找一个 tip1200 条目。但不一定非要使用 1200 bps。

### 29.5.6. 通过终端服务器访问多个主机

与其每次等待连接并输入 CONNECT<span> </span><em>host</em>，不如使用 tip 的 cm 功能。例如，/etc/remote 中的这些条目将让你输入 tip pain 或 tip muffin 来连接到主机 pain 或 muffin，以及输入 tip deep13 来连接到终端服务器。

```
pain|pain.deep13.com|Forrester's machine:\
        :cm=CONNECT pain\n:tc=deep13:
muffin|muffin.deep13.com|Frank's machine:\
        :cm=CONNECT muffin\n:tc=deep13:
deep13:Gizmonics Institute terminal server:\
        :dv=/dev/cuau2:br#38400:at=hayes:du:pa=none:pn=5551234:
```

### 29.5.7. 使用多行与 tip

这通常是一个问题，当一个大学有几条调制解调器线路和几千名学生试图使用它们时。

在 /etc/remote 中进行条目并使用 @ 来进行 pn 的功能：

```
big-university:\
        :pn=\@:tc=dialout
dialout:\
        :dv=/dev/cuau3:br#9600:at=courier:du:pa=none:
```

接着，在/etc/phones 中列出电话号码：

```
big-university 5551111
big-university 5551112
big-university 5551113
big-university 5551114
```

tip 会按照列出的顺序尝试每个号码，然后放弃。要保持重试，请在 while 循环中运行 tip。

### 29.5.8. 使用 Force 字符

Ctrl+P 是默认的“强制”字符，用于告诉 tip 下一个字符是文字数据。可以使用 ~s 转义来将强制字符设置为任何其他字符，意味着“设置一个变量”。

输入 ~sforce=<em>single-char</em>，然后换行。单字符是任何单个字符。如果省略单字符，则强制字符是空字符，通过按 Ctrl+2 或 Ctrl+Space 访问。单字符的一个很好的值是 Shift+Ctrl+6，只在某些终端服务器上使用。

要更改强制字符，请在~/.tiprc 中指定以下内容：

```
force=single-char
```

### 29.5.9. 大写字符

当按下 Ctrl+A 时会发生这种情况，这是 tip 的“提升字符”，专为键盘大写锁定键损坏的用户设计。使用 ~s 来设置 raisechar 为合理的值。如果未使用这些功能，它可以设置为与力字符相同。

这里是一个针对需要在 Emacs 中键入 Ctrl+2 和 Ctrl+A 的用户的示例 ~/.tiprc：

```
force=^^
raisechar=^^
```

`^^` 为 Shift+Ctrl+6。

### 29.5.10. 使用 tip 进行文件传输

当与另一个类 UNIX®操作系统交流时，可以使用 ~p （放置）和 ~t （接收）发送和接收文件。这些命令在远程系统上运行 cat 和 echo 以接受和发送文件。语法是： ~p 本地文件 [ 远程文件 ] ~t 远程文件 [ 本地文件 ]

没有错误检查，因此可能应该使用另一个协议，比如 zmodem。

### 29.5.11. 使用 zmodem 与 tip ？

要接收文件，请在远程端启动发送程序。然后，键入 ~C rz 以开始在本地接收它们。

发送文件，请在远程端启动接收程序。然后，输入 ~C sz<span> </span><em>files</em> 将文件发送到远程系统。
