# 29.6.设置串行控制台

FreeBSD 具有使用串行port上的哑终端引导系统的能力作为控制台。这种配置对于希望在没有键盘或显示器连接的计算机上安装 FreeBSD 的系统管理员以及希望调试内核或设备驱动程序的开发人员非常有用。

根据《FreeBSD 引导过程》，FreeBSD 采用三阶段引导。前两个阶段位于存储在引导磁盘的 FreeBSD 切片开头的引导块代码中。引导块然后加载并运行引导加载程序作为第三阶段代码。

要设置从串行控制台引导，需要配置引导块代码、引导加载程序代码和内核。

### 29.6.1. 快速串行控制台配置

本节提供了设置串行控制台的快速概述。当哑终端连接到 COM1 时，可以使用此过程。

过程：配置 COM1 上的串行控制台

1. 将串行电缆连接到 COM1 和控制终端。
2. 要配置引导消息以在串行控制台上显示，请以超级用户身份发出以下命令：

    ```
    # echo 'console="comconsole"' >> /boot/loader.conf
    ```
3. 编辑 /etc/ttys，并将 off 更改为 on，并将 dialup 更改为 vt100 以用于 ttyu0 条目。否则，通过串行控制台连接时将无需密码，这可能导致安全隐患。
4. 重启系统以查看更改是否生效。

如果需要不同的配置，请参阅下一节，了解更详细的配置说明。

### 29.6.2. 深入串行控制台配置

本部分提供了在 FreeBSD 中设置串行控制台所需步骤的更详细解释。

配置串行控制台的过程

1. 准备一个串行电缆。使用空调调制电缆或标准串行电缆和空调调制适配器。请参阅串行电缆和Ports中关于串行电缆的讨论。
2. | 拔掉键盘。许多系统在自检（POST）期间探测键盘，如果未检测到键盘，将产生错误。一些机器将拒绝启动，直到键盘被插入。|  |
    | 如果计算机抱怨错误，但仍然启动，则不需要进一步配置。|  |
    | 如果计算机在未连接键盘的情况下拒绝启动，请配置 BIOS 以忽略此错误。请参考主板手册了解如何操作。|  |
    |  | 尝试在 BIOS 中将键盘设置为“未安装”。此设置告诉 BIOS 在上电时不要探测键盘，因此如果键盘不存在，它不应抱怨。如果 BIOS 中没有此选项，请查找“错误中止”选项。将其设置为“除键盘外全部”或“无错误”将产生相同的效果。|
    | ------------------------------------------------------------------------------------------------------------------ | -- |

    如果系统有 PS/2® 鼠标，请将其拔掉。PS/2® 鼠标与键盘共享一些硬件，如果将鼠标保持连接可能会让键盘检测程序误以为键盘仍然连接在系统上。

    |  | 大多数系统即使没有键盘也可以启动，但有些系统没有图形适配器是无法启动的。某些系统可以通过在 BIOS 配置中将“图形适配器”设置为“未安装”来配置为没有图形适配器时启动。其他一些系统不支持这个选项，如果系统中没有显示硬件，将拒绝启动。对于这些机器，即使只是一个低质量的单色板图形卡也要保持连接。不需要连接显示器。|
    | -- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
3. 将一个哑终端、一台安装了调制解调程序的旧计算机，或者另一台 UNIX®设备上带有串口port的机器连接到串口port 上。
4. 将适当的 hint.uart.* 条目添加到/boot/device.hints 以配置串行port。某些多串行port卡还需要内核配置选项。请参考 uart(4)获取所需的选项，并查看每个支持的串行port的设备提示。
5. | 在引导驱动器的 a 分区的根目录中创建 boot.config 文件。此文件指示引导块代码如何引导系统。为了激活串行控制台，需要以下一个或多个选项。当使用多个选项时，请将它们全部包含在同一行上： |  |
    | -h 在内部和串行控制台之间切换。使用它来切换控制台设备。例如，要从内部（视频）控制台引导，请使用 -h 来指示引导加载程序和内核使用串行port作为其控制台设备。或者，要从串行port引导，请使用 -h 告诉引导加载程序和内核改为使用视频显示作为控制台。|  |
    | -D 在单一和双重控制台配置之间切换。在单一配置中，控制台将是内部控制台（视频显示）或串行 port，具体取决于 -h 的状态。在双重控制台配置中，无论 -h 的状态如何，视频显示和串行 port 都将同时成为控制台。但是，双重控制台配置仅在引导块运行时生效。引导加载程序控制之后，由 -h 指定的控制台将成为唯一的控制台。|  |
    | -P 使引导块探测键盘。如果未找到键盘，则 -D 和 -h 选项将自动设置。|  |
    |  | 由于当前版本的引导块存在空间限制，-P 仅能检测扩展键盘。少于 101 个键且没有 F11 和 F12 键的键盘可能无法被检测到。由于此限制，某些笔记本电脑上的键盘可能无法正确识别。如果是这种情况，请不要使用 -P。|
    | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | -- |

    使用 -P 来自动选择控制台，或者使用 -h 来激活串行控制台。有关更多详情，请参阅 boot(8)和 boot.config(5)。

    选项，除了 -P 之外，会被传递给引导加载程序。引导加载程序将通过检查 -h 的状态来确定内部视频还是串行port应该成为控制台。这意味着如果在/boot.config 中指定了 -D 但未指定 -h，则串行port只能在引导块期间用作控制台，因为引导加载程序将使用内部视频显示作为控制台。
6. 启动机器。当 FreeBSD 启动时，引导块会将/boot.config 的内容回显到控制台。例如：

    ```
    /boot.config: -P
    Keyboard: no
    ```

    如果 -P 在 /boot.config 中，则第二行仅出现并指示键盘的存在或不存在。这些消息发送到串行端口或内部控制台，或两者皆有，具体取决于 /boot.config 中的选项：

    | 选项          | 消息发送至       |
    | --------------- | ------------------ |
    | 无            | 内部控制台       |
    | `-h`              | 串行控制台       |
    | `-D`              | 串行和内部控制台 |
    | `-Dh`              | 串行和内部控制台 |
    | -P，键盘存在 | 内部控制台       |
    | -P，键盘缺失 | 串行控制台       |

    在消息之后，在引导块继续加载引导加载程序之前，在向控制台打印任何进一步消息之前，将会有一个小的暂停。在正常情况下，不需要中断引导块，但可以这样做以确保设置正确。

    在控制台按任意键（除回车键外）以中断引导过程。然后引导块将提示进一步操作：

    ```
    >> FreeBSD/i386 BOOT
    Default: 0:ad(0,a)/boot/loader
    boot:
    ```

    验证上述消息是否出现在串行或内部控制台上，或两者都有，根据/boot.config 中的选项。如果消息出现在正确的控制台上，请按回车键继续引导过程。

    如果串行终端没有提示，则设置有问题。输入 -h 然后按回车键 或 Return 告诉引导块（然后是引导加载程序和内核）选择串行port作为控制台。系统启动后，返回并检查出了什么问题。

在引导过程的第三阶段，可以通过在引导加载程序中设置适当的环境变量而在内部控制台和串行控制台之间切换。有关更多信息，请参阅 loader（8）。

```
console="comconsole"
```

该行应该是/boot/loader.conf 的第一行，以便尽快在串行控制台上显示启动消息。

如果该行不存在，或者设置为 console="vidconsole"，引导加载程序和内核将使用引导块中 -h 指示的控制台。有关更多信息，请参阅 loader.conf(5)。

目前，引导加载程序没有在引导块中等价于 -P 的选项，也没有根据键盘存在情况自动选择内部控制台和串行控制台的规定。

|  | 虽然不是必需的，但可以通过串行线提供 login 提示。要配置此项，编辑 /etc/ttys 中串行 port 的条目，使用终端配置中的说明。如果串行 port 的速度已更改，请更改 std.115200 以匹配新设置。|
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |

### 29.6.3. 设置更快的串行Port速度

默认情况下，串行port设置为 115200 波特率，8 位，无奇偶校验和 1 个停止位。要更改默认控制台速度，请使用以下选项之一：

* 编辑 /etc/make.conf 并将 BOOT_COMCONSOLE_SPEED 设置为新的控制台速度。然后，重新编译并安装引导块和引导加载程序：

  ```
  # cd /sys/boot
  # make clean
  # make
  # make install
  ```

  如果串行控制台通过 -h 以外的方式配置，或者内核使用的串行控制台与引导块使用的串行控制台不同，请将以下选项添加到自定义内核配置文件中，并编译新内核，速度设置为所需速度：

  ```
  options CONSPEED=19200
  ```
* 在/boot.config 中添加 -S<em>19200</em> 引导选项，将 <em>19200</em> 替换为要使用的速度。
* 在/boot/loader.conf 中添加以下选项。将 <em>115200</em> 替换为要使用的速度。

  ```
  boot_multicons="YES"
  boot_serial="YES"
  comconsole_speed="115200"
  console="comconsole,vidconsole"
  ```

### 29.6.4. 从串行线进入 DDB 调试器

要配置从串行控制台切换到内核调试器的能力，请将以下选项添加到自定义内核配置文件中，并使用《配置 FreeBSD 内核》中的说明编译内核。请注意，尽管这对远程诊断很有用，但如果在串行 port 上生成错误的 BREAK，则会很危险。有关内核调试器的更多信息，请参阅 ddb(4) 和 ddb(8)。

```
options BREAK_TO_DEBUGGER
options DDB
```
