# 3.12.手册页

FreeBSD 上最全面的文档形式是手册页。几乎系统上的每个程序都有一份简短的参考手册，解释基本操作和可用参数。这些手册可以通过 `man` 命令查看：

```
% man command
```

其中 *command* 是要了解的命令名称。例如，要了解更多关于 [ls(1)](https://man.freebsd.org/cgi/man.cgi?query=ls&sektion=1&format=html) 的信息，可以输入：

```
% man ls
```

手册页分为不同的章节，每个章节代表不同的主题类型。在 FreeBSD 中，以下是可用的章节：

1. 用户命令。
2. 系统调用和错误号码。
3. C 库中的函数。
4. 设备驱动程序。
5. 文件格式。
6. 游戏和其他娱乐。
7. 杂项信息。
8. 系统维护和操作命令。
9. 系统内核接口。

在某些情况下，同一主题可能出现在多个章节中。例如，`chmod` 用户命令和 `chmod()` 系统调用都存在。要告诉 [man(1)](https://man.freebsd.org/cgi/man.cgi?query=man&sektion=1&format=html) 显示哪个章节，可以指定章节编号：

```
% man 1 chmod
```

这将显示用户命令 [chmod(1)](https://man.freebsd.org/cgi/man.cgi?query=chmod&sektion=1&format=html) 的手册页。手册页的各章节通常在书面文档中用括号标出，因此 [chmod(1)](https://man.freebsd.org/cgi/man.cgi?query=chmod&sektion=1&format=html) 指的是用户命令，而 [chmod(2)](https://man.freebsd.org/cgi/man.cgi?query=chmod&sektion=2&format=html) 指的是系统调用。

如果不知道手册页的名称，可以使用 `man -k` 命令搜索手册页描述中的关键词：

```
% man -k mail
```

此命令将显示描述中包含“mail”关键词的命令列表。这等同于使用 [apropos(1)](https://man.freebsd.org/cgi/man.cgi?query=apropos&sektion=1&format=html)。

要查看 `/usr/sbin` 目录中所有命令的描述，可以输入：

```
% cd /usr/sbin
% man -f * | more
```

或者

```
% cd /usr/sbin
% whatis * | more
```

## 3.12.1. GNU Info 文件

FreeBSD 包含了由自由软件基金会（FSF）制作的几个应用程序和工具。除了手册页，这些程序还可能包括名为 `info` 文件的超文本文档。这些文件可以通过 [info(1)](https://man.freebsd.org/cgi/man.cgi?query=info&sektion=1&format=html) 或者在安装了 [editors/emacs](https://cgit.freebsd.org/ports/tree/editors/emacs/) 的情况下，通过 emacs 的 info 模式查看。

使用 [info(1)](https://man.freebsd.org/cgi/man.cgi?query=info&sektion=1&format=html) 时，输入：

```
% info
```

要查看简短的介绍，输入 `h`。要快速查看命令参考，输入 `?`。
