# 3.2.虚拟控制台和终端

如果没有配置 FreeBSD 在启动时自动进入图形环境，那么系统将启动到命令行登录提示界面，如下所示：

```
FreeBSD/amd64 (pc3.example.org) (ttyv0)

login:
```

第一行包含了一些系统信息。`amd64` 表示 FreeBSD 正运行在 64 位 x86 设备上。主机名是 `pc3.example.org`，而 `ttyv0` 表示这是“系统控制台”。第二行是登录提示符。

由于 FreeBSD 是款多用户系统，因此它需要一种方法来区分不同的用户。这是通过要求每个用户在访问系统上的程序之前先行登录来实现的。每位用户都有一个唯一的“用户名”及其对应的个人“密码”。

要登录系统控制台，请输入安装系统时配置的用户名（详见 [添加用户](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-addusers)）并按下 <kbd>Enter</kbd> 键。然后输入与该用户名关联的密码并再次按下 <kbd>Enter</kbd>。出于安全原因，输入的密码*不会回显*。

若输入了正确的密码，将会显示“今日信息”（MOTD），随后出现命令提示符。根据用户创建时选择的 shell，此提示符可能是 `#`、`$` 或 `%` 字符。这个提示符表明用户已登录到 FreeBSD 系统控制台，并可开始尝试使用可用命令。

## 3.2.1. 虚拟控制台

虽然可以用系统控制台来与系统交互，但在 FreeBSD 系统的键盘上进行命令行操作的用户通常会登录到虚拟控制台。这是因为系统消息默认会输出到系统控制台上。这些信息会覆盖用户正在处理的命令和文件，从而妨碍工作。

FreeBSD 默认配置了多个虚拟控制台供用户输入命令。每个虚拟控制台都有自己的登录提示和 shell，用户可以方便地在它们之间切换。这实质上提供了图形环境中多窗口操作的命令行等价体验。

FreeBSD 保留了快捷键 <kbd>Alt</kbd>+<kbd>F1</kbd> 到 <kbd>Alt</kbd>+<kbd>F8</kbd> 用于切换虚拟控制台。使用 <kbd>Alt</kbd>+<kbd>F1</kbd> 可切换到系统控制台（`ttyv0`），<kbd>Alt</kbd>+<kbd>F2</kbd> 可访问第一个虚拟控制台（`ttyv1`），<kbd>Alt</kbd>+<kbd>F3</kbd> 可访问第二个虚拟控制台（`ttyv2`），依此类推。当使用 Xorg 作为图形控制台时，快捷键变为 <kbd>Ctrl</kbd>+<kbd>Alt</kbd>+<kbd>F1</kbd> 返回文本模式虚拟控制台。

在控制台之间切换时，FreeBSD 会管理屏幕输出。这样产生了一种拥有多个虚拟屏幕和键盘的错觉，每个都可以用于输入 FreeBSD 要执行的命令。在一个虚拟控制台中启动的程序在切换到其他控制台时 *不会* 停止运行。

更详细的 FreeBSD 控制台与键盘驱动说明，可参考 [kbdcontrol(1)](https://man.freebsd.org/cgi/man.cgi?query=kbdcontrol&sektion=1&format=html)、[vidcontrol(1)](https://man.freebsd.org/cgi/man.cgi?query=vidcontrol&sektion=1&format=html)、[atkbd(4)](https://man.freebsd.org/cgi/man.cgi?query=atkbd&sektion=4&format=html)、[syscons(4)](https://man.freebsd.org/cgi/man.cgi?query=syscons&sektion=4&format=html) 和 [vt(4)](https://man.freebsd.org/cgi/man.cgi?query=vt&sektion=4&format=html)。

在 FreeBSD 中，可用虚拟控制台的数量配置在 `/etc/ttys` 文件的以下部分：

```
# name    getty                         type  status comments
#
ttyv0   "/usr/libexec/getty Pc"         xterm   on  secure
# Virtual terminals
ttyv1   "/usr/libexec/getty Pc"         xterm   on  secure
ttyv2   "/usr/libexec/getty Pc"         xterm   on  secure
ttyv3   "/usr/libexec/getty Pc"         xterm   on  secure
ttyv4   "/usr/libexec/getty Pc"         xterm   on  secure
ttyv5   "/usr/libexec/getty Pc"         xterm   on  secure
ttyv6   "/usr/libexec/getty Pc"         xterm   on  secure
ttyv7   "/usr/libexec/getty Pc"         xterm   on  secure
ttyv8   "/usr/X11R6/bin/xdm -nodaemon"  xterm   off secure
```

要禁用某个虚拟控制台，在对应那一行的开头加上注释符号（`#`）。例如，要将虚拟控制台数量从八个减少到四个，可以在 `ttyv5` 到 `ttyv8` 这四行前添加 `#`。*不要*注释掉系统控制台 `ttyv0` 的那一行。注意最后一个虚拟控制台（`ttyv8`）用于在已安装并配置 Xorg 时访问图形环境，详见 [X 窗口系统](https://docs.freebsd.org/en/books/handbook/x11/#x11)。

关于该文件中每一列的详细说明以及虚拟控制台的可用选项，参见 [ttys(5)](https://man.freebsd.org/cgi/man.cgi?query=ttys&sektion=5&format=html)。

## 3.2.2. 单用户模式

FreeBSD 启动菜单提供了选项 “Boot Single User” 。如果选择此项，系统将启动到一种特殊模式，称为“单用户模式”。该模式通常用于修复无法启动的系统，或者在不知道 `root` 密码时重置该密码。在单用户模式下，网络功能和其他虚拟控制台不可用。但可以获得系统的完整 `root` 权限，并且默认不需要输入 `root` 密码。出于这些原因，启动到该模式需要对键盘有物理访问权限，因此在保护 FreeBSD 系统时，应考虑谁可以访问键盘这一问题。

控制单用户模式的设置位于 `/etc/ttys` 文件的以下部分：

```
# name  getty                           type  status  comments
#
# 如果控制台标记为“insecure”，则在进入单用户模式时，init 会要求输入 root 密码。
console none                            unknown  off  secure
```

在默认情况下，状态设为 `secure`。这意味着默认假设对键盘的物理访问要么不重要，要么由实体安全策略加以控制。如果将该设置改为 `insecure`，则说明当前环境是不安全的，因为任何人都可以访问键盘。当将这一行改为 `insecure` 时，FreeBSD 会在用户选择启动单用户模式时提示输入 `root` 密码。

>**注意**
>
>**更改此设置为 `insecure` 时请小心！** 如果忘记了 `root` 密码，虽然仍可启动到单用户模式，但对不熟悉 FreeBSD 启动流程的人来说可能会很困难。 

## 3.2.3. 更改控制台显示模式

FreeBSD 控制台的默认显示模式可以调整为 1024x768、1280x1024 或任何显卡和显示器支持的分辨率。要使用不同的显示模式，需加载 `VESA` 模块：

```
# kldload vesa
```

要查看硬件支持哪些显示模式，请使用 [vidcontrol(1)](https://man.freebsd.org/cgi/man.cgi?query=vidcontrol&sektion=1&format=html)。运行以下命令可获取支持的显示模式列表：

```
# vidcontrol -i mode
```

此命令的输出列出了硬件支持的显示模式。要选择新的显示模式，使用 `root` 用户身份通过 [vidcontrol(1)](https://man.freebsd.org/cgi/man.cgi?query=vidcontrol&sektion=1&format=html) 指定模式：

```
# vidcontrol MODE_279
```

如果新的显示模式符合要求，可以通过在 `/etc/rc.conf` 中添加以下行，使其在启动时自动生效：

```
allscreens_flags="MODE_279"
```
