# 3.5.目录结构

FreeBSD 的目录层级结构是理解整个系统的基础。根目录（“/”）是最重要的目录，它在启动时最先挂载，包含了操作系统的基础部分，为多用户操作做准备。根目录还包含了其他文件系统的挂载点，这些文件系统在进入多用户模式时被挂载。

挂载点是将额外文件系统附加到父文件系统（通常是根文件系统）上的目录。常见的挂载点包括 `/usr/`、`/var/`、`/tmp/`、`/mnt/` 和 `/cdrom/`。这些目录在 `/etc/fstab` 文件中有条目。大多数文件系统会在启动时通过 [rc(8)](https://man.freebsd.org/cgi/man.cgi?query=rc&sektion=8&format=html) 脚本自动挂载，除非它们的条目包含 `noauto`。

文件系统层级的完整说明见 [hier(7)](https://man.freebsd.org/cgi/man.cgi?query=hier&sektion=7&format=html)。以下是常见目录的简要概述：

| 目录 | 描述 |
| ---- | ---- |
| `/` | 文件系统的根目录。 |
| `/bin/` | 单用户和多用户环境中必需的用户工具。 |
| `/boot/` | 操作系统引导过程中使用的程序和配置文件。 |
| `/dev/` | 由 [devfs(5)](https://man.freebsd.org/cgi/man.cgi?query=devfs&sektion=5&format=html) 管理的设备特殊文件。 |
| `/etc/` | 系统配置文件与脚本。 |
| `/lib/` | `/bin` 和 `/sbin` 中二进制文件所需的关键系统库。 |
| `/libexec/` | 关键系统文件。 |
| `/media/` | 可移动媒体（如 CD、USB 驱动器等）的挂载点子目录。 |
| `/mnt/` | 系统管理员常用作临时挂载点的空目录。 |
| `/proc/` | 进程文件系统。详见 [procfs(5)](https://man.freebsd.org/cgi/man.cgi?query=procfs&sektion=5&format=html)。 |
| `/root/` | `root` 账户的主目录。 |
| `/sbin/` | 在单用户和多用户环境中必需的系统程序和管理工具。 |
| `/tmp/` | 临时文件，通常在系统重启后不会保留。 |
| `/usr/` | 大多数用户工具和应用程序所在之处。 |
| `/usr/bin/` | 常用工具、编程工具和应用程序。 |
| `/usr/local/` | 本地可执行文件与库，也是 FreeBSD ports 框架的默认安装位置。 |
| `/var/` | 用于日志、临时、中转与任务排队的多用途文件目录。 |
| `/var/log/` | 系统日志文件。 |
