# 3.7.文件系统的挂载与卸载

文件系统最好被想象成一棵树，其“根”位于 `/`。`/dev`、`/usr` 和根目录下的其他目录是这棵树的分支，它们又可能有自己的分支，比如 `/usr/local`，以此类推。

出于多种原因，可以将这些目录中的某些放在独立的文件系统上。`/var` 包含 `log/`、`spool/` 目录以及各种临时文件，因此可能会被写满。写满根文件系统并不是好事，因此通常建议将 `/var` 与 `/` 分离。

另一个常见的原因是某些目录树可能存放在独立的物理磁盘上，或独立的虚拟磁盘上，例如网络文件系统挂载（见 [“Network File System (NFS)”](https://docs.freebsd.org/en/books/handbook/network-servers/#network-nfs)），或 CDROM 驱动器。

## 3.7.1. fstab 文件

在启动过程中（见 [FreeBSD 启动过程](https://docs.freebsd.org/en/books/handbook/boot/#boot)），`/etc/fstab` 中列出的文件系统会被自动挂载，除非条目中包含 `noauto`。该文件中的条目格式如下：

```
device       /mount-point fstype     options      dumpfreq     passno
```

- `device`：现有设备名，详见 [磁盘设备命名](https://docs.freebsd.org/en/books/handbook/basics/#disks-naming)。
- `mount-point`：现有的目录，用于挂载文件系统。
- `fstype`：传递给 [mount(8)](https://man.freebsd.org/cgi/man.cgi?query=mount&sektion=8&format=html) 的文件系统类型。FreeBSD 默认的文件系统类型是 `ufs`。
- `options`：`rw` 表示读写文件系统，`ro` 表示只读文件系统，可跟其他选项。常用选项包括 `noauto`，表示启动时不挂载此文件系统。更多选项见 [mount(8)](https://man.freebsd.org/cgi/man.cgi?query=mount&sektion=8&format=html)。
- `dumpfreq`：供 [dump(8)](https://man.freebsd.org/cgi/man.cgi?query=dump&sektion=8&format=html) 判断哪些文件系统需要备份。缺省时视为 0。
- `passno`：决定在重启后，哪些 UFS 文件系统应由 [fsck(8)](https://man.freebsd.org/cgi/man.cgi?query=fsck&sektion=8&format=html) 检查，以及检查顺序。应跳过的文件系统设置为 0。根文件系统应优先检查，设为 1，其他文件系统设为大于 1 的值。若多个文件系统具有相同的 `passno`，[fsck(8)](https://man.freebsd.org/cgi/man.cgi?query=fsck&sektion=8&format=html) 会尝试并行检查。

更多格式和选项说明，见 [fstab(5)](https://man.freebsd.org/cgi/man.cgi?query=fstab&sektion=5&format=html)。

## 3.7.2. 使用 [mount(8)](https://man.freebsd.org/cgi/man.cgi?query=mount&sektion=8&format=html)

文件系统通过 [mount(8)](https://man.freebsd.org/cgi/man.cgi?query=mount&sektion=8&format=html) 命令挂载。最基本的语法如下：

```
# mount device mountpoint
```

如果文件系统已列在 `/etc/fstab` 中，也可以只提供挂载点进行挂载。

该命令有许多选项，详见 [mount(8)](https://man.freebsd.org/cgi/man.cgi?query=mount&sektion=8&format=html)。常用选项包括：

**挂载选项**

- `-a`：挂载 `/etc/fstab` 中所有文件系统，除 `noauto` 标记、被 `-t` 排除或已挂载的。
- `-d`：执行除实际挂载系统调用外的所有操作。常与 `-v` 配合使用，用于调试 [mount(8)] 实际尝试的操作。
- `-f`：强制挂载未清理的文件系统（危险），或在将文件系统从读写状态降级为只读时撤销写权限。
- `-r`：以只读方式挂载，等效于 `-o ro`。
- `-t fstype`：指定要挂载的文件系统类型，或在使用 `-a` 时仅挂载该类型文件系统。默认类型是 "ufs"。
- `-u`：更新文件系统的挂载选项。
- `-v`：显示详细信息。
- `-w`：以读写方式挂载文件系统。

以下选项可作为 `-o` 的逗号分隔列表传入：

- `nosuid`：不解释文件系统上的 setuid 或 setgid 标志，此选项常用于增强安全性。

## 3.7.3. 使用 [umount(8)](https://man.freebsd.org/cgi/man.cgi?query=umount&sektion=8&format=html)

卸载文件系统使用 [umount(8)](https://man.freebsd.org/cgi/man.cgi?query=umount&sektion=8&format=html)。该命令接受一个参数，可以是挂载点、设备名，或 `-a`、`-A`。

所有形式均可接受 `-f` 强制卸载，以及 `-v` 显示详细信息。注意，`-f` 通常并不安全，可能导致系统崩溃或文件系统数据损坏。

要卸载所有已挂载的文件系统，或仅卸载 `-t` 后指定类型的文件系统，可使用 `-a` 或 `-A`。注意 `-A` 不会尝试卸载根文件系统。
