# 30.2.配置 PPP

FreeBSD 提供了内置支持，用于使用 ppp(8)管理拨号 PPP 连接。默认的 FreeBSD 内核提供了用于与调制解调器硬件交互的 tun 支持。配置是通过编辑至少一个配置文件来完成的，并提供了包含示例的配置文件。最后，ppp 用于启动和管理连接。

为了使用 PPP 连接，需要以下项目：

* 与互联网服务提供商（ISP）拥有拨号账户。
* 拨号调制解调器。
* 互联网服务提供商的拨号号码。
* 由互联网服务提供商分配的登录名和密码。
* 一个或多个 DNS 服务器的 IP 地址。通常，互联网服务提供商提供这些地址。如果没有提供，FreeBSD 可以配置为使用 DNS 协商。

如果缺少任何必需的信息，请联系 ISP。

ISP 可以提供以下信息，但不是必要的：

* 默认网关的 IP 地址。如果此信息未知，则 ISP 将在连接设置期间自动提供正确的值。在 FreeBSD 上配置 PPP 时，此地址被称为 HISADDR。
* 子网掩码。如果 ISP 没有提供子网掩码，在 ppp(8)配置文件中将使用 255.255.255.255。* 如果 ISP 分配了静态 IP 地址和主机名，则应将其输入到配置文件中。否则，在连接设置期间将自动提供此信息。

本节的其余部分演示了如何为常见的 PPP 连接场景配置 FreeBSD。所需的配置文件是/etc/ppp/ppp.conf，其他文件和示例可在/usr/share/examples/ppp/中找到。

|  | 在本节中，许多文件示例显示行号。这些行号是为了更容易跟踪讨论而添加的，并不是要放在实际文件中。<br /><br />编辑配置文件时，正确的缩进非常重要。以 : 结尾的行应从第一列（行的开头）开始，而所有其他行都应按照显示的方式使用空格或制表符进行缩进。|
| -- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

### 30.2.1. 基本配置

要配置 PPP 连接，首先要编辑/etc/ppp/ppp.conf，输入 ISP 的拨号信息。该文件的说明如下：

```
1     default:
2       set log Phase Chat LCP IPCP CCP tun command
3       ident user-ppp VERSION
4       set device /dev/cuau0
5       set speed 115200
6       set dial "ABORT BUSY ABORT NO\\sCARRIER TIMEOUT 5 \
7                 \"\" AT OK-AT-OK ATE1Q0 OK \\dATDT\\T TIMEOUT 40 CONNECT"
8       set timeout 180
9       enable dns
10
11    provider:
12      set phone "(123) 456 7890"
13      set authname foo
14      set authkey bar
15      set timeout 300
16      set ifaddr x.x.x.x/0 y.y.y.y/0 255.255.255.255 0.0.0.0
17      add default HISADDR
```

 行 1

标识 default 条目。当运行 ppp 时，此条目中的命令（第 2 行至第 9 行）会被自动执行。

 行 2

为测试连接启用详细记录参数。若配置正常工作，应将此行减少到：

```
set log phase tun
```

 行 3

显示运行在连接另一侧的 PPP 软件的版本。

 第 4 行

识别调制解调器连接的设备，其中 COM1 是/dev/cuau0，COM2 是/dev/cuau1。

 第 5 行

设置连接速度。如果 115200 在旧调制解调器上无法使用，请尝试使用 38400。

第 6 和第 7 行

作为期望-发送语法编写的拨号字符串。有关更多信息，请参考 chat(8)。

请注意，如果行尾是 \，此命令会延续到下一行以提高可读性。ppp.conf 中的任何命令都可能会这样做。

 第 8 行

设置链接的空闲超时时间（以秒为单位）。

 第 9 行

指示对等方确认 DNS 设置。如果本地网络正在运行自己的 DNS 服务器，则应该将此行注释掉，即在行的开头添加一个 #，或将其删除。

 第 10 行

用于提高可读性的空白行。ppp(8)会忽略空白行。

 第 11 行

标识名为 provider 的条目。这可以更改为 ISP 的名称，以便可以使用 load<span> </span><em>ISP</em> 启动连接。

 第 12 行

使用 ISP 的电话号码。可以使用冒号（ : ）或竖线字符（ | ）作为分隔符指定多个电话号码。要循环拨打这些号码，使用冒号。要始终首先尝试拨打第一个号码，只有在第一个号码失败时才使用其他号码，请使用竖线字符。始终在引号之间括起整组电话号码（ " ）以防止拨号失败。

第 13＆14 行

使用 ISP 的用户名和密码。

 第 15 行

设置连接的默认空闲超时时间（以秒为单位）。在此示例中，连接将在 300 秒的不活动后自动关闭。要防止超时，请将此值设置为零。

Line 16

Sets the interface addresses. The values used depend upon whether a static IP address has been obtained from the ISP or if it instead negotiates a dynamic IP address during connection.

If the ISP has allocated a static IP address and default gateway, replace *x.x.x.x* with the static IP address and replace *y.y.y.y* with the IP address of the default gateway. If the ISP has only provided a static IP address without a gateway address, replace *y.y.y.y* with `10.0.0.2/0`.

如果每次连接时 IP 地址都会更改，请将此行更改为以下值。这告诉 ppp(8) 使用 IP 配置协议（IPCP）来协商动态 IP 地址：

```
set ifaddr 10.0.0.1/0 10.0.0.2/0 255.255.255.255 0.0.0.0
```

 第 17 行

将此行保持不变，因为它将默认路由添加到网关。HISADDR 将自动替换为第 16 行指定的网关地址。重要的是这行出现在第 16 行之后。

根据 ppp(8) 是手动启动还是自动启动，可能需要创建 /etc/ppp/ppp.linkup 文件，其中包含以下内容。当以 -auto 模式运行 ppp 时需要此文件。该文件在连接建立后使用。在这一点上，IP 地址将被分配，并且现在可以添加路由表条目。创建此文件时，请确保提供程序与 ppp.conf 的第 11 行中展示的值匹配。

```
provider:
      add default HISADDR
```

在静态 IP 地址配置中，“猜测”默认网关地址时，还需要此文件。在这种情况下，从 ppp.conf 中删除第 17 行，并使用上述两行创建 /etc/ppp/ppp.linkup。有关此文件的更多示例，请参见 /usr/share/examples/ppp/。

默认情况下，ppp 必须作为 root 运行。要更改此默认设置，请将应运行 ppp 的用户账户添加到 /etc/group 中的 network 组。

然后，使用 allow 给用户访问 /etc/ppp/ppp.conf 中一个或多个条目的权限。例如，要将 fred 和 mary 的权限限制为仅限于 provider: 条目，将以下行添加到 provider: 部分：

```
allow users fred mary
```

要将指定的用户访问权限扩展到所有条目，请将该行放在 default 部分。

### 30.2.2. 高级配置

配置 PPP 以按需提供 DNS 和 NetBIOS 名称服务器地址是可能的。

要启用 PPP 版本 1.x 的这些扩展，可能需要将以下行添加到/etc/ppp/ppp.conf 的相关部分。

```
enable msext
set ns 203.14.100.1 203.14.100.2
set nbns 203.14.100.5
```

对于 PPP 版本 2 及更高版本：

```
accept dns
set dns 203.14.100.1 203.14.100.2
set nbns 203.14.100.5
```

这将告诉客户端主要和辅助名称服务器地址，以及 NetBIOS 名称服务器主机。

在 2 版本及以上，如果省略 set dns 行，则 PPP 将使用在/etc/resolv.conf 中找到的数值。

#### 30.2.2.1。PAP 和 CHAP 认证

一些 ISP 设置其系统，使连接的认证部分使用 PAP 或 CHAP 认证机制之一完成。如果是这种情况，ISP 在连接时不会给出 login: 提示，而是立即开始进行 PPP 通信。

PAP 比 CHAP 不够安全，但在这里通常安全性不是问题，因为尽管使用 PAP 发送密码是明文的，但密码只是通过串行线传输。黑客很难“窃听”。

必须进行以下修改：

```
13      set authname MyUserName
14      set authkey MyPassword
15      set login
```

 第 13 行

此行指定了 PAP/CHAP 用户名。请插入正确的 MyUserName 值。

 第 14 行

这一行指定了 PAP/CHAP 密码。插入 MyPassword 的正确值。你可能希望添加另一行，比如：

```
16      accept PAP
```

 或者

```
16      accept CHAP
```

以便明确表明这是意图，但 PAP 和 CHAP 默认都被接受。

 第 15 行

当使用 PAP 或 CHAP 时，ISP 通常不需要登录到服务器。因此，请禁用“设置登录”字符串。

#### 30.2.2.2. 使用 PPP 网络地址转换能力

PPP 具有在没有内核转发功能的情况下使用内部 NAT 的能力。可以通过在/etc/ppp/ppp.conf 中添加以下行来启用此功能：

```
nat enable yes
```

或者，可以通过命令行选项 -nat 来启用 NAT。还有一个名为 ppp_nat 的/etc/rc.conf 开关，默认情况下已启用。

使用此功能时，可能需要包含以下/etc/ppp/ppp.conf 选项以启用传入连接转发：

```
nat port tcp 10.0.0.2:ftp ftp
nat port tcp 10.0.0.2:http http
```

要么根本不信任外面

```
nat deny_incoming yes
```

### 30.2.3. 最终系统配置

虽然 ppp 现在已经配置好了，但仍然需要对 /etc/rc.conf 进行一些编辑。

从文件顶部开始工作，确保设置 hostname= 行：

```
hostname="foo.example.com"
```

如果 ISP 提供了静态 IP 地址和名称，请使用此名称作为主机名。

查找 network_interfaces 变量。要配置系统在需要时拨号 ISP，请确保将 tun0 设备添加到列表中，否则将其移除。

```
network_interfaces="lo0 tun0"
ifconfig_tun0=
```

```
ppp -auto mysystem
```

此脚本在网络配置时间执行，以自动模式启动 ppp 守护程序。如果此计算机充当网关，请考虑包含 -alias。有关详细信息，请参阅手册页。

请确保路由器程序设置为 NO，在 /etc/rc.conf 中包含以下行：

```
router_enable="NO"
```

重要的是不启动 routed 守护程序，因为 routed 倾向于删除由 ppp 创建的默认路由表条目。

可能是一个好主意确保 sendmail_flags 行不包括 -q 选项，否则 sendmail 会不时尝试进行网络查找，可能会导致你的机器拨号。你可以尝试：

```
sendmail_flags="-bd"
```

不利之处是 sendmail 被迫在每次 ppp 链接时重新检查邮件队列。要自动化此过程，请在 ppp.linkup 中包括 !bg ：

```
1     provider:
2       delete ALL
3       add 0 0 HISADDR
4       !bg sendmail -bd -q30m
```

另一种选择是设置一个“dfilter”来阻止 SMTP 交通。有关更多详细信息，请参考示例文件。

### 使用 ppp。

唯一剩下的就是重启机器。重启后，要么输入：

```
# ppp
```

然后 dial provider 来启动 PPP 会话，或者，要配置 ppp 来在出站流量时自动建立会话并在 start_if.tun0 不存在时开始，输入：

```
# ppp -auto provider
```

当 ppp 程序在后台运行时，可以进行交互，但前提是必须设置适当的诊断 port。要做到这一点，请将以下行添加到配置中：

```
set server /var/run/ppp-tun%d DiagnosticPassword 0177
```

这将告诉 PPP 监听指定的 UNIX® 域套接字，在允许访问之前要求客户端输入指定的密码。名称中的 %d 将被当前使用的 tun 设备号替换。

若套接字设置完成，pppctl(8) 程序可用于希望操作正在运行的程序的脚本。

### 配置拨号服务

“拨号服务”提供了使用 getty(8)启用拨号服务的良好说明。

一个替代方案是 comms/mgetty+sendfax port)，一种专为拨号线路而设计的更智能版本。

使用 mgetty 的优点是它可以与调制解调器进行积极通信，这意味着如果在 /etc/ttys 中关闭port，调制解调器将不会接听电话。

较新版本的 mgetty （从 0.99beta 开始）还支持自动检测 PPP 流，允许客户端无需脚本即可访问服务器。

更多关于 mgetty 的信息，请参考 http://mgetty.greenie.net/doc/mgetty_toc.html。

默认情况下，comms/mgetty+sendfax port 自带 AUTO_PPP 选项，允许 mgetty 检测 PPP 连接的 LCP 阶段，并自动产生一个 ppp shell。然而，由于默认的登录/密码序列不出现，因此需要使用 PAP 或 CHAP 对用户进行认证。

本节假定用户已成功编译并安装了 comms/mgetty+sendfax port 到他的系统。

确保/usr/local/etc/mgetty+sendfax/login.config 具有以下内容：

```
/AutoPPP/ -     - /etc/ppp/ppp-pap-dialup
```

这告诉 mgetty 运行 ppp-pap-dialup 以侦测 PPP 连接。

创建一个名为/etc/ppp/ppp-pap-dialup 的可执行文件，其内容如下：

```
#!/bin/sh
exec /usr/sbin/ppp -direct pap$IDENT
```

对于在/etc/ttys 中启用的每个拨号线路，在/etc/ppp/ppp.conf 中创建一个相应的条目。这将与我们上面创建的定义愉快地共存。

```
pap:
  enable pap
  set ifaddr 203.14.100.1 203.14.100.20-203.14.100.40
  enable proxy
```

使用此方法登录的每个用户都需要在/etc/ppp/ppp.secret 中拥有用户名/密码，或者可以添加以下选项来通过/etc/passwd 从 PAP 进行用户身份验证。

```
enable passwdauth
```

要为某些用户分配静态 IP 号码，请在/etc/ppp/ppp.secret 的第三个参数中指定该号码。参见/usr/share/examples/ppp/ppp.secret.sample 获取示例。
