# 30.3.PPP 连接的故障排除

这一部分涉及在使用调制解调器连接上的 PPP 时可能出现的一些问题。一些 ISP 会显示 ssword 提示，而另一些会显示 password。如果 ppp 脚本编写不正确，登录尝试将会失败。调试 ppp 连接的最常见方法是按照本节中说明的方式手动连接。

### 30.3.1. 检查设备节点

当使用定制内核时，请确保在内核配置文件中包含以下行：

```
device   uart
```

uart 设备已经包含在定制内核中，因此在这种情况下不需要额外步骤。只需检查模块设备的 dmesg 输出：

```
# dmesg | grep uart
```

这应该显示关于 uart 设备的一些相关输出。这些是我们需要的 COM ports。如果调制解调器表现得像标准串行port，它应该在 uart1 或 COM2 上列出。如果是这样，不需要重新构建内核。当匹配时，如果调制解调器在 uart1 上，调制解调器设备将是/dev/cuau1。

### 30.3.2. 手动连接

通过手动控制 ppp 连接到互联网是快速、简单的，也是调试连接或获取有关 ISP 如何处理 ppp 客户端连接的信息的好方法。让我们从命令行启动 PPP。请注意，在我们的所有示例中，我们将使用 example 作为运行 PPP 的机器的主机名。要启动 ppp ：

```
# ppp
```

```
ppp ON example> set device /dev/cuau1
```

这第二个命令将调制解调器设备设置为 cuau1。

```
ppp ON example> set speed 115200
```

这将连接速度设置为 115,200 kbps。

```
ppp ON example> enable dns
```

这告诉 ppp 配置解析器并将 nameserver 行添加到 /etc/resolv.conf。如果 ppp 无法确定主机名，稍后可以手动设置。

```
ppp ON example> term
```

这将切换到“终端”模式，以手动控制调制解调器。

```
deflink: Entering terminal mode on /dev/cuau1
type '~h' for help
```

```
at
OK
atdt123456789
```

使用 at 初始化调制解调器，然后使用 atdt 和 ISP 号码开始拨号过程。

```
CONNECT
```

确认连接，如果出现任何与硬件无关的连接问题，我们将在这里尝试解决。

```
ISP Login:myusername
```

在此提示下，返回由 ISP 提供的用户名。

```
ISP Pass:mypassword
```

在此提示下，回复 ISP 提供的密码。就像登录 FreeBSD 一样，密码不会回显。

```
Shell or PPP:ppp
```

根据 ISP 的不同，这个提示可能不会出现。如果出现，它是在询问是否在提供程序上使用shell，或者开始 ppp。在这个例子中，选择 ppp 以建立互联网连接。

```
Ppp ON example>
```

注意，在这个例子中，第一个 p 已被大写。这表明我们已成功连接到 ISP。

```
Ppp ON example>
```

我们已成功通过 ISP 进行身份验证，正在等待分配的 IP 地址。

```
PPP ON example>
```

我们已就 IP 地址达成协议，并成功完成了连接。

```
PPP ON example>add default HISADDR
```

这里我们添加默认路由，我们需要在与外部世界通信之前这样做，因为目前唯一建立的连接是与对等体之间的。如果由于现有路由而失败，请在 add 前面放一个感叹号 !。或者，在建立实际连接之前设置这一点，它将相应地协商新路由。

如果一切顺利，我们现在应该已经与互联网建立了活动连接，可以使用 CTRL+z 将其放入后台。如果 PPP 返回到 ppp，那么连接已经丢失。这很重要，因为它显示了连接状态。大写的 P 代表与 ISP 的连接，小写的 p 表示连接已丢失。

### 30.3.3. 调试

如果无法建立连接，请使用 set ctsrts off 将硬件流的 CTS/RTS 关闭。这主要是在连接到一些支持 PPP 的终端服务器时才会出现的情况，在尝试向通信链路写入数据时，PPP 会挂起，等待一个可能永远不会到来的清除发送信号(CTS)。在使用此选项时，包括 set accmap，因为可能需要将硬件设置为通过传递某些字符从一端到另一端，大部分时间为 XON/XOFF。有关此选项及其用法的更多信息，请参阅 ppp(8)。

旧调制解调器可能需要 set parity even。奇偶校验默认设置为无校验，但在使用较多的流量进行错误检查时会用到，对于旧调制解调器。

PPP 可能无法返回到命令模式，这通常是一种协商错误，因为 ISP 正在等待开始协商。此时，使用 ~p 将强制 ppp 开始发送配置信息。

如果登录提示从未出现，则很可能需要 PAP 或 CHAP 认证。要使用 PAP 或 CHAP，在进入终端模式之前，请在 PPP 中添加以下选项：

```
ppp ON example> set authname myusername
```

其中 myusername 应被分配的用户名替换。

```
ppp ON example> set authkey mypassword
```

其中 mypassword 应被分配的密码替换。

如果建立连接，但似乎找不到任何域名，请尝试 ping(8) IP 地址。如果数据包丢失率达到 100%，很可能没有分配默认路由。在连接期间，请务必检查是否设置了 add default HISADDR。如果可以与远程 IP 地址建立连接，则可能尚未将解析器地址添加到/etc/resolv.conf 中。该文件应如下所示：

```
domain example.com
nameserver x.x.x.x
nameserver y.y.y.y
```

其中 x.x.x.x 和 y.y.y.y 应替换为 ISP DNS 服务器的 IP 地址。

要配置 syslog(3)以为 PPP 连接提供日志记录，请确保/etc/syslog.conf 中存在以下行：

```
!ppp
*.*     /var/log/ppp.log
```
