# 30.4.使用以太网 PPP（PPPoE）

本节说明如何设置以太网上的 PPP（PPPoE）。

这是一个工作的 ppp.conf 示例：

```
default:
  set log Phase tun command # you can add more detailed logging if you wish
  set ifaddr 10.0.0.1/0 10.0.0.2/0

name_of_service_provider:
  set device PPPoE:xl1 # replace xl1 with your Ethernet device
  set authname YOURLOGINNAME
  set authkey YOURPASSWORD
  set dial
  set login
  add default HISADDR
```

 如 root，运行：

```
# ppp -ddial name_of_service_provider
```

将以下内容添加到/etc/rc.conf 中：

```
ppp_enable="YES"
ppp_mode="ddial"
ppp_nat="YES"	# if you want to enable nat for your local network, otherwise NO
ppp_profile="name_of_service_provider"
```

### 使用 PPPoE 服务标记

有时需要使用服务标记来建立连接。服务标记用于区分连接到给定网络的不同 PPPoE 服务器。

ISP 提供的文档中应包含任何所需的服务标记信息。

作为最后的手段，一个人可以尝试安装 net/rr-pppoe 软件包或port。但请记住，这可能会解除你的调制解调器的程序，使其变得无用，所以在这样做之前三思。只需安装调制解调器附带的程序。然后，从该程序访问系统菜单。配置文件的名称应列在那里。通常是 ISP。

该配置文件名称（服务标记）将用作 ppp.conf 中 PPPoE 配置条目的提供者部分 set device。有关详细信息，请参阅 ppp(8)。它应该如下所示：

```
set device PPPoE:xl1:ISP
```

不要忘记为以太网卡更改 xl1 为正确的设备。

不要忘记将 ISP 更改为配置文件。

有关在 DSL 上使用 FreeBSD 获得更便宜宽带的更多信息，请参阅 Renaud Waldura 的《Cheaper Broadband with FreeBSD on DSL》。

### 30.4.2. 使用 3Com® HomeConnect™ ADSL Modem Dual Link 的 PPPoE

该调制解调器不遵循 RFC 2516 中定义的 PPPoE 规范。

为了使 FreeBSD 能够与此设备通信，必须设置一个 sysctl。可以通过更新/etc/sysctl.conf 在启动时自动完成此操作：

```
net.graph.nonstandard_pppoe=1
```

或者可以立即用以下命令完成：

```
# sysctl net.graph.nonstandard_pppoe=1
```

抱歉，由于这是一个系统范围的设置，无法同时与普通的 PPPoE 客户端或服务器以及 3Com® HomeConnect™ ADSL 调制解调器进行通信。
