# 30.5.使用 ATM 上的 PPP (PPPoA)

以下是如何设置在 ATM（PPPoA）上的 PPP。PPPoA 是欧洲 DSL 提供商中的一种流行选择。

### 30.5.1. 使用 mpd

mpd 应用程序可用于连接各种服务，特别是 PPTP 服务。可以使用 net/mpd5 软件包或 port 进行安装。许多 ADSL 调制解调器要求在调制解调器和计算机之间创建一个 PPTP 隧道。

安装完成后，配置 mpd 以适应服务提供商的设置。port 放置了一组示例配置文件，这些文件在 /usr/local/etc/mpd/ 中有很好的文档。有关配置 mpd 的完整指南以 HTML 格式提供在 /usr/ports/shared/doc/mpd/ 中。这是连接到 ADSL 服务的 mpd 的示例配置。配置分为两个文件，首先是 mpd.conf：

|  | 这个示例 mpd.conf 仅适用于 mpd 4.x。|
| -- | -------------------------------------- |

```
default:
    load adsl

adsl:
    new -i ng0 adsl adsl
    set bundle authname username 
    set bundle password password 
    set bundle disable multilink

    set link no pap acfcomp protocomp
    set link disable chap
    set link accept chap
    set link keep-alive 30 10

    set ipcp no vjcomp
    set ipcp ranges 0.0.0.0/0 0.0.0.0/0

    set iface route default
    set iface disable on-demand
    set iface enable proxy-arp
    set iface idle 0

    open
```

|  | 用于验证你的 ISP 的用户名。|
| -- | ----------------------------- |
|  | 用于验证你的 ISP 的密码。|

在 mpd.links 中找到建立链接或链接的信息。伴随上面示例的一个示例 mpd.links 如下所示：

```
adsl:
    set link type pptp
    set pptp mode active
    set pptp enable originate outcall
    set pptp self 10.0.0.1 
    set pptp peer 10.0.0.138 
```

|  | 运行 mpd 的 FreeBSD 计算机的 IP 地址。                      |
| -- | ---------------------------------------------------------------------------- |
|  | ADSL 调制解调器的 IP 地址。Alcatel SpeedTouch™ Home 默认为 10.0.0.138。|

通过发出以下命令，可以轻松初始化连接： root

```
# mpd -b adsl
```

查看连接状态：

```
% ifconfig ng0
ng0: flags=88d1<UP,POINTOPOINT,RUNNING,NOARP,SIMPLEX,MULTICAST> mtu 1500
     inet 216.136.204.117 --> 204.152.186.171 netmask 0xffffffff
```

在 FreeBSD 上，使用 mpd 是连接到 ADSL 服务的推荐方法。

### 使用 pptpclient

也可以使用 FreeBSD 连接到其他 PPPoA 服务使用 net/pptpclient。

要使用 net/pptpclient 连接到 DSL 服务，请安装 port 包，然后编辑 /etc/ppp/ppp.conf。给出 ppp.conf 的示例部分如下。有关 ppp.conf 选项的更多信息，请参阅 ppp(8)。

```
adsl:
 set log phase chat lcp ipcp ccp tun command
 set timeout 0
 enable dns
 set authname username 
 set authkey password 
 set ifaddr 0 0
 add default HISADDR
```

|  | DSL 供应商的用户名。|
| -- | ---------------------- |
|  | 你账户的密码。 |

```
# chown root:wheel /etc/ppp/ppp.conf
# chmod 600 /etc/ppp/ppp.conf
```

这将打开一个到 DSL 路由器的 PPP 会话的隧道。以太网 DSL 调制解调器有一个预配置的 LAN IP 地址可供连接。在 Alcatel SpeedTouch™ Home 的情况下，此地址为 10.0.0.138。路由器的文档应列出设备使用的地址。要打开隧道并启动 PPP 会话：

```
# pptp address adsl
```

|  | 如果在此命令的末尾添加一个和号（"&"），pptp 将返回提示。|
| -- | ---------------------------------------------------------- |

将创建一个 tun 虚拟隧道设备，用于 pptp 和 ppp 进程之间的交互。若返回提示，或者 pptp 进程确认连接后，检查隧道：

```
% ifconfig tun0
tun0: flags=8051<UP,POINTOPOINT,RUNNING,MULTICAST> mtu 1500
        inet 216.136.204.21 --> 204.152.186.171 netmask 0xffffff00
	Opened by PID 918
```

如果连接失败，请检查路由器的配置，通常可使用 Web 浏览器访问。还要检查 pptp 的输出和/var/log/ppp.log 日志文件的内容，查找线索。
