# 31.3.DragonFly 邮件代理（DMA）

DragonFly 邮件代理（DMA）是 FreeBSD 版本 14.0 起的默认 MTA。dma(8) 是一个小型邮件传输代理（MTA），专为家庭和办公使用而设计。它接受来自本地安装的邮件用户代理（MUA）的邮件，并将邮件传递到本地或远程目的地。远程传递包括诸如 TLS/SSL 支持和 SMTP 认证等功能。

dma(8) 不打算作为 sendmail(8) 或 postfix(1) 这样的真正大型 MTA 的替代品。因此，dma(8) 不会监听 port 25 端口进行传入连接。

### 31.3.1. 配置 DragonFly 邮件代理 (DMA)

DMA 自带一个默认配置，适用于许多部署。自定义设置在 /etc/dma/dma.conf 中定义，SMTP 认证在 /etc/dma/auth.conf 中配置。

#### 31.3.1.1. 使用 DMA 将出站邮件通过 Gmail 路由（STARTTLS:SMTP 示例）

此示例 /etc/dma/dma.conf 可用于使用 Google 的 SMTP 服务器发送邮件。

```
SMARTHOST smtp.gmail.com
PORT 587
AUTHPATH /etc/dma/auth.conf
SECURETRANSFER
STARTTLS
MASQUERADE username@gmail.com
```

可以在 /etc/dma/auth.conf 中的一行中设置身份验证：

```
username@gmail.com|smtp.gmail.com:password
```

执行以下命令来测试配置：

```
% echo this is a test | mail -v -s testing-email username@gmail.com
```

#### 31.3.1.2. 使用 DMA 将出站邮件通过 Fastmail 路由（SSL/TLS 示例）

这个示例 /etc/dma/dma.conf 可用于使用 Fastmail 的 SMTP 服务器发送邮件。

```
SMARTHOST smtp.fastmail.com
PORT 465
AUTHPATH /etc/dma/auth.conf
SECURETRANSFER
MAILNAME example.server.com
```

身份验证可以在/etc/dma/auth.conf 文件中用一行代码设置：

```
username@fastmail.com|smtp.fastmail.com:password
```

执行以下命令来测试配置：

```
% echo this is a test | mail -v -s testing-email username@fastmail.com
```

#### 31.3.1.3. 使用 DMA 将出站邮件路由至自定义邮件主机

该示例 /etc/dma/dma.conf 可用于使用自定义邮件主机发送邮件。

```
SMARTHOST mail.example.org
PORT 587
AUTHPATH /etc/dma/auth.conf
SECURETRANSFER
STARTTLS
```

可以在 /etc/dma/auth.conf 中的一行中设置身份验证。

```
username@example.org|mail.example.org:password
```

执行以下命令以测试配置。

```
% echo this is a test | mail -v -s testing-email username@example.org
```
