# 31.4.Sendmail

Sendmail 是一种历史悠久、多才多艺的邮件传输代理（MTA），在 UNIX®和类 UNIX 系统中有着悠久的历史。直到 FreeBSD 13 版本之前，它是 FreeBSD 基本系统的一部分，提供强大的电子邮件传输功能、广泛的定制选项，以及对复杂路由和过滤的支持。

### 31.4.1. 配置文件

Sendmail 的配置文件位于 /etc/mail/ 中。

/etc/mail/access

此访问数据库文件定义了哪些主机或 IP 地址可以访问本地邮件服务器，以及他们具有何种访问权限。列为 OK 的主机（默认选项）可以发送邮件到本主机，只要邮件的最终目的地是本地机器。列为 REJECT 的主机将被拒绝所有邮件连接。列为 RELAY 的主机可以使用此邮件服务器发送任何目的地的邮件。列为 ERROR 的主机将会收到指定的邮件错误返回。如果一个主机列为 SKIP，Sendmail 将中止对此条目的当前搜索，而不接受或拒绝邮件。列为 QUARANTINE 的主机的消息将被保留，并将收到指定文本作为保留原因。

在 FreeBSD 示例配置文件/etc/mail/access.sample 中可以找到使用这些选项的 IPv4 和 IPv6 地址的示例。

要配置访问数据库，请使用示例中显示的格式在/etc/mail/access 中进行条目输入，但不要在条目前面加上注释符号（ # ）。为应配置访问权限的每个主机或网络创建一个条目。与表格左侧匹配的邮件发送者将受到表格右侧操作的影响。

每当更新此文件时，请更新其数据库并重启 Sendmail：

```
# makemap hash /etc/mail/access < /etc/mail/access
# service sendmail restart
```

/etc/mail/aliases

此数据库文件包含一个虚拟邮箱列表，可将其扩展为用户、文件、程序或其他别名。以下是一些条目，以说明该文件格式：

```
root: localuser
ftp-bugs: joe,eric,paul
bit.bucket:  /dev/null
procmail: "|/usr/local/bin/procmail"
```

冒号左侧的邮箱名称会扩展到右侧的目标邮箱。第一个条目将邮箱 root 扩展到邮箱 localuser，然后在/etc/mail/aliases 数据库中查找。如果找不到匹配项，则将消息传递到 localuser。第二个条目显示一个邮件列表。发送到 ftp-bugs 的邮件会扩展到三个本地邮箱 joe，eric 和 paul。远程邮箱可以指定为 user@example.com。第三个条目展示如何将邮件写入文件，本例中为/dev/null。最后一个条目演示如何通过 UNIX®管道将邮件发送到程序/usr/local/bin/procmail。有关此文件格式的更多信息，请参考 aliases(5)。

每当更新此文件时，请运行 newaliases 以更新和初始化别名数据库。

/etc/mail/sendmail.cf

这是 Sendmail 的主配置文件。它控制 Sendmail 的整体行为，包括从重写电子邮件地址到向远程邮件服务器打印拒绝消息的所有内容。因此，这个配置文件相当复杂。幸运的是，对于标准邮件服务器来说，这个文件很少需要更改。

主 Sendmail 配置文件可以从定义 Sendmail 功能和行为的 m4(1) 宏构建。有关详细信息，请参阅 /usr/src/contrib/sendmail/cf/README。

每当对这个文件进行更改时，都需要重启 Sendmail 以使更改生效。

/etc/mail/virtusertable

此数据库文件将虚拟域和用户的邮件地址映射到实际邮箱。这些邮箱可以是本地的、远程的、在/etc/mail/aliases 中定义的别名，或者文件。这能让在一台机器上托管多个虚拟域。

FreeBSD 在/etc/mail/virtusertable.sample 中提供了一个示例配置文件，以进一步演示其格式。以下示例演示了如何使用该格式创建自定义条目：

```
root@example.com                root
postmaster@example.com          postmaster@noc.example.net
@example.com                    joe
```

此文件按照第一个匹配顺序进行处理。当电子邮件地址与左侧的地址匹配时，它将映射到右侧列出的本地邮箱。此示例中第一个条目的格式将特定电子邮件地址映射到本地邮箱，而第二个条目的格式将特定电子邮件地址映射到远程邮箱。最后，来自 example.com 的任何电子邮件地址，如果没有与先前条目匹配，则将匹配到最后一个映射，并发送到本地邮箱 joe。创建定制条目时，请使用此格式并将它们添加到 /etc/mail/virtusertable。每当编辑此文件时，请更新其数据库并重启 Sendmail：

```
# makemap hash /etc/mail/virtusertable < /etc/mail/virtusertable
# service sendmail restart
```

/etc/mail/relay-domains

在默认的 FreeBSD 安装中，Sendmail 配置为仅从其运行的主机发送邮件。例如，如果有一个 POP 服务器可用，用户将能够从远程位置检查邮件，但他们将无法从外部位置发送出站邮件。通常，在尝试几分钟后，将从 MAILER-DAEMON 发送一封带有 5.7 Relaying Denied 消息的电子邮件。

最直接的解决方案是将 ISP 的 FQDN 添加到 /etc/mail/relay-domains。如果需要多个地址，请每行添加一个：

```
your.isp.example.com
other.isp.example.net
users-isp.example.org
www.example.org
```

创建或编辑此文件后，使用 service sendmail restart 重启 Sendmail。

现在，系统中列表中的任何主机通过系统发送的任何邮件，只要用户在系统上有账户，都会成功。这能让用户远程从系统发送邮件，而不会开放系统来中继来自互联网的垃圾邮件。
