# 31.5.修改邮件传输代理

从 FreeBSD 版本 14.0 开始，dma(8)是默认的 MTA，在 14.0 之前，默认的 MTA 是 sendmail(8)。但是，系统管理员可以更改系统的 MTA。在 FreeBSD Ports 的 mail 类别中提供了各种替代 MTA 供选择。

|  | 如果默认的出站邮件服务被禁用，则替代邮件发送系统非常重要。否则，诸如 periodic(8) 等系统功能将无法通过电子邮件传递其结果。系统的许多部分都希望有一个正常运行的邮件传输代理。如果应用程序在禁用后继续使用默认的二进制文件尝试发送电子邮件，那么邮件可能会进入非活动队列并永远不会被传递。|
| -- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

### 31.5.1. 用其他邮件传输代理替换 Sendmail

为了完全禁用 sendmail(8)，执行以下命令：

```
# sysrc sendmail_enable="NO"
# sysrc sendmail_submit_enable="NO"
# sysrc sendmail_outbound_enable="NO"
# sysrc sendmail_msp_queue_enable="NO"
```

只需禁用 sendmail(8)的传入邮件服务执行以下命令：

```
# sysrc sendmail_enable="NO"
```

然后停止 sendmail(8)服务：

```
# service sendmail onestop
```

由于 sendmail(8)如此普遍，一些软件认为它已安装并配置。检查/etc/periodic.conf，并确保这些值设置为 NO。如果该文件不存在，请使用这些条目创建它：

```
daily_clean_hoststat_enable="NO"
daily_status_mail_rejects_enable="NO"
daily_status_include_submit_mailq="NO"
daily_submit_queuerun="NO"
```

下一步是安装另一个 MTA，本示例中将使用 dma(8)。如上所述，dma(8) 是 FreeBSD 从版本 14.0 开始的默认 MTA。因此，如果你使用的是之前的版本，则只需要从 ports 安装它。

要安装它，请执行以下命令：

```
# pkg install dma
```

按照《DragonFly Mail Agent (DMA) 配置》中指示进行配置。

然后将文件/etc/mail/mailer.conf 中的所有条目更改为 dma(8)：

```
# Execute the "real" sendmail program, named /usr/libexec/sendmail/sendmail
#
# If dma(8) is installed, an example mailer.conf that uses dma(8) instead can
# be found in /usr/share/examples/dma
#
sendmail        /usr/local/libexec/dma
mailq           /usr/local/libexec/dma
newaliases      /usr/local/libexec/dma
```

|  | 当使用基本系统中包含的 dma(8)版本时，路径将更改为/usr/libexec/dma。|
| -- | --------------------------------------------------------------------- |

为了确保在启动或关机之前刷新队列中的任何内容，请执行以下命令：

```
# sysrc dma_flushq_enable="YES"
```

若一切配置完成，建议重启系统。重启提供了确保系统正确配置以在启动时自动启动新的 MTA 的机会。

### 31.5.2. 用其他 MTA 替换 DragonFly 邮件代理（DMA）

如上所述，从 FreeBSD 版本 14.0 开始，默认 MTA 是 DMA。在此示例中，将使用 mail/postfix 作为替代 MTA。

安裝郵件/郵遞服務程式 mail/postfix 之前需要進行一些額外配置。檢查 /etc/periodic.conf 並確保這些值設置為 NO。如果此文件不存在，則使用以下內容創建它：

```
daily_clean_hoststat_enable="NO"
daily_status_mail_rejects_enable="NO"
daily_status_include_submit_mailq="NO"
daily_submit_queuerun="NO"
```

然後安裝郵件/郵遞服務程式 mail/postfix：

```
# pkg install postfix
```

若要在系統啟動時啟動郵件/郵遞服務程式 mail/postfix，請執行以下命令：

```
# sysrc postfix_enable="YES"
```

|  | 安装应用程序后阅读安装信息是一个好的做法。提供有关设置等的有用信息。|
| -- | ---------------------------------------------------------------------- |

如果 /usr/local/etc/mail/mailer.conf 中尚未激活 postfix，请执行以下命令：

```
mv /usr/local/etc/mail/mailer.conf /usr/local/etc/mail/mailer.conf.old
install -d /usr/local/etc/mail
install -m 0644 /usr/local/share/postfix/mailer.conf.postfix /usr/local/etc/mail/mailer.conf
```

使用 SASL 时，确保 postfix 有权限读取 sasldb 文件。可以通过将 postfix 添加到 mail 组，并使 /usr/local/etc/sasldb* 文件对 mail 组可读来实现（对于新安装，这应该是默认设置）。

若所有配置完成，建议重启系统。重启可以确保系统正确配置，使新的 MTA 在启动时自动运行。
