# 31.6.邮件用户代理

MUA 是用来发送和接收电子邮件的应用程序。随着电子邮件的“发展”和变得更加复杂，MUA 变得越来越强大，为用户提供了更多功能和灵活性。FreeBSD ports 的 mail 类别包含许多 MUA。这些包括图形电子邮件客户端，如 Evolution 或 Balsa，以及基于控制台的客户端，如 mutt 或 alpine。

### 31.6.1. 邮件

mail(1) 是默认安装在 FreeBSD 上的 MUA。它是一个基于控制台的 MUA，提供发送和接收文本邮件所需的基本功能。它提供有限的附件支持，并且只能访问本地邮箱。

虽然 mail(1)本身不支持与 POP 或 IMAP 服务器的交互，但可以使用 fetchmail 或 getmail 等应用程序将这些邮箱下载到本地 mbox 中。

为了发送和接收电子邮件，请运行邮件（1）：

```
% mail
```

/var/mail 用户邮箱中的内容会被邮件（1）自动读取。如果邮箱为空，该实用程序将显示一条消息，指示找不到邮件。如果存在邮件，应用程序界面将启动，并显示消息列表。

消息会自动编号，如下面的示例所示：

```
Mail version 8.1 6/6/93.  Type ? for help.
"/var/mail/username": 3 messages 3 new
>N  1 root@localhost        Mon Mar  8 14:05  14/510   "test"
 N  2 root@localhost        Mon Mar  8 14:05  14/509   "user account"
 N  3 root@localhost        Mon Mar  8 14:05  14/509   "sample"
```

现在可以通过输入 t 加上消息编号来读取消息。

这个例子读取第一封电子邮件：

```
& t 1
Message 1:
From root@localhost  Mon Mar  8 14:05:52 2004
X-Original-To: username@localhost
Delivered-To: username@localhost
To: username@localhost
Subject: test
Date: Mon,  8 Mar 2004 14:05:52 +0200 (SAST)
From: root@localhost (Charlie Root)

This is a test message, please reply if you receive it.
```

如这个例子所示，消息将显示完整的头信息。

要再次显示消息列表，请按 h。

如果电子邮件需要回复，请按 R 或 r 邮件（1）键。R 指示邮件（1）仅回复给电子邮件的发件人，而 r 则回复给该消息的所有其他收件人。这些命令可以后接要回复的消息的邮件编号。在键入响应后，消息的结尾应该由单独的一行.标记。

一个示例如下：

```
& R 1
To: root@localhost
Subject: Re: test

Thank you, I did get your email.
.
EOT
```

要发送新电子邮件，请按 m，然后输入收件人电子邮件地址。可以通过使用，分隔每个地址来指定多个收件人。然后可以输入消息主题，然后是消息内容。消息的结尾应指定为在独立行上放置一个单独的.。

```
& mail root@localhost
Subject: I mastered mail

Now I can send and receive email using mail ... :)
.
EOT
```

在使用 mail(1)时，随时按？显示帮助。有关如何使用 mail(1)的更多帮助，请参考 mail(1)。

|  | mail(1)不是为处理附件而设计的，因此对其处理不佳。新的邮件用户代理以更智能的方式处理附件。|
| -- | ------------------------------------------------------------------------------------------- |

### 31.6.2. Mutt

Mutt 是一个功能强大的 MUA，具有许多功能，包括：

* 能够对消息进行线程处理。
* 用于电子邮件的数字签名和加密的 PGP 支持。
* MIME 支持。
* Maildir 支持。
* 高度可定制。

参考 http://www.mutt.org 以获取有关 Mutt 的更多信息。

|  | 值得一提的是一个名为 NeoMutt 的 Mutt 分支，它带来了额外的功能。请查看 NeoMutt 网站了解更多信息。如果选择 NeoMutt，请将以下命令示例中的 mutt 替换为 neomutt。|
| -- | --------------------------------------------------------------------------------------------------------------------------------------------------------------- |

Mutt 可以使用 mail/mutt port安装。安装port后，可以通过发出以下命令启动 Mutt：

```
% mutt
```

Mutt 将自动读取并显示用户邮箱中的内容/var/mail。如果未找到任何邮件，Mutt 将等待用户命令。下面的示例显示了 Mutt 显示消息列表：

![Mutt email client showing a list of messages](https://docs.freebsd.org/images/books/handbook/mail/mutt1.png)

要阅读邮件，请使用光标键选择邮件，然后按回车键。可以在下面看到 Mutt 显示电子邮件的示例：

![Mutt email client displaying an email](https://docs.freebsd.org/images/books/handbook/mail/mutt2.png)

与 mail(1)类似，Mutt 可用于仅回复邮件发送者以及所有收件人。要仅回复电子邮件的发送者，请按 r。要向原始发件人以及所有消息接收人发送群回复，请按 g。

|  | 默认情况下，Mutt 使用 vi(1)编辑器来创建和回复电子邮件。每个用户都可以通过在其主目录中创建或编辑.muttrc 并设置 editor 变量或设置 EDITOR 环境变量来自定义此选项。有关配置 Mutt 的更多信息，请参阅 http://www.mutt.org/。|
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |

要撰写新邮件，请按 m。在给出有效主题后，Mutt 将启动 vi(1)，以便撰写电子邮件。若电子邮件的内容完成，保存并退出 vi。Mutt 将继续显示将要传递的邮件的摘要屏幕。要发送邮件，请按 y。可以在下面看到摘要屏幕的示例：

![Mutt email client showing the summary screen](https://docs.freebsd.org/images/books/handbook/mail/mutt3.png)

Mutt 包含广泛的帮助，可以通过按 ? 从大多数菜单中访问。顶行还显示了适当的键盘快捷键。

### 31.6.3. alpine

alpine 面向初学者用户，但也包括一些高级功能。

|  | 阿尔派在过去曾发现了几个远程漏洞，能让远程攻击者以用户身份在本地系统上执行任意代码，方法是发送一个经过特别准备的电子邮件。虽然已修复已知问题，但阿尔派的代码是以不安全的风格编写的，FreeBSD 安全官员认为可能存在其他未被发现的漏洞。用户自行承担安装阿尔派的风险。|
| -- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

可以使用 mail/alpine port 安装阿尔派的当前版本。若 port 安装完成，可以通过发出以下命令启动阿尔派：

```
% alpine
```

阿尔派第一次运行时，会显示一个问候页面，简短介绍一下，以及阿尔派开发团队请求发送一封匿名电子邮件，以帮助他们评估有多少用户在使用他们的客户端。要发送这封匿名消息，请按回车键。或者，按 E 键退出问候而不发送匿名消息。以下是问候页面的示例：

![alpine email client showing the greeting page](https://docs.freebsd.org/images/books/handbook/mail/pine1.png)

主菜单将随后显示，可以使用光标键进行导航。该主菜单提供了快捷方式，用于撰写新邮件、浏览邮件目录，以及管理通讯录条目。在主菜单下方，显示了执行与手头任务相关功能的相关键盘快捷键。

Alpine 打开的默认目录是收件箱。要查看消息索引，请按 I，或选择下面显示的消息索引选项：

![alpine email client showing the default directory](https://docs.freebsd.org/images/books/handbook/mail/pine2.png)

消息索引显示当前目录中的消息，可以使用光标键进行导航。突出显示的消息可以通过按回车键 来阅读。

![alpine email client showing the message index](https://docs.freebsd.org/images/books/handbook/mail/pine3.png)

在下面的截图中，alpine 显示了一个示例消息。屏幕底部显示了上下文键盘快捷键。一个快捷键的示例是 r，它告诉 MUA 回复当前显示的消息。

![alpine email client showing an email](https://docs.freebsd.org/images/books/handbook/mail/pine4.png)

在 alpine 中回复邮件是使用默认安装的 pico 编辑器完成的。pico 让浏览邮件变得轻松，并且对于新手用户来说比 vi(1) 或 mail(1) 更容易使用。回复完成后，可以通过按下 Ctrl+X 来发送消息。alpine 在发送消息之前会要求确认。

![alpine email client showing the message compose window](https://docs.freebsd.org/images/books/handbook/mail/pine5.png)

可以使用主菜单中的设置选项来定制 alpine。
