# 31.7.高级主题

本节涉及更复杂的主题，如邮件配置和为整个域设置邮件。

### 31.7.1. 基本配置

出厂设置时，只要 /etc/resolv.conf 配置正确或网络可以访问配置好的 DNS 服务器，即可向外部主机发送电子邮件。要将电子邮件传送到 FreeBSD 主机上的 MTA，请执行以下操作之一：

* 为该域运行一个 DNS 服务器。
* 将邮件直接投递到机器的 FQDN。

为了将邮件直接投递到主机，主机必须有一个永久的静态 IP 地址，而不是动态 IP 地址。如果系统在防火墙后面，必须配置允许 SMTP 流量。要直接在主机上接收邮件，必须配置以下两者之一：

* 确保 DNS 中编号最低的 MX 记录指向主机的静态 IP 地址。
* 确保主机的 DNS 中没有 MX 记录。

以上任一方法都将允许邮件直接到达主机。

 试试这个：

```
# hostname
```

输出应类似于以下内容：

```
example.FreeBSD.org
```

```
# host example.FreeBSD.org
```

输出应类似于以下内容：

```
example.FreeBSD.org has address 204.216.27.XX
```

在这个例子中，直接发送邮件到 yourlogin@example.FreeBSD.org 应该没有问题，假设完整功能的 MTA 在 example.FreeBSD.org 上正确运行。请注意，dma(8)不会在port 25 上监听传入连接，并且在这种情况下不能使用。

 为这个例子：

```
# host example.FreeBSD.org
```

输出应该类似于以下内容：

```
example.FreeBSD.org has address 204.216.27.XX
example.FreeBSD.org mail is handled (pri=10) by nevdull.FreeBSD.org
```

所有发送到 example.FreeBSD.org 的邮件将会在 nevdull 上以相同的用户名收集，而不是直接发送到你的主机。

以上信息由 DNS 服务器处理。携带邮件路由信息的 DNS 记录是邮件交换器记录（MX 记录）。如果不存在 MX 记录，则邮件将通过其 IP 地址直接传送到主机。

freefall.FreeBSD.org 的 MX 条目曾经是这样的：

```
freefall		MX	30	mail.crl.net
freefall		MX	40	agora.rdrop.com
freefall		MX	10	freefall.FreeBSD.org
freefall		MX	20	who.cdrom.com
```

freefall 有许多 MX 条目。最低的 MX 号码是直接接收邮件的主机（如果可用）。如果由于某种原因无法访问该主机，则下一个较低号码的主机将暂时接受消息，并在较低号码的主机可用时传递消息。

备用的 MX 站点应该有独立的互联网连接，以便最有用。你的 ISP 可以提供此服务。

### 31.7.2. 域的邮件

为网络配置 MTA 时，发送到其域中的主机的任何邮件都应转移到 MTA，以便用户可以在主邮件服务器上接收邮件。

为了使生活更加便利，MTA 和系统上的 MUA 应存在相同用户名的用户账户。使用 adduser(8) 创建用户账户。

|  | 除了将本地用户添加到主机外，还有一些称为虚拟用户的替代方法。诸如 Cyrus 和 Dovecot 的程序可以集成到 MTA 中，处理用户、邮件存储，并通过 POP3 和 IMAP 提供访问。|
| -- | --------------------------------------------------------------------------------------------------------------------------------------------------------------- |

MTA 必须是网络上每台工作站的指定邮件交换器。这在 DNS 配置中通过 MX 记录完成：

```
example.FreeBSD.org	A	204.216.27.XX		; Workstation
			MX	10 nevdull.FreeBSD.org	; Mailhost
```

这将重定向工作站的邮件到无论 A 记录指向何处的 MTA。邮件被发送到 MX 主机。

这必须在 DNS 服务器上配置。如果网络没有自己的 DNS 服务器，请与 ISP 或 DNS 提供商联系。

以下是虚拟电子邮件托管的示例。

考虑一个客户的域名为 customer1.org，所有 customer1.org 的邮件都应该发送到 mail.myhost.com。

DNS 条目应如下所示：

```
customer1.org		MX	10	mail.myhost.com
```

为 customer1.org 处理该域名的电子邮件不需要 A 记录。然而，除非存在 A 记录，否则运行 ping 对 customer1.org 将不起作用。

告诉 MTA 应该接受哪些域名和/或主机名的邮件。对于 Sendmail，以下任一种方法都可以：

* 当使用 FEATURE(use_cw_file) 时，将主机添加到 /etc/mail/local-host-names 中。
* 在 /etc/sendmail.cf 中添加一行 Cwyour.host.com。

### 31.7.3. 仅设置发送

有许多情况下，一个人可能只想通过中继发送邮件。一些例子包括：

* 计算机是需要使用诸如 mail(1)之类的程序的台式机，使用 ISP 的邮件中继。
* 计算机是一个服务器，不处理本地邮件，但需要将所有邮件传递给中继进行处理。

虽然任何邮件传输代理都能胜任这个特定的角色，但为了处理邮件的转移而正确配置一个功能齐全的邮件传输代理可能会很困难。诸如 Sendmail 和 Postfix 之类的程序对于这种用途来说过于复杂了。

另外，典型的互联网接入服务协议可能禁止用户运行"邮件服务器"。

实现这些需求的最简单方式是使用基本系统中包含的 dma(8) MTA。对于 13.2 及以下版本的系统，需要从 ports 安装。

除了 dma(8) 外，还可以使用第三方软件来实现相同的功能，比如 mail/ssmtp。

```
# cd /usr/ports/mail/ssmtp
# make install replace clean
```

安装完成后，可以使用 /usr/local/etc/ssmtp/ssmtp.conf 配置 mail/ssmtp。

```
root=yourrealemail@example.com
mailhub=mail.example.com
rewriteDomain=example.com
hostname=_HOSTNAME_
```

使用真实的电子邮件地址替换 root。在 mail.example.com 的位置输入 ISP 的出站邮件中继。一些 ISP 将其称为“出站邮件服务器”或“SMTP 服务器”。

确保禁用 Sendmail，包括出站邮件服务。有关详细信息，请参阅[mail-disable-sendmail]。

mail/ssmtp 还有一些其他选项可用。有关更多信息，请参考/usr/local/etc/ssmtp 中的示例或 ssmtp 的手册页面。

以这种方式设置 ssmtp 允许计算机上需要发送邮件的任何软件正常运行，同时不违反 ISP 的使用政策或允许计算机被劫持用于发送垃圾邮件。

### 31.7.4. Sendmail 中的 SMTP 认证

在 MTA 上配置 SMTP 认证提供了许多好处。SMTP 认证为 Sendmail 添加了一层安全性，并为切换主机的移动用户提供了在不需要每次重新配置邮件客户端设置的情况下使用相同 MTA 的能力。

从Ports 安装 security/cyrus-sasl2。这个port支持多个编译时选项。对于在此示例中演示的 SMTP 身份验证方法，请确保 LOGIN 未禁用。

安装 security/cyrus-sasl2 后，编辑 /usr/local/lib/sasl2/Sendmail.conf，如果不存在则创建它，并添加以下一行：

```
pwcheck_method: saslauthd
```

接下来，安装 security/cyrus-sasl2-saslauthd 并执行以下命令：

```
# sysrc saslauthd_enable="YES"
```

最后，启动 saslauthd 守护进程：

```
# service saslauthd start
```

这个守护进程充当 Sendmail 认证 FreeBSD passwd(5) 数据库的代理。这避免了为每个需要使用 SMTP 认证的用户创建新用户名和密码的麻烦，并保持登录密码和邮件密码相同。

接下来，编辑 /etc/make.conf 并添加以下行：

```
SENDMAIL_CFLAGS=-I/usr/local/include/sasl -DSASL
SENDMAIL_LDADD=/usr/local/lib/libsasl2.so
```

这些行为 Sendmail 提供了在编译时链接到 cyrus-sasl2 所需的适当配置选项。确保在重新编译 Sendmail 之前已安装 cyrus-sasl2。

通过执行以下命令重新编译 Sendmail：

```
# cd /usr/src/lib/libsmutil
# make cleandir && make obj && make
# cd /usr/src/lib/libsm
# make cleandir && make obj && make
# cd /usr/src/usr.sbin/sendmail
# make cleandir && make obj && make && make install
```

如果/usr/src 没有发生大量更改并且所需的共享库可用，此编译不应出现任何问题。

重新编译和安装 Sendmail 后，编辑 /etc/mail/freebsd.mc 或本地 .mc。许多管理员选择使用 hostname(1) 的输出作为 .mc 的名称以保证唯一性。

 添加以下几行：

```
dnl set SASL options
TRUST_AUTH_MECH(`GSSAPI DIGEST-MD5 CRAM-MD5 LOGIN')dnl
define(`confAUTH_MECHANISMS', `GSSAPI DIGEST-MD5 CRAM-MD5 LOGIN')dnl
```

这些选项配置了 Sendmail 用于验证用户的不同方法。如需使用 pwcheck 以外的方法，请参考 Sendmail 文档。

最后，在 /etc/mail 中运行 make(1)。这将运行新的 .mc 并创建一个名为 freebsd.cf 或本地 .mc 使用的名称的 .cf。

然后，运行 make install restart，这将把文件复制到 sendmail.cf，并正确重启 Sendmail。

有关此过程的更多信息，请参考 /etc/mail/Makefile。

为了测试配置，请使用 MUA 发送测试消息。如需进一步调查，请将 Sendmail 的 LogLevel 设置为 13 并查看 /var/log/maillog 是否有任何错误。

欲了解更多信息，请参考 SMTP 认证。
