# 32.10.文件传输协议（FTP）

文件传输协议（FTP）为用户提供了一种简单的方式来在 FTP 服务器上传输文件。FreeBSD 包含基础系统中的 FTP 服务器软件 ftpd。

FreeBSD 提供了几个配置文件来控制对 FTP 服务器的访问。本节总结了这些文件。有关内置 FTP 服务器的更多详细信息，请参考 ftpd(8)。

### 32.10.1. 配置

最重要的配置步骤是决定允许哪些账户访问 FTP 服务器。FreeBSD 系统有许多系统账户，这些账户不应该允许 FTP 访问。不允许任何 FTP 访问的用户列表可以在 /etc/ftpusers 中找到。默认情况下，它包括系统账户。可以添加其他不应该访问 FTP 的用户。

在某些情况下，可能希望限制某些用户的访问权限，而不完全阻止他们使用 FTP。可以通过创建/etc/ftpchroot 文件来实现这一目的，具体说明请参见 ftpchroot(5)。该文件列出了受 FTP 访问限制的用户和组。

要启用对服务器的匿名 FTP 访问，请在 FreeBSD 系统上创建一个名为 ftp 的用户。然后，用户将能够使用 ftp 或 anonymous 作为用户名登录到 FTP 服务器。在提示输入密码时，任何输入都将被接受，但按照惯例，应使用电子邮件地址作为密码。FTP 服务器将在匿名用户登录时调用 chroot(2)，以限制对 ftp 用户的家目录的访问。

有两个文本文件可以创建，用于指定要显示给 FTP 客户端的欢迎消息。在用户达到登录提示之前，将显示/etc/ftpwelcome 的内容。成功登录后，将显示/etc/ftpmotd 的内容。请注意，此文件的路径是相对于登录环境的，因此对匿名用户来说，将显示~ftp/etc/ftpmotd 的内容。

若 FTP 服务器配置完成，请在 /etc/rc.conf 中设置适当的变量以便在启动时启动服务：

```
ftpd_enable="YES"
```

现在启动服务：

```
# service ftpd start
```

通过键入以下命令测试与 FTP 服务器的连接：

```
% ftp localhost
```

ftpd 守护程序使用 syslog（3）记录消息。默认情况下，系统日志守护程序将在/var/log/xferlog 中写入与 FTP 相关的消息。FTP 日志的位置可以通过更改/etc/syslog.conf 中的以下行来修改：

```
ftp.info      /var/log/xferlog
```

|  | 要注意运行匿名 FTP 服务器涉及的潜在问题。特别是，请再三考虑是否允许匿名用户上传文件。可能会发现 FTP 站点成为未经许可的商业软件或更糟的交易论坛。如果需要匿名 FTP 上传，请验证权限，以便这些文件在被管理员审核之前无法被其他匿名用户读取。|
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
