# 32.11.用于 Microsoft® Windows® 客户端的文件和打印服务（Samba）



Samba 是一款流行的开源软件包，它使用 SMB/CIFS 协议提供文件和打印服务。该协议已集成到 Microsoft® Windows® 系统中。非 Microsoft® Windows® 系统可以通过安装 Samba 客户端库来添加该协议。该协议能让客户端访问共享数据和打印机。这些共享资源可以映射为本地磁盘驱动器，共享打印机可以像本地打印机一样使用。

在 FreeBSD 上，可以使用 net/samba416port或 package 安装 Samba 客户端库。客户端提供了 FreeBSD 系统访问 Microsoft® Windows®网络中的 SMB/CIFS 共享的功能。

通过安装相同的 net/samba416port或 package，FreeBSD 系统也可以配置为充当 Samba 服务器。这能让管理员在 FreeBSD 系统上创建 SMB/CIFS 共享，这些共享可以被运行 Microsoft® Windows®或 Samba 客户端库的客户端访问。

### 32.11.1. 服务器配置

Samba 配置在/usr/local/etc/smb4.conf 中。在使用 Samba 之前，必须创建此文件。

显示一个简单的 smb4.conf，用于在工作组中与 Windows®客户端共享目录和打印机。对于涉及 LDAP 或 Active Directory 的更复杂设置，最好使用 samba-tool(8)来创建初始的 smb4.conf。

```
[global]
workgroup = WORKGROUP
server string = Samba Server Version %v
netbios name = ExampleMachine
wins support = Yes
security = user
passdb backend = tdbsam

# Example: share /usr/src accessible only to 'developer' user
[src]
path = /usr/src
valid users = developer
writable  = yes
browsable = yes
read only = no
guest ok = no
public = no
create mask = 0666
directory mask = 0755
```

#### 32.11.1.1. 全局设置

在 /usr/local/etc/smb4.conf 中添加说明网络的设置：

`workgroup`

要提供服务的工作组名称。

`netbios name`

Samba 服务器的 NetBIOS 名称。默认情况下，与主机的 DNS 名称的第一个组件相同。

`server string`

将在 net view 的输出和其他一些寻求显示有关服务器的描述性文本的网络工具中显示的字符串。

`wins support`

Samba 是否将充当 WINS 服务器。不要在网络上的多台服务器上启用对 WINS 的支持。

#### 32.11.1.2。安全设置

/usr/local/etc/smb4.conf 中最重要的设置是安全模型和后端密码格式。这些指令控制选项：

`security`

最常见的设置是 security = share 和 security = user。如果客户端使用的用户名与 FreeBSD 机器上的用户名相同，应使用用户级安全性。这是默认安全策略，要求客户端在访问共享资源之前首先登录。

在共享级安全性中，客户端在尝试连接到共享资源之前不需要使用有效的用户名和密码登录服务器。这是旧版本 Samba 的默认安全模型。

`passdb backend`

Samba 有几种不同的后端身份验证模型。客户端可以使用 LDAP、NIS+、SQL 数据库或修改后的密码文件进行身份验证。推荐的身份验证方法，tdbsam，适用于简单网络，并在此处介绍。对于更大或更复杂的网络，建议使用 ldapsam。smbpasswd 曾是以前的默认设置，现在已过时。

#### 32.11.1.3. Samba 用户

FreeBSD 用户账户必须映射到 SambaSAMAccount 数据库，以便 Windows® 客户端访问共享。使用 pdbedit(8) 来映射现有的 FreeBSD 用户账户：

```
# pdbedit -a -u username
```

这部分仅提到了最常用的设置。有关可用配置选项的更多信息，请参阅官方 Samba Wiki。

### 32.11.2. 启动 Samba

要在启动时启用 Samba，请将以下行添加到 /etc/rc.conf：

```
samba_server_enable="YES"
```

现在启动 Samba：

```
# service samba_server start
Performing sanity check on Samba configuration: OK
Starting nmbd.
Starting smbd.
```

Samba 由三个独立的守护程序组成。nmbd 和 smbd 守护程序都是由 samba_enable 启动的。如果还需要 winbind 名称解析，请设置：

```
winbindd_enable="YES"
```

Samba 可以随时停止，方法是键入：

```
# service samba_server stop
```

Samba 是一个复杂的软件套件，具有能让与 Microsoft® Windows® 网络广泛集成的功能。有关超出此处说明的基本配置的功能的更多信息，请参阅 https://www.samba.org。
