# 32.12.用 NTP 进行时钟同步


随着时间的推移，计算机的时钟很容易漂移。这是一个问题，因为许多网络服务要求网络上的计算机共享相同准确的时间。准确的时间也需要确保文件时间戳保持一致。网络时间协议（NTP）是在网络中提供时钟准确性的一种方法。

FreeBSD 包括 ntpd(8)，可以配置为查询其他 NTP 服务器，以同步该计算机上的时钟或向网络中的其他计算机提供时间服务。

本节说明了如何在 FreeBSD 上配置 ntpd。更多文档详见 /usr/share/doc/ntp/，以 HTML 格式提供。

### 32.12.1. NTP 配置

在 FreeBSD 上，内置的 ntpd 可用于同步系统的时钟。ntpd 使用 rc.conf(5)变量和/etc/ntp.conf 进行配置，具体详见以下章节。

ntpd 通过 UDP 数据包与其网络对等体通信。任何位于你的计算机和其 NTP 对等体之间的防火墙必须配置为允许port 123 端口的 UDP 数据包进出。

#### 32.12.1.1. /etc/ntp.conf 文件

ntpd 读取 /etc/ntp.conf 来确定查询哪些 NTP 服务器。推荐选择多个 NTP 服务器，以防其中一个服务器无法访问或其时钟不可靠。当 ntpd 接收到响应时，它会偏向于可靠的服务器而不是不太可靠的服务器。被查询的服务器可以是本地网络的服务器、由 ISP 提供的服务器或从在线的公开可访问 NTP 服务器列表中选择的服务器。在选择公共 NTP 服务器时，选择一个地理位置接近的并查看其使用政策。pool 配置关键字从服务器池中选择一个或多个服务器。一个按地理区域组织的在线公开可访问 NTP 池列表是可用的。此外，FreeBSD 提供了一个由项目赞助的池，0.freebsd.pool.ntp.org。

示例 3. /etc/ntp.conf 样本

这是一个简单的 ntp.conf 文件示例。它可以安全地按原样使用；它包含了在公开可访问的网络连接上操作的推荐 restrict 选项。

```
# Disallow ntpq control/query access.  Allow peers to be added only
# based on pool and server statements in this file.
restrict default limited kod nomodify notrap noquery nopeer
restrict source  limited kod nomodify notrap noquery

# Allow unrestricted access from localhost for queries and control.
restrict 127.0.0.1
restrict ::1

# Add a specific server.
server ntplocal.example.com iburst

# Add FreeBSD pool servers until 3-6 good servers are available.
tos minclock 3 maxclock 6
pool 0.freebsd.pool.ntp.org iburst

# Use a local leap-seconds file.
leapfile "/var/db/ntpd.leap-seconds.list"
```

该文件的格式在 ntp.conf(5)中进行了说明。下面的说明仅提供了上面示例文件中使用的关键字的快速概述。

默认情况下，NTP 服务器对任何网络主机都是可访问的。restrict 关键字控制哪些系统可以访问该服务器。支持多个 restrict 条目，每个条目都细化了先前语句中给出的限制。示例中显示的值授予本地系统完全查询和控制访问权限，同时仅允许远程系统查询时间。有关更多详细信息，请参阅 ntp.conf(5)的 Access Control Support 子部分。

server 关键字指定要查询的单个服务器。文件可以包含多个服务器关键字，每行列出一个服务器。pool 关键字指定服务器池。ntpd 将根据需要从此池中添加一个或多个服务器，以达到使用 tos minclock 值指定的对等体数。iburst 关键字指示 ntpd 在首次建立联系时与服务器进行八次快速数据包交换的突发，以帮助快速同步系统时间。

leapfile 关键字指定了包含关于闰秒信息的文件的位置。该文件会被 periodic(8) 自动更新。此关键字指定的文件位置必须与 /etc/rc.conf 中的 ntp_db_leapfile 变量设置的位置相匹配。

#### 32.12.1.2. /etc/rc.conf 中的 NTP 条目

将 ntpd_enable=YES 设置为在启动时启动 ntpd。若 ntpd_enable=YES 添加到 /etc/rc.conf 中，可以立即启动 ntpd，无需重启系统，只需键入：

```
# service ntpd start
```

只有 ntpd_enable 必须设置为使用 ntpd。下面列出的 rc.conf 变量也可以根据需要设置。

设置 ntpd_sync_on_start=YES 以允许 ntpd 在启动时一次性调整任意数量的时钟。通常，如果时钟偏差超过 1000 秒，ntpd 会记录错误消息并退出。此选项在没有带电池后备实时时钟的系统上特别有用。

设置 ntpd_oomprotect=YES 以保护 ntpd 守护进程免受系统因尝试从内存不足（OOM）条件恢复而被终止。

将 ntpd_config= 设置为备用 ntp.conf 文件的位置。

设置 ntpd_flags= 以包含任何其他 ntpd 标志，但避免使用由 /etc/rc.d/ntpd 内部管理的这些标志：

* -p （pid 文件位置）
* -c (设置 ntpd_config= 替代)

#### 32.12.1.3. ntpd 和非特权 ntpd 用户

FreeBSD 上的 ntpd 可以作为非特权用户启动和运行。这需要 mac_ntpd(4) 策略模块。/etc/rc.d/ntpd 启动脚本首先检查 NTP 配置。如果可能，它加载 mac_ntpd 模块，然后以非特权用户 ntpd (用户 ID 123) 启动 ntpd。为避免文件和目录访问问题，当配置包含任何与文件相关的选项时，启动脚本不会自动将 ntpd 作为 ntpd 启动。

ntpd_flags 中出现以下任何情况都需要手动配置，如下所述才能以 ntpd 用户身份运行：

* -f 或 --driftfile
* -i 或 --jaildir
* -k 或 --密钥文件
* -l 或 --日志文件
* -s 或 --统计目录

ntp.conf 中出现以下任何关键字，需要按照下面说明的手动配置来以 ntpd 用户身份运行：

* 加密
* driftfile
* 键
* 日志目录
* 统计目录

要手动配置 ntpd 以 ntpd 用户身份运行，你必须：

* 确保 ntpd 用户有权访问配置中指定的所有文件和目录。
* 安排加载或编译 mac_ntpd 模块到内核中。有关详细信息，请参阅 mac_ntpd(4)。
* 在 /etc/rc.conf 中设置 ntpd_user="ntpd"

### 32.12.2. 使用 NTP 与 PPP 连接

ntpd 不需要与互联网保持永久连接才能正常运行。但是，如果配置了 PPP 连接以按需拨号，应防止 NTP 流量触发拨出或保持连接活动。可以通过在 /etc/ppp/ppp.conf 中配置 filter 指令来进行配置。例如：

```
set filter dial 0 deny udp src eq 123
# Prevent NTP traffic from initiating dial out
set filter dial 1 permit 0 0
set filter alive 0 deny udp src eq 123
# Prevent incoming NTP traffic from keeping the connection open
set filter alive 1 deny udp dst eq 123
# Prevent outgoing NTP traffic from keeping the connection open
set filter alive 2 permit 0/0 0/0
```

有关详细信息，请查阅 ppp(8) 中的 PACKET FILTERING 部分以及 /usr/share/examples/ppp/ 中的示例。

|  | 一些互联网接入提供商会封锁较低编号的端口，致使 NTP 无法正常运行，因为响应无法到达设备。|
| -- | ------------------------------------------------------------------------------------------ |
