# 32.13.iSCSI target 和 initiator 的配置

iSCSI 是一种通过网络共享存储的方式。与在文件系统级别工作的 NFS 不同，iSCSI 在块设备级别工作。

在 iSCSI 术语中，共享存储的系统称为目标。存储可以是物理磁盘，也可以是表示多个磁盘或物理磁盘部分的区域。例如，如果磁盘使用 ZFS 格式化，可以创建一个 zvol 用作 iSCSI 存储。

访问 iSCSI 存储的客户端称为发起者。对于发起者，通过 iSCSI 可用的存储显示为一个未格式化的原始磁盘，称为 LUN。磁盘的设备节点出现在 /dev/ 中，必须单独格式化和挂载。

FreeBSD 提供了基于内核的本地 iSCSI 目标和发起者。本节说明了如何将 FreeBSD 系统配置为目标或发起者。

### 配置 iSCSI 目标

要配置 iSCSI 目标，创建/etc/ctl.conf 配置文件，在/etc/rc.conf 中添加一行以确保 ctld(8)守护进程在启动时自动启动，然后启动该守护进程。

以下是一个简单的/etc/ctl.conf 配置文件示例。有关此文件可用选项的完整说明，请参阅 ctl.conf(5)。

```
portal-group pg0 {
	discovery-auth-group no-authentication
	listen 0.0.0.0
	listen [::]
}

target iqn.2012-06.com.example:target0 {
	auth-group no-authentication
	portal-group pg0

	lun 0 {
		path /data/target0-0
		size 4G
	}
}
```

第一项定义了 pg0 门户组。门户组定义了 ctld(8)守护程序将监听的网络地址。第 discovery-auth-group no-authentication 项指示任何发起者都可以在没有验证的情况下执行 iSCSI 目标发现。第三和第四行配置 ctld(8)在所有 IPv4（ listen 0.0.0.0 ）和 IPv6（ listen [::] ）地址上监听默认端口号 3260。

不必定义门户组，因为有一个名为 default 的内置门户组。在这种情况下，default 和 pg0 之间的区别在于使用 default，目标发现始终被拒绝，而使用 pg0，它始终被允许。

第二项定义了一个单一目标。目标有两个可能的含义：提供 iSCSI 服务的设备或一组具有名称的 LUN。此示例使用后一种含义，其中 iqn.2012-06.com.example:target0 是目标名称。此目标名称适用于测试目的。对于实际用途，请将 com.example 更改为真实域名的反向形式。2012-06 代表获得该域名控制的年份和月份，target0 可以是任何值。在此配置文件中可以定义任意数量的目标。

auth-group no-authentication 行允许所有发起者连接到指定目标，portal-group pg0 使目标通过 pg0 门户组可访问。

下一部分定义 LUN。对于发起者，每个 LUN 将显示为单独的磁盘设备。可为每个目标定义多个 LUN。每个 LUN 由一个编号标识，其中 LUN 0 是必需的。path /data/target0-0 行定义 LUN 的完整路径到支持 LUN 的文件或 zvol。必须在启动 ctld（8）之前存在该路径。第二行是可选的，指定 LUN 的大小。

接下来，为了确保在启动时启动 ctld（8）守护程序，请将此行添加到/etc/rc.conf：

```
ctld_enable="YES"
```

现在开始运行 ctld (8)，请运行此命令：

```
# service ctld start
```

当 ctld (8)守护进程启动时，它会读取 /etc/ctl.conf。如果在守护进程启动后编辑了此文件，请使用此命令立即生效更改：

```
# service ctld reload
```

#### 32.13.1.1. 认证

先前的示例天生不安全，因为它没有使用身份验证，为所有目标授予完全访问权限。要求用户名和密码访问目标，需修改配置如下：

```
auth-group ag0 {
	chap username1 secretsecret
	chap username2 anothersecret
}

portal-group pg0 {
	discovery-auth-group no-authentication
	listen 0.0.0.0
	listen [::]
}

target iqn.2012-06.com.example:target0 {
	auth-group ag0
	portal-group pg0
	lun 0 {
		path /data/target0-0
		size 4G
	}
}
```

auth-group 部分定义了用户名和密码对。试图连接到 iqn.2012-06.com.example:target0 的发起方必须首先指定一个已定义的用户名和密码。但是，目标发现仍允许无需身份验证。要求目标发现身份验证，将 discovery-auth-group 设置为一个已定义的 auth-group 名称，而不是 no-authentication。

为每个发起方定义单个导出目标是常见的。作为上述语法的简写，用户名和密码可以直接在目标条目中指定：

```
target iqn.2012-06.com.example:target0 {
	portal-group pg0
	chap username1 secretsecret

	lun 0 {
		path /data/target0-0
		size 4G
	}
}
```

### 32.13.2. 配置 iSCSI 发起者

|  | 本节说明的 iSCSI 发起者从 FreeBSD 10.0-RELEASE 版本开始受支持。要使用旧版本中可用的 iSCSI 发起者，请参考 iscontrol(8)。|
| -- | ------------------------------------------------------------------------------------------------------------------------- |

iSCSI 发起者要求 iscsid(8) 守护程序正在运行。该守护程序不使用配置文件。要在启动时自动启动它，请将以下行添加到 /etc/rc.conf：

```
iscsid_enable="YES"
```

现在启动 iscsid(8)，运行以下命令：

```
# service iscsid start
```

连接目标可以使用或不使用 /etc/iscsi.conf 配置文件。本节演示这两种类型的连接。

#### 32.13.2.1. 无配置文件连接目标

要将发起者连接到单个目标，请指定门户的 IP 地址和目标的名称：

```
# iscsictl -A -p 10.10.10.10 -t iqn.2012-06.com.example:target0
```

要验证连接是否成功，请运行 iscsictl 而不带任何参数。输出应该类似于这样：

```
Target name                                     Target portal   State
iqn.2012-06.com.example:target0                 10.10.10.10     Connected: da0
```

在此示例中，iSCSI 会话已成功建立，/dev/da0 代表附加的逻辑单元。如果 iqn.2012-06.com.example:target0 目标导出多个逻辑单元，则输出的该部分将显示多个设备节点：

```
Connected: da0 da1 da2.
```

任何错误都将在输出中报告，以及系统日志中。例如，此消息通常表示 iscsid(8) 守护程序未运行：

```
Target name                                     Target portal   State
iqn.2012-06.com.example:target0                 10.10.10.10     Waiting for iscsid(8)
```

以下消息表明存在网络问题，例如错误的 IP 地址或 port：

```
Target name                                     Target portal   State
iqn.2012-06.com.example:target0                 10.10.10.11     Connection refused
```

此消息表示指定的目标名称错误：

```
Target name                                     Target portal   State
iqn.2012-06.com.example:target0                 10.10.10.10     Not found
```

此消息表示目标需要身份验证：

```
Target name                                     Target portal   State
iqn.2012-06.com.example:target0                 10.10.10.10     Authentication failed
```

要指定 CHAP 用户名和密码，请使用以下语法：

```
# iscsictl -A -p 10.10.10.10 -t iqn.2012-06.com.example:target0 -u user -s secretsecret
```

#### 32.13.2.2. 使用配置文件连接到目标

要使用配置文件连接，请创建/etc/iscsi.conf，并填写如下内容：

```
t0 {
	TargetAddress   = 10.10.10.10
	TargetName      = iqn.2012-06.com.example:target0
	AuthMethod      = CHAP
	chapIName       = user
	chapSecret      = secretsecret
}
```

" t0 " 指定配置文件部分的别名。它将被 initiator 使用以指定要使用的配置。其他行指定连接期间要使用的参数。" TargetAddress " 和 " TargetName " 是必需的，而其他选项是可选的。在此示例中，显示了 CHAP 用户名和密码。

要连接到定义的目标，请指定别名：

```
# iscsictl -An t0
```

或者，要连接到配置文件中定义的所有目标，请使用：

```
# iscsictl -Aa
```

要使启动器自动连接到 /etc/iscsi.conf 中的所有目标，请将以下内容添加到 /etc/rc.conf 中：

```
iscsictl_enable="YES"
iscsictl_flags="-Aa"
```
