# 32.2.inetd 超级服务器

inetd(8) 守护程序有时被称为超级服务器，因为它管理许多服务的连接。与启动多个应用程序不同，只需启动 inetd 服务。当接收到由 inetd 管理的服务的连接时，它确定连接要发送到哪个程序，为该程序生成一个进程，并为该程序分配一个套接字。与在独立模式下单独运行每个守护程序相比，使用 inetd 来处理不常用的服务可以减少系统负载。

主要是用于生成其他守护程序的 inetd，但也内部处理几种琐碎的协议，例如 chargen、auth、time、echo、discard 和 daytime。

本节涉及配置 inetd 的基础知识。

### 32.2.1. 配置文件

配置 inetd 是通过编辑 /etc/inetd.conf 完成的。这个配置文件的每一行代表一个可以由 inetd 启动的应用程序。默认情况下，每行都以注释（ # ）开头，这意味着 inetd 未监听任何应用程序。要配置 inetd 监听某个应用程序的连接，移除该应用程序所在行开头的 #。

保存编辑后，通过编辑 /etc/rc.conf 配置 inetd 在系统启动时启动：

```
inetd_enable="YES"
```

要立即启动 inetd，以便它监听你配置的服务，请输入：

```
# service inetd start
```

若启动 inetd，每当对 /etc/inetd.conf 进行修改时，都需要通知它：

示例 1. 重新加载 inetd 配置文件

```
# service inetd reload
```

通常，应用程序的默认条目无需编辑，只需移除 # 即可。在某些情况下，可能需要编辑默认条目。

作為一個示例，這是 IPv4 上 ft、參考設定檔的預設條目：

```
ftp     stream  tcp     nowait  root    /usr/libexec/ftpd       ftpd -l
```

条目中的七列如下：

```
service-name
socket-type
protocol
{wait|nowait}[/max-child[/max-connections-per-ip-per-minute[/max-child-per-ip]]]
user[:group][/login-class]
server-program
server-program-arguments
```

 其中：

 服务名称

要启动的守护进程的服务名称。它必须对应 /etc/services 中列出的服务。这决定了 inetd 监听哪个 port 服务的传入连接。使用定制服务时，必须先将其添加到 /etc/services。

 套接字类型

使用 stream , dgram , raw 或 seqpacket。使用 stream 进行 TCP 连接，使用 dgram 提供 UDP 服务。

 协议

使用以下协议名称之一：

| 协议名称    | 解释                      |
| ------------- | --------------------------- |
| tcp 或 tcp4 | TCP IPv4                  |
| udp 或 udp4 | UDP IPv4                  |
| TCP IPv6    | TCP IPv6                  |
| udp6        | UDP IPv6                  |
| tcp46       | TCP IPv4 和 IPv6          |
| udp46       | 同时支持 UDP IPv4 和 IPv6 |

`{wait|nowait}[/max-child[/max-connections-per-ip-per-minute[/max-child-per-ip]]]`

在此字段中，必须指定 wait 或 nowait。max-child 、 max-connections-per-ip-per-minute 和 max-child-per-ip 是可选的。

wait|nowait 表示服务是否能够处理自己的套接字。dgram 套接字类型必须使用 wait，而通常是多线程的 stream 守护进程应该使用 nowait。wait 通常将多个套接字交给单个守护进程处理，而 nowait 则为每个新套接字生成一个子守护进程。

inetd 可以生成的子守护进程的最大数量由 max-child 设置。例如，要限制守护进程的十个实例，请在 nowait 后面加上 /10。指定 /0 允许无限数量的子进程。

max-connections-per-ip-per-minute 限制每分钟从任何特定 IP 地址的连接数。若达到限制，该 IP 地址的进一步连接将被拒绝，直到分钟结束。例如，值为 /10 将限制任何特定 IP 地址在一分钟内的连接尝试次数为十次。max-child-per-ip 限制可以在任何单个 IP 地址上启动的子进程数量。这些选项可以限制过度资源消耗，有助于防止拒绝服务攻击。

在 fingerd(8) 的默认设置中可以看到一个示例：

```
finger stream  tcp     nowait/3/10 nobody /usr/libexec/fingerd fingerd -k -s
```

 用户

守护进程将作为哪个用户名运行。守护进程通常以 root，daemon 或 nobody 运行。

 服务器程序

守护程序的完整路径。如果守护程序在 inetd 内部由 inetd 提供服务，则使用 internal。

服务器程序参数

用于指定要在调用时传递给守护程序的任何命令参数。如果守护程序是内部服务，请使用 internal。

### 32.2.2. 命令行选项

与大多数服务器守护程序一样，inetd 有许多选项可用于修改其行为。默认情况下，inetd 启动时使用 -wW -C 60。这些选项为所有服务启用 TCP 包装程序，包括内部服务，并阻止任何 IP 地址在一分钟内请求超过 60 次任何服务。

要更改传递给 inetd 的默认选项，请在/etc/rc.conf 中添加 inetd_flags 的条目。如果 inetd 已经在运行，请使用 service inetd restart 重启它。

可用的速率限制选项是：

 -c 最大值

指定每个服务的默认最大同时调用次数，其中默认值为无限制。可以通过在 /etc/inetd.conf 中使用 max-child 来在每个服务的基础上进行覆盖。

 -C 率

指定单个 IP 地址每分钟可以调用服务的默认最大次数。可以通过在 /etc/inetd.conf 中使用 max-connections-per-ip-per-minute 来在每个服务的基础上进行覆盖。

 -R 率

指定服务在一分钟内可以被调用的最大次数，其中默认值为 256。0 的速率允许无限次数。

 -s 最大

指定单个 IP 地址在任何时候可以从中调用服务的最大次数，默认为无限制。可以通过在 /etc/inetd.conf 中使用 max-child-per-ip 来覆盖每个服务的基础设置。

还有其他选项可用。请参考 inetd(8) 获取完整的选项列表。

### 32.2.3. 安全注意事项

许多可以由 inetd 管理的守护进程并不注重安全性。一些守护进程，如 fingerd，可以提供可能对攻击者有用的信息。只启用所需的服务，并监控系统是否有过多的连接尝试。max-connections-per-ip-per-minute 、 max-child 和 max-child-per-ip 可用于限制此类攻击。

默认情况下，TCP Wrapper 是启用的。查阅 hosts_access(5)以获取有关对各种 inetd 调用的守护进程实施 TCP 限制的更多信息。
