# 32.3.网络文件系统（NFS）

FreeBSD 支持网络文件系统 (NFS)，能让服务器通过网络与客户端共享目录和文件。使用 NFS，用户和程序可以像访问本地存储的文件一样访问远程系统上的文件。

NFS 有许多实际用途。一些更常见的用途包括：

* 否则将在每个客户端上重复的数据可以保存在单个位置，并可由网络上的客户端访问。
* 几个客户端可能需要访问/usr/ports/distfiles 目录。共享该目录可让客户端快速访问源文件，而无需将其下载到每个客户端。
* 在大型网络中，通常更方便地配置一个中央 NFS 服务器，其中存储所有用户的主目录。用户可以登录到网络中的任何客户端，并访问他们的主目录。
* NFS 导出的管理变得更加简化。例如，只有一个文件系统需要设置安全性或备份策略。
* 可以让网络中的其他计算机使用可移动媒体存储设备。这减少了网络中设备的数量，并提供了一个集中管理安全性的位置。通常更方便地从集中安装媒体在多台计算机上安装软件。

NFS 由服务器和一个或多个客户端组成。客户端远程访问存储在服务器机器上的数据。为了使其正常工作，需要配置并运行一些进程。

这些守护进程必须在服务器上运行：

| 守护进程     | 说明                                                      |
| -------------- | ----------------------------------------------------------- |
| nfsd         | 服务来自 NFS 客户端的请求的 NFS 守护程序。 |
| 挂载守护进程 | 从 nfsd 接收到的请求执行的 NFS 挂载守护进程。   |
| rpcbind      | 此守护程序允许 NFS 客户端发现 NFS 服务器正在使用的 port。|

在客户端运行 nfsiod(8) 可以提高性能，但不是必需的。

### 32.3.1. 配置服务器

NFS 服务器将共享的文件系统在/etc/exports 中指定。该文件中的每一行指定将要导出的文件系统，客户端可以访问该文件系统，以及任何访问选项。添加条目到此文件时，每个导出的文件系统、其属性和允许的主机必须出现在同一行上。如果条目中未列出任何客户端，则网络上的任何客户端均可挂载该文件系统。

下面的/etc/exports 条目演示了如何导出文件系统。这些示例可以修改以匹配读者网络上的文件系统和客户端名称。此文件中有许多可以使用的选项，但这里只会提到其中几个。查看 exports(5)以获取所有选项的完整列表。

此示例显示了如何将/cdrom 导出给名为 alpha、bravo 和 charlie 的三台主机：

```
/cdrom -ro alpha bravo charlie
```

-ro 标志使文件系统变为只读，防止客户端对导出的文件系统进行任何更改。本例假设主机名已在 DNS 或 /etc/hosts 中。如果网络中没有 DNS 服务器，请参阅 hosts(5)。

下一个例子通过 IP 地址将 /home 导出到三个客户端。这对没有 DNS 或 /etc/hosts 条目的网络很有用。-alldirs 标志能让子目录作为挂载点。换句话说，它不会自动挂载子目录，但会能让客户端根据需要挂载所需的目录。

```
/usr/home  -alldirs  10.0.0.2 10.0.0.3 10.0.0.4
```

下一个例子将 /a 导出，以便来自不同域的两个客户端可以访问该文件系统。-maproot=root 允许远程系统上的 root 以 root 的身份在导出的文件系统上写入数据。如果未指定 -maproot=root，则客户端的 root 用户将映射到服务器的 nobody 账户，并将受为 nobody 定义的访问限制的约束。

```
/a  -maproot=root  host.example.com box.example.org
```

客户端每个文件系统只能指定一次。例如，如果/usr 是单个文件系统，则这些条目将无效，因为两个条目都指定相同的主机：

```
# Invalid when /usr is one file system
/usr/src   client
/usr/ports client
```

此情况的正确格式是使用一个条目：

```
/usr/src /usr/ports  client
```

以下是一个有效导出列表的示例，其中/usr 和/exports 是本地文件系统：

```
# Export src and ports to client01 and client02, but only
# client01 has root privileges on it
/usr/src /usr/ports -maproot=root    client01
/usr/src /usr/ports               client02
# The client machines have root and can mount anywhere
# on /exports. Anyone in the world can mount /exports/obj read-only
/exports -alldirs -maproot=root      client01 client02
/exports/obj -ro
```

启用 NFS 服务器所需的进程，在启动时将这些选项添加到/etc/rc.conf 中：

```
rpcbind_enable="YES"
nfs_server_enable="YES"
mountd_enable="YES"
```

现在可以通过运行此命令启动服务器：

```
# service nfsd start
```

每当启动 NFS 服务器时，mountd 也会自动启动。但是，只有在启动时，mountd 才会读取/etc/exports。为了立即生效后续的/etc/exports 编辑，强制 mountd 重新读取它：

```
# service mountd reload
```

通过 sharenfs ZFS 属性而不是 exports(5) 文件，使用 zfs-share(8) 来说明通过 NFS 导出 ZFS 数据集。

参考 nfsv4(4) 了解 NFS 版本 4 设置的说明。

### 配置客户端。

要启用 NFS 客户端，请在每个客户端的 /etc/rc.conf 中设置此选项：

```
nfs_client_enable="YES"
```

然后，在每个 NFS 客户端上运行此命令：

```
# service nfsclient start
```

客户端现在具有挂载远程文件系统所需的一切。在这些示例中，服务器的名称是 server，客户端的名称是 client。要将 /home 挂载到 server 上的 /mnt 挂载点上 client ：

```
# mount server:/home /mnt
```

/home 中的文件和目录现在将在 client 上的 /mnt 目录中可用。

要在客户端每次启动时挂载远程文件系统，请将其添加到 /etc/fstab 中：

```
server:/home	/mnt	nfs	rw	0	0
```

请参考 fstab(5) 以获取所有可用选项的说明。

### 锁定

一些应用程序需要文件锁定才能正常运行。要启用锁定，请在客户端和服务器上执行以下命令：

```
# sysrc rpc_lockd_enable="YES"
```

然后启动 rpc.lockd(8)服务：

```
# service lockd start
```

如果服务器不需要锁定，则可以在运行挂载时包含 -L 来配置 NFS 客户端以在本地锁定。有关详细信息，请参阅 mount_nfs(8)。

### 32.3.4. 使用 autofs(5)自动挂载

|  | autofs(5)自动挂载功能从 FreeBSD 10.1-RELEASE 开始受支持。要在旧版本的 FreeBSD 中使用自动挂载功能，请改用 amd(8)。本章仅说明 autofs(5)自动挂载器。|
| -- | --------------------------------------------------------------------------------------------------------------------------------------------------- |

autofs(5)设施是几个组件的常用名称，这些组件一起能让在访问文件系统中的文件或目录时自动挂载远程和本地文件系统。它由内核组件 autofs(5)和几个用户空间应用程序组成：automount(8)、automountd(8)和 autounmountd(8)。它作为以前 FreeBSD 版本中 amd(8)的替代方案。amd 仍然提供用于向后兼容，因为两者使用不同的映射格式；autofs 使用的映射与其他 SVR4 自动挂载程序相同，例如 Solaris、MacOS X 和 Linux 中的自动挂载程序。

autofs(5)虚拟文件系统由 automount(8)在指定的挂载点上挂载，通常在启动期间调用。

每当进程尝试访问 autofs(5)挂载点内的文件时，内核将通知 automountd(8)守护程序并暂停触发进程。automountd(8)守护程序将通过查找适当的映射并根据其挂载文件系统来处理内核请求，然后通知内核释放被阻止的进程。autounmountd(8)守护程序会在一段时间后自动卸载自动挂载的文件系统，除非它们仍在使用中。

主要的 autofs 配置文件是 /etc/auto_master。它将各个映射分配给顶级挂载点。关于 auto_master 和映射语法的详细说明，请参阅 auto_master(5)。

在 /net 上挂载了一个特殊的自动挂载映射。当访问此目录中的文件时，autofs(5) 会查找相应的远程挂载并自动挂载它。例如，尝试访问 /net/foobar/usr 中的文件会告诉 automountd(8) 从主机 foobar 挂载 /usr 导出目录。

示例 2. 使用 autofs(5) 挂载导出

在此示例中，showmount -e 显示了可以从 NFS 服务器挂载的导出文件系统，foobar ：

```
% showmount -e foobar
Exports list on foobar:
/usr                               10.10.10.0
/a                                 10.10.10.0
% cd /net/foobar/usr
```

showmount 的输出显示 /usr 作为一个导出。当更改目录到 /host/foobar/usr 时，automountd(8) 会拦截请求并尝试解析主机名 foobar。如果成功，automountd(8) 会自动挂载源导出。

要在启动时启用 autofs(5)，请将此行添加到 /etc/rc.conf 中：

```
autofs_enable="YES"
```

然后可以通过运行 autofs(5) 来启动它：

```
# service automount start
# service automountd start
# service autounmountd start
```

autofs(5) 映射格式与其他操作系统相同。其他来源关于此格式的信息可能有用，比如 Mac OS X 文档。

有关更多信息，请参阅 automount(8)、automountd(8)、autounmountd(8) 和 auto_master(5) 手册页。
