# 32.4.网络信息系统（NIS）

网络信息系统（NIS）旨在集中管理类 UNIX®系统，如 Solaris™，HP-UX，AIX®，Linux，NetBSD，OpenBSD 和 FreeBSD。NIS 最初被称为黄页，但由于商标问题而更名。这就是为什么 NIS 命令以 yp 开头的原因。

NIS 是一个基于远程过程调用（RPC）的客户端/服务器系统，允许 NIS 域内的一组计算机共享一组共同的配置文件。这允许系统管理员仅使用最少的配置数据设置 NIS 客户端系统，并从单一位置添加、删除或修改配置数据。

FreeBSD 使用 NIS 协议的第 2 版。

### 32.4.1. NIS 术语和流程

表 28.1 总结了 NIS 使用的术语和重要过程：

表 1. NIS 术语

| 术语     | 说明                                                                                                                                                                                                      |
| ---------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| NIS 域名 | NIS 服务器和客户端共享一个 NIS 域名。通常，这个名称与 DNS 没有任何关系。                                                                                                                   |
| [rpcbind(8)](https://man.freebsd.org/cgi/man.cgi?query=rpcbind&sektion=8&format=html)         | 此服务启用了 RPC，必须在运行 NIS 服务器或作为 NIS 客户端时运行。                                                                                                                           |
| [ypbind(8)](https://man.freebsd.org/cgi/man.cgi?query=ypbind&sektion=8&format=html)         | 此服务将 NIS 客户端绑定到其 NIS 服务器。它将获取 NIS 域名并使用 RPC 连接到服务器。这是 NIS 环境中客户端/服务器通信的核心。如果客户端机器上未运行此服务，则将无法访问 NIS 服务器。          |
| [ypserv(8)](https://man.freebsd.org/cgi/man.cgi?query=ypserv&sektion=8&format=html)         | 这是 NIS 服务器的过程。如果此服务停止运行，服务器将不再能够响应 NIS 请求，因此希望有一个备用服务器接管。一些非 FreeBSD 客户端将不会尝试使用备用服务器重新连接，这些客户端上可能需要重启 ypbind 进程。|
| [rpc.yppasswdd(8)](https://man.freebsd.org/cgi/man.cgi?query=rpc.yppasswdd&sektion=8&format=html)         | 此进程仅在 NIS 主服务器上运行。此守护程序允许 NIS 客户端更改其 NIS 密码。如果此守护程序未运行，用户将必须登录到 NIS 主服务器并在那里更改其密码。                                           |

### 32.4.2. 机器类型

在 NIS 环境中有三种类型的主机：

* NIS 主服务器此服务器充当主机配置信息的中央存储库，并维护所有 NIS 客户端使用的文件的权威副本。NIS 客户端使用的 passwd、group 和其他各种文件存储在主服务器上。虽然一台机器可以是一个 NIS 域的 NIS 主服务器，但本章不涉及这种类型的配置，因为它假定是一个相对小规模的 NIS 环境。
* NIS 从服务器 NIS 从服务器维护 NIS 主服务器数据文件的副本，以提供冗余性。从服务器还有助于平衡主服务器的负载，因为 NIS 客户端总是连接到最先响应的 NIS 服务器。
* NIS 客户端在登录时与 NIS 服务器进行身份验证。

使用 NIS 可以共享许多文件中的信息。master.passwd、group 和 hosts 文件通常通过 NIS 进行共享。每当客户端上的进程需要通常在这些文件中找到的信息时，它会向绑定的 NIS 服务器发出查询。

### 32.4.3. 计划注意事项

本节说明了一个示例 NIS 环境，其中包括 15 台 FreeBSD 机器，没有集中的管理点。每台机器都有自己的/etc/passwd 和/etc/master.passwd。这些文件只能通过手动干预进行同步。目前，在实验室添加用户时，这个过程必须在所有 15 台机器上重复进行。

实验室的配置如下：

| 机器名称 | IP 地址 | 机器角色     |
| ---------- | --------- | -------------- |
| `ellington`         | `10.0.0.2`        | NIS 主服务器 |
| `coltrane`         | `10.0.0.3`        | NIS 从属站   |
| `basie`         | `10.0.0.4`        | 教职工工作站 |
| `bird`         | `10.0.0.5`        | 客户端机器   |
| `cli[1-11]`         | `10.0.0.[6-17]`        | 其他客户机   |

如果这是第一次开发 NIS 方案，则应提前进行彻底的规划。无论网络大小如何，作为规划过程的一部分，需要做出几项决策。

#### 32.4.3.1. 选择 NIS 域名

当客户端广播其请求信息时，它会包含其所属的 NIS 域的名称。这就是一个网络上的多个服务器如何区分哪个服务器应该回答哪个请求。将 NIS 域名视为一组主机的名称。

一些组织选择使用其互联网域名作为其 NIS 域名。这并不推荐，因为在尝试调试网络问题时可能会引起混淆。NIS 域名应在网络中是唯一的，并且最好能说明其代表的机器组。例如，Acme 公司的艺术部门可能在"acme-art"的 NIS 域中。此示例将使用域名 test-domain。

然而，一些非 FreeBSD 操作系统要求 NIS 域名必须与互联网域名相同。如果网络中有一台或多台机器有此限制，则必须将互联网域名用作 NIS 域名。

#### 32.4.3.2. 物理服务器要求

选择用作 NIS 服务器的机器时，有几个方面需要注意。由于 NIS 客户端依赖于服务器的可用性，选择一台不经常重启的机器。理想情况下，NIS 服务器应该是独立的机器，其唯一目的是作为 NIS 服务器。如果网络使用不繁重，将 NIS 服务器放在运行其他服务的机器上也是可以接受的。然而，如果 NIS 服务器不可用，将会对所有 NIS 客户端产生不利影响。

### 32.4.4. 配置 NIS 主服务器

在主服务器上存储所有 NIS 文件的规范副本。用于存储信息的数据库称为 NIS 映射。在 FreeBSD 中，这些映射存储在/var/yp/[domainname]中，其中[domainname]是 NIS 域的名称。由于支持多个域，因此可以有几个目录，每个域一个目录。每个域都将有自己独立的映射集。

NIS 主服务器和从服务器通过 ypserv(8)处理所有 NIS 请求。这个守护程序负责接收来自 NIS 客户端的传入请求，将请求的域和映射名称转换为相应数据库文件的路径，并将数据从数据库传输回客户端。

设置主 NIS 服务器可以相对简单，具体取决于环境需求。由于 FreeBSD 提供了内置的 NIS 支持，只需通过将以下行添加到/etc/rc.conf 来启用它：

```
nisdomainname="test-domain"
nis_server_enable="YES"
nis_yppasswdd_enable="YES"
```

|  | 将 NIS 域名设置为 test-domain。                           |
| -- | --------------------------------------------------------------------------- |
|  | 这会在系统启动时自动启动 NIS 服务器进程。                  |
|  | 这会启用 rpc.yppasswdd(8) 守护程序，以便用户可以从客户端更改其 NIS 密码。|

在服务器机器也是 NIS 客户端的多服务器域中，必须小心。通常，最好强制服务器绑定到自己，而不是允许它们广播绑定请求并可能相互绑定。如果一个服务器宕机并且其他服务器依赖于它，可能会导致奇怪的故障模式。最终，所有客户端将超时并尝试绑定到其他服务器，但涉及的延迟可能是相当大的，故障模式仍然存在，因为服务器可能再次互相绑定。

服务器也是客户端的服务器可以通过向 /etc/rc.conf 添加以下附加行来强制绑定到特定服务器：

```
nis_client_enable="YES"
nis_client_flags="-S test-domain,server"
```

|  | 这使得运行客户端内容成为可能。|
| -- | ---------------------------------------------- |
|  | 将 NIS 域名设置为 test-domain 并绑定到自身。|

保存编辑后，键入 /etc/netstart 以重启网络并应用/etc/rc.conf 中定义的值。在初始化 NIS 映射之前，启动 ypserv(8)：

```
# service ypserv start
```

#### 32.4.4.1. 初始化 NIS 映射

NIS 映像由 NIS 主服务器上的 /etc 中的配置文件生成，只有一个例外：/etc/master.passwd。这是为了防止密码传播到 NIS 域中的所有服务器。因此，在初始化 NIS 映像之前，请配置主要密码文件：

```
# cp /etc/master.passwd /var/yp/master.passwd
# cd /var/yp
# vi master.passwd
```

建议删除所有系统账户条目以及任何不需要传播到 NIS 客户端的用户账户，例如 root 和任何其他管理账户。

|  | 确保 /var/yp/master.passwd 既不可组读取也不可世界读取，通过将其权限设置为 600。|
| -- | ---------------------------------------------------------------------------------- |

在完成此任务后，初始化 NIS 映像。FreeBSD 包括 ypinit(8) 脚本来执行此操作。生成主服务器的映像时，请包含 -m 并指定 NIS 域名：

```
ellington# ypinit -m test-domain
Server Type: MASTER Domain: test-domain
Creating an YP server will require that you answer a few questions.
Questions will all be asked at the beginning of the procedure.
Do you want this procedure to quit on non-fatal errors? [y/n: n] n
Ok, please remember to go back and redo manually whatever fails.
If not, something might not work.
At this point, we have to construct a list of this domains YP servers.
rod.darktech.org is already known as master server.
Please continue to add any slave servers, one per line. When you are
done with the list, type a <control D>.
master server   :  ellington
next host to add:  coltrane
next host to add:  ^D
The current list of NIS servers looks like this:
ellington
coltrane
Is this correct?  [y/n: y] y

[..output from map generation..]

NIS Map update completed.
ellington has been setup as an YP master server without any errors.
```

这将从 /var/yp/Makefile.dist 创建 /var/yp/Makefile。默认情况下，此文件假定环境中有一个单独的 NIS 服务器，只有 FreeBSD 客户端。由于 test-domain 有一个从服务器，请编辑 /var/yp/Makefile 中的此行，使其以注释开头 ( # )：

```
NOPUSH = "True"
```

#### 32.4.4.2. 添加新用户

每次创建新用户时，必须将用户账户添加到主 NIS 服务器并重建 NIS 映射。在此之前，新用户将无法登录到除 NIS 主服务器之外的任何地方。例如，要将新用户 jsmith 添加到 test-domain 域，请在主服务器上运行以下命令：

```
# pw useradd jsmith
# cd /var/yp
# make test-domain
```

也可以使用 adduser jsmith 而不是 pw useradd smith 来添加用户。

### 32.4.5. 设置 NIS 从服务器

要设置 NIS 从服务器，请登录到从服务器并像主服务器一样编辑/ etc / rc.conf。不要生成任何 NIS 映射，因为这些在主服务器上已经存在。在从服务器上运行 ypinit 时，请改用 -s （用于从服务器），而不是 -m （用于主服务器）。此选项除了域名外还需要 NIS 主服务器的名称，如本示例中所示：

```
coltrane# ypinit -s ellington test-domain

Server Type: SLAVE Domain: test-domain Master: ellington

Creating an YP server will require that you answer a few questions.
Questions will all be asked at the beginning of the procedure.

Do you want this procedure to quit on non-fatal errors? [y/n: n]  n

Ok, please remember to go back and redo manually whatever fails.
If not, something might not work.
There will be no further questions. The remainder of the procedure
should take a few minutes, to copy the databases from ellington.
Transferring netgroup...
ypxfr: Exiting: Map successfully transferred
Transferring netgroup.byuser...
ypxfr: Exiting: Map successfully transferred
Transferring netgroup.byhost...
ypxfr: Exiting: Map successfully transferred
Transferring master.passwd.byuid...
ypxfr: Exiting: Map successfully transferred
Transferring passwd.byuid...
ypxfr: Exiting: Map successfully transferred
Transferring passwd.byname...
ypxfr: Exiting: Map successfully transferred
Transferring group.bygid...
ypxfr: Exiting: Map successfully transferred
Transferring group.byname...
ypxfr: Exiting: Map successfully transferred
Transferring services.byname...
ypxfr: Exiting: Map successfully transferred
Transferring rpc.bynumber...
ypxfr: Exiting: Map successfully transferred
Transferring rpc.byname...
ypxfr: Exiting: Map successfully transferred
Transferring protocols.byname...
ypxfr: Exiting: Map successfully transferred
Transferring master.passwd.byname...
ypxfr: Exiting: Map successfully transferred
Transferring networks.byname...
ypxfr: Exiting: Map successfully transferred
Transferring networks.byaddr...
ypxfr: Exiting: Map successfully transferred
Transferring netid.byname...
ypxfr: Exiting: Map successfully transferred
Transferring hosts.byaddr...
ypxfr: Exiting: Map successfully transferred
Transferring protocols.bynumber...
ypxfr: Exiting: Map successfully transferred
Transferring ypservers...
ypxfr: Exiting: Map successfully transferred
Transferring hosts.byname...
ypxfr: Exiting: Map successfully transferred

coltrane has been setup as an YP slave server without any errors.
Remember to update map ypservers on ellington.
```

这将在从服务器上生成一个名为/ var / yp / test-domain 的目录，其中包含 NIS 主服务器映射的副本。在每台从服务器上添加这些/ etc / crontab 条目将强制从服务器将其映射与主服务器上的映射同步：

```
20      *       *       *       *       root   /usr/libexec/ypxfr passwd.byname
21      *       *       *       *       root   /usr/libexec/ypxfr passwd.byuid
```

这些条目不是强制性的，因为主服务器会自动尝试将任何映射更改推送到其从服务器。但是，由于客户端可能依赖从服务器提供正确的密码信息，因此建议强制频繁的密码映射更新。在繁忙的网络上，映射更新可能并不总是完成，这一点尤为重要。

要完成配置，请在从服务器上运行 /etc/netstart 以启动 NIS 服务。

### 32.4.6. 设置 NIS 客户端

NIS 客户端使用 ypbind(8) 绑定到 NIS 服务器。该守护程序在本地网络上广播 RPC 请求。这些请求指定在客户端上配置的域名。如果同一域中的 NIS 服务器接收到广播之一，它将响应 ypbind，并记录服务器的地址。如果有多个可用的服务器，客户端将使用第一个响应的服务器地址，并将其所有 NIS 请求定向到该服务器。客户端将定期自动 ping 服务器，以确保其仍然可用。如果在合理的时间内未收到回复，则 ypbind 将标记该域为未绑定，并重新开始广播，希望找到另一个服务器。

配置 FreeBSD 机器成为 NIS 客户端：

1. 编辑/etc/rc.conf，并按顺序添加以下行以设置 NIS 域名并在网络启动期间启动 ypbind(8)：

    ```
    nisdomainname="test-domain"
    nis_client_enable="YES"
    ```
2. 要从 NIS 服务器导入所有可能的密码条目，请使用 vipw 从/etc/master.passwd 中移除所有用户账户，除了一个。在删除账户时，请记住至少应保留一个本地账户，并且该账户应是 wheel 的成员。如果 NIS 出现问题，可以使用此本地账户远程登录，成为超级用户，并解决问题。在保存编辑之前，请将以下行添加到文件末尾：

    ```
    +:::::::::
    ```

    这行配置客户端，为 NIS 服务器密码映射中任何拥有有效账户的用户提供客户端账户。有很多方法可以通过修改此行来配置 NIS 客户端。在 Using Netgroups 中说明了一种方法。欲了解更多详细内容，请参考由 O'Reilly Media 出版的 Managing NFS and NIS 一书。
3. 要从 NIS 服务器导入所有可能的组条目，请将此行添加到/etc/group 中：

    ```
    +:*::
    ```

要立即启动 NIS 客户端，请以超级用户身份执行以下命令：

```
# /etc/netstart
# service ypbind start
```

完成这些步骤后，在客户端上运行 ypcat passwd 应该显示服务器的 passwd 映像。

### 32.4.7. NIS 安全

由于 RPC 是基于广播的服务，任何在同一域内运行 ypbind 的系统都可以检索 NIS 映像的内容。为防止未经授权的交易，ypserv(8)支持一个名为"securenets"的功能，可用于限制对给定一组主机的访问。默认情况下，此信息存储在/var/yp/securenets 中，除非 ypserv(8)以 -p 和替代路径启动。该文件包含由空格分隔的网络规范和网络掩码组成的条目。以 "#" 开头的行被视为注释。示例 securenets 可能如下所示：

```
# allow connections from local host -- mandatory
127.0.0.1     255.255.255.255
# allow connections from any host
# on the 192.168.128.0 network
192.168.128.0 255.255.255.0
# allow connections from any host
# between 10.0.0.0 to 10.0.15.255
# this includes the machines in the testlab
10.0.0.0      255.255.240.0
```

如果 ypserv(8) 收到与这些规则之一匹配的地址的请求，它将正常处理该请求。如果地址未能匹配规则，请求将被忽略，并记录警告消息。如果 securenets 不存在，ypserv 将允许来自任何主机的连接。

TCP Wrapper 是提供访问控制的替代机制，而不是 securenets。虽然任一访问控制机制都增加了一些安全性，但它们都容易受到“IP 欺骗”攻击的影响。所有与 NIS 相关的流量应在防火墙上被阻止。

使用 securenets 的服务器可能无法为具有古老 TCP/IP 实现的合法 NIS 客户端提供服务。其中一些实现在进行广播时将所有主机位设置为零，或者在计算广播地址时未遵守子网掩码。虽然某些问题可以通过更改客户端配置来解决，但其他问题可能会迫使这些客户端系统退役或放弃 securenets。

使用 TCP 包装程序会增加 NIS 服务器的延迟。额外的延迟可能足够长，以至于在忙碌网络中的慢 NIS 服务器中导致客户程序超时。如果一个或多个客户端遭受延迟，请将这些客户端转换为 NIS 从服务器，并强制它们绑定到自己。

#### 32.4.7.1。排斥一些用户

在这个例子中，basie 系统是 NIS 域内的一个教师工作站。主 NIS 服务器上的 passwd 映射包含教师和学生的账户。本节演示了如何允许该系统上的教师登录，同时拒绝学生登录。

要防止特定用户登录系统，即使他们存在于 NIS 数据库中，请使用 vipw 向客户端的/etc/master.passwd 末尾添加正确数量的冒号以添加 -<em>username</em>，其中用户名是要阻止登录的用户的用户名。被阻止用户的行必须在允许 NIS 用户的 + 行之前。在此示例中，bill 被禁止登录到 basie ：

```
basie# cat /etc/master.passwd
root:[password]:0:0::0:0:The super-user:/root:/bin/csh
toor:[password]:0:0::0:0:The other super-user:/root:/bin/sh
daemon:*:1:1::0:0:Owner of many system processes:/root:/usr/sbin/nologin
operator:*:2:5::0:0:System &:/:/usr/sbin/nologin
bin:*:3:7::0:0:Binaries Commands and Source,,,:/:/usr/sbin/nologin
tty:*:4:65533::0:0:Tty Sandbox:/:/usr/sbin/nologin
kmem:*:5:65533::0:0:KMem Sandbox:/:/usr/sbin/nologin
games:*:7:13::0:0:Games pseudo-user:/usr/games:/usr/sbin/nologin
news:*:8:8::0:0:News Subsystem:/:/usr/sbin/nologin
man:*:9:9::0:0:Mister Man Pages:/usr/share/man:/usr/sbin/nologin
bind:*:53:53::0:0:Bind Sandbox:/:/usr/sbin/nologin
uucp:*:66:66::0:0:UUCP pseudo-user:/var/spool/uucppublic:/usr/libexec/uucp/uucico
xten:*:67:67::0:0:X-10 daemon:/usr/local/xten:/usr/sbin/nologin
pop:*:68:6::0:0:Post Office Owner:/nonexistent:/usr/sbin/nologin
nobody:*:65534:65534::0:0:Unprivileged user:/nonexistent:/usr/sbin/nologin
-bill:::::::::
+:::::::::

basie#
```

### 32.4.8. 使用 Netgroups

阻止特定用户登录到各个系统在较大网络上变得不可扩展，并迅速失去 NIS 的主要优势：集中管理。

网络组是为处理具有数百用户和计算机的大型复杂网络而开发的。它们的使用类似于 UNIX®组，主要区别在于没有数值 ID，并且可以通过包含用户账户和其他网络组来定义网络组。

为了扩展本章示例中使用的内容，NIS 域将被扩展以添加表 28.2 和 28.3 中显示的用户和系统：

表 2.附加用户

| 用户名                        | 说明        |
| ------------------------------- | ------------- |
| `alpha`, `beta`                            | IT 部门员工 |
| `charlie`, `delta`                            | IT 部门学徒 |
| echo，foxtrott，golf，… | 员工        |
| `able`, `baker`, …                        | 实习生      |

表 3. 附加系统

| 机器名     | 说明                                                                 |
| ------------ | ---------------------------------------------------------------------- |
| `war`, `death`, `famine`, `pollution`     | 只有 IT 员工可以登录这些服务器。                      |
| `pride`, `greed`, `envy`, `wrath`, `lust`, `sloth` | IT 部门的所有成员都可以登录这些服务器。               |
| `one`, `two`, `three`, `four`, … | 员工使用的普通工作站。                                |
| `trashcan`           | 一台非常老旧的机器，没有任何关键数据。甚至实习生都可以使用这个系统。|

当使用 netgroups 配置此场景时，每个用户被分配到一个或多个 netgroup，并且登录权限对所有 netgroup 成员都有效或禁止。在添加新机器时，必须为所有 netgroup 定义登录限制。添加新用户时，必须将账户添加到一个或多个 netgroup。如果仔细规划 NIS 设置，只需修改一个中心配置文件即可授予或拒绝对机器的访问。

第一步是初始化 NIS netgroup 映像。在 FreeBSD 中，默认情况下不会创建此映像。在 NIS 主服务器上，使用编辑器创建一个名为 /var/yp/netgroup 的映像。

该示例创建四个 netgroups 以表示 IT 员工、IT 学徒、员工和实习生:

```
IT_EMP  (,alpha,test-domain)    (,beta,test-domain)
IT_APP  (,charlie,test-domain)  (,delta,test-domain)
USERS   (,echo,test-domain)     (,foxtrott,test-domain) \
        (,golf,test-domain)
INTERNS (,able,test-domain)     (,baker,test-domain)
```

每个条目都配置了一个 netgroup。条目中的第一列是 netgroup 的名称。每组括号代表一个或多个用户或另一个 netgroup 的名称。在指定用户时，每个组内的三个逗号分隔字段分别表示:

1. 其他字段表示用户有效的主机名称。如果未指定主机名，则条目在所有主机上有效。
2. 属于此网络组的账户的名称。
3. 账户的 NIS 域。账户可以从其他 NIS 域导入到网络组中。

如果组包含多个用户，请使用空格分隔每个用户。另外，每个字段都可以包含通配符。有关详细信息，请参阅 netgroup(5)。

网组名称不应超过 8 个字符。这些名称区分大小写，使用大写字母作为网组名称的一种简单方法，可以区分用户、机器和网组名称。

一些非 FreeBSD 的 NIS 客户端不能处理超过 15 个条目的网组。可以通过创建包含 15 个或更少用户的多个子网组，并创建一个包含这些子网组的真实网组来规避此限制，如此示例所示：

```
BIGGRP1  (,joe1,domain)  (,joe2,domain)  (,joe3,domain) [...]
BIGGRP2  (,joe16,domain)  (,joe17,domain) [...]
BIGGRP3  (,joe31,domain)  (,joe32,domain)
BIGGROUP  BIGGRP1 BIGGRP2 BIGGRP3
```

如果单个网组中存在超过 225 个用户（15 乘以 15），则重复此过程。

要激活并分发新的 NIS 地图：

```
ellington# cd /var/yp
ellington# make
```

这将生成三个 NIS 地图 netgroup、netgroup.byhost 和 netgroup.byuser。使用 ypcat(1)的 map 密钥选项来检查新的 NIS 地图是否可用：

```
ellington% ypcat -k netgroup
ellington% ypcat -k netgroup.byhost
ellington% ypcat -k netgroup.byuser
```

第一条命令的输出应该类似于/var/yp/netgroup 的内容。如果创建了特定主机的 netgroup，则第二个命令只会产生输出。第三个命令用于获取用户的 netgroup 列表。

为了配置客户端，请使用 vipw(8) 来指定 netgroup 的名称。例如，在名为 war 的服务器上，用以下内容替换这行:

```
+:::::::::
```

with

```
+@IT_EMP:::::::::
```

这指定只有在 netgroup IT_EMP 中定义的用户将被导入到此系统的密码数据库中，只有这些用户被允许登录到此系统。

此配置也适用于 ~ 函数以及所有将用户名和数字用户 ID 之间进行转换的例程。换句话说，cd ~<em>user</em> 将无法工作，ls -l 将显示用户名的数字 ID，find . -user joe -print 将失败，并显示消息 No such user。要解决此问题，请导入所有用户条目，而不允许它们登录到服务器。可以通过添加额外的一行来实现：

```
+:::::::::/usr/sbin/nologin
```

此行配置客户端以导入所有条目，但将这些条目中的shell替换为/usr/sbin/nologin。

确保额外的行放置在 +@IT_EMP::::::::: 之后。否则，从 NIS 导入的所有用户账户将将/usr/sbin/nologin 作为他们的登录shell，并且将无法登录到系统。

配置不太重要的服务器，将服务器上的旧 +::::::::: 替换为这些行：

```
+@IT_EMP:::::::::
+@IT_APP:::::::::
+:::::::::/usr/sbin/nologin
```

工作站的相应行将是：

```
+@IT_EMP:::::::::
+@USERS:::::::::
+:::::::::/usr/sbin/nologin
```

NIS 支持从其他 netgroups 创建 netgroups，如果关于用户访问权限的策略发生变化，则这可能很有用。一种可能性是创建基于角色的 netgroups。例如，可以创建一个名为 BIGSRV 的 netgroup 来定义重要服务器的登录限制，另一个名为 SMALLSRV 的 netgroup 用于不太重要的服务器，以及第三个名为 USERBOX 的 netgroup 用于工作站。每个 netgroup 都包含被允许登录到这些设备的 netgroups。NIS netgroup 映射的新条目将如下所示：

```
BIGSRV    IT_EMP  IT_APP
SMALLSRV  IT_EMP  IT_APP  ITINTERN
USERBOX   IT_EMP  ITINTERN USERS
```

当可以定义具有相同限制的机器组时，定义登录限制的这种方法运行得相当好。不幸的是，这只是个例外，而不是规则。大多数时候，需要能够按照每台机器的需求定义登录限制。

另一种处理策略变更的可能性是特定于机器的网组定义。在这种场景中，每个系统的 /etc/master.passwd 包含两行，以 "+" 开头。第一行添加一个包含允许登录到该机器的账户的网组，第二行添加所有其他账户，并将其设为 /usr/sbin/nologin。建议使用主机名的全大写版本作为网组的名称：

```
+@BOXNAME:::::::::
+:::::::::/usr/sbin/nologin
```

若在所有机器上完成了这项任务，就再也不需要再次修改本地版本的 /etc/master.passwd 了。所有进一步的更改可以通过修改 NIS 映射来处理。这里是该场景下可能的 NIS 映射的示例：

```
# Define groups of users first
IT_EMP    (,alpha,test-domain)    (,beta,test-domain)
IT_APP    (,charlie,test-domain)  (,delta,test-domain)
DEPT1     (,echo,test-domain)     (,foxtrott,test-domain)
DEPT2     (,golf,test-domain)     (,hotel,test-domain)
DEPT3     (,india,test-domain)    (,juliet,test-domain)
ITINTERN  (,kilo,test-domain)     (,lima,test-domain)
D_INTERNS (,able,test-domain)     (,baker,test-domain)
#
# Now, define some groups based on roles
USERS     DEPT1   DEPT2     DEPT3
BIGSRV    IT_EMP  IT_APP
SMALLSRV  IT_EMP  IT_APP    ITINTERN
USERBOX   IT_EMP  ITINTERN  USERS
#
# And a groups for a special tasks
# Allow echo and golf to access our anti-virus-machine
SECURITY  IT_EMP  (,echo,test-domain)  (,golf,test-domain)
#
# machine-based netgroups
# Our main servers
WAR       BIGSRV
FAMINE    BIGSRV
# User india needs access to this server
POLLUTION  BIGSRV  (,india,test-domain)
#
# This one is really important and needs more access restrictions
DEATH     IT_EMP
#
# The anti-virus-machine mentioned above
ONE       SECURITY
#
# Restrict a machine to a single user
TWO       (,hotel,test-domain)
# [...more groups to follow]
```

使用基于角色而非基于机器的网络组可能更为明智。在部署数十或数百个系统时，可使用基于角色的网络组，以保持 NIS 地图的合理大小。

### 32.4.9. 密码格式

NIS 要求同一域中的所有主机使用相同的密码加密格式。如果用户在 NIS 客户端上认证有问题，可能是由于密码格式不同。在异构网络中，密码格式必须由所有操作系统支持，DES 是最低公共标准。

要检查服务器或客户端使用的格式，请查看/etc/login.conf 的这一部分：

```
default:\
	:passwd_format=des:\
	:copyright=/etc/COPYRIGHT:\
	[Further entries elided]
```

在这个例子中，系统使用 DES 格式进行密码哈希。其他可能的值包括 blf 表示 Blowfish，md5 表示 MD5，sha256 和 sha512 分别表示 SHA-256 和 SHA-512。有关更多信息和你系统上可用的最新列表，请查阅 crypt(3)手册页。

如果主机上的格式需要编辑以匹配 NIS 域中使用的格式，则在保存更改后必须重新构建登录能力数据库：

```
# cap_mkdb /etc/login.conf
```

|  | 现有用户账户的密码格式将在重新构建登录功能数据库后，每个用户更改密码之后才会更新。|
| -- | ------------------------------------------------------------------------------------ |
