# 32.6.动态主机设置协议（DHCP）


动态主机配置协议（DHCP）能让系统连接到网络，以便为在该网络上通信所需的寻址信息分配地址。FreeBSD 包括 OpenBSD 版本的 dhclient，客户端使用该版本获取寻址信息。FreeBSD 不安装 DHCP 服务器，但在 FreeBSD ports 中提供了几个服务器。DHCP 协议在 RFC 2131 中有详细说明。信息资源也可在 isc.org/downloads/dhcp/上找到。

本节说明如何使用内置的 DHCP 客户端。然后说明如何安装和配置 DHCP 服务器。

|  | 在 FreeBSD 中，DHCP 服务器和 DHCP 客户端都需要 bpf(4)设备。这个设备包含在随 FreeBSD 安装的 GENERIC 内核中。偏爱创建自定义内核的用户需要在使用 DHCP 时保留这个设备。<br /><br />值得注意的是，bpf 还能让特权用户在系统上运行网络数据包嗅探器。|
| -- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

### 32.6.1. 配置 DHCP 客户端

FreeBSD 安装程序中包含 DHCP 客户端支持，使得配置新安装的系统自动从现有的 DHCP 服务器接收网络地址信息变得轻松。有关网络配置的示例，请参阅账户、时区、服务和加固。

当 dhclient 在客户端机器上执行时，它开始广播请求配置信息。默认情况下，这些请求使用 UDPport68。服务器在 UDPport67 上回复，为客户端提供 IP 地址和其他相关的网络信息，例如子网掩码、默认网关和 DNS 服务器地址。这些信息以 DHCP“租约”的形式提供，并且在可配置的时间内有效。这样可以自动重新使用不再连接到网络的客户端的过期 IP 地址。DHCP 客户端可以从服务器获取大量信息。详尽列表可在 dhcp-options(5)中找到。

默认情况下，当 FreeBSD 系统启动时，它的 DHCP 客户端会在后台或异步运行。其他启动脚本会在 DHCP 进程完成的同时继续运行，从而加快系统启动速度。

当 DHCP 服务器快速响应客户端请求时，后台 DHCP 工作良好。然而，在某些系统上 DHCP 可能需要很长时间才能完成。如果网络服务在 DHCP 分配网络地址信息之前尝试运行，它们将失败。使用同步模式的 DHCP 可以防止此问题，因为它会暂停启动，直到 DHCP 配置完成。

/etc/rc.conf 中的这一行用于配置后台或异步模式：

```
ifconfig_fxp0="DHCP"
```

安装过程中如果系统配置为使用 DHCP，则此行可能已存在。请根据“设置网络接口卡”中说明的要动态配置的接口名称，替换这些示例中显示的 fxp0。

若要改为配置系统以使用同步模式，并在启动过程中暂停等待 DHCP 完成，请使用“SYNCDHCP”：

```
ifconfig_fxp0="SYNCDHCP"
```

可用其他客户端选项。在 rc.conf(5) 中搜索 dhclient 以获取详细信息。

DHCP 客户端使用以下文件：

* /etc/dhclient.conf dhclient 使用的配置文件。通常，此文件仅包含注释，因为默认设置适用于大多数客户端。有关此配置文件的说明，请参阅 dhclient.conf(5)。
* /sbin/dhclient 有关命令本身的更多信息，请参阅 dhclient(8)。
* /sbin/dhclient-script 用于 FreeBSD 特定的 DHCP 客户端配置脚本。在 dhclient-script(8) 中有说明，但通常不需要用户修改即可正常运行。
* /var/db/dhclient.leases.interface DHCP 客户端在此文件中保留有效租约的数据库，该文件作为日志记录，并在 dhclient.leases(5) 中有说明。

### 32.6.2. 安装和配置 DHCP 服务器

本节演示如何配置 FreeBSD 系统，使其充当 DHCP 服务器，使用 Internet Systems Consortium (ISC)实现的 DHCP 服务器。此实现及其文档可以使用 net/isc-dhcp44-server 软件包或port安装。

安装 net/isc-dhcp44-server 会安装一个示例配置文件。将/usr/local/etc/dhcpd.conf.example 复制到/usr/local/etc/dhcpd.conf，并对新文件进行任何编辑。

配置文件由子网和主机的声明组成，这些声明定义了提供给 DHCP 客户端的信息。例如，这些行配置如下：

```
option domain-name "example.org";
option domain-name-servers ns1.example.org;
option subnet-mask 255.255.255.0;

default-lease-time 600;
max-lease-time 72400;
ddns-update-style none;

subnet 10.254.239.0 netmask 255.255.255.224 {
  range 10.254.239.10 10.254.239.20;
  option routers rtr-239-0-1.example.org, rtr-239-0-2.example.org;
}

host fantasia {
  hardware ethernet 08:00:07:26:c0:a5;
  fixed-address fantasia.fugue.com;
}
```

|  | 此选项指定将提供给客户端的默认搜索域。有关更多信息，请参阅 resolv.conf(5)。                                                                                                                                |
| -- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
|  | 此选项指定客户端应使用的 DNS 服务器的逗号分隔列表。它们可以按照其完全限定域名（FQDN）列出，如示例中所示，也可以按照其 IP 地址列出。                                                                        |
|  | 将提供给客户端的子网掩码。                                                                                                                                                                                 |
|  | 默认的租约到期时间（以秒为单位）。客户端可以配置为覆盖此值。                                                                                                                                               |
|  | 租约的最大允许时长，以秒为单位。如果客户端请求更长的租约，仍会发放租约，但只会有效 max-lease-time。                                                                                                       |
|  | 默认设置为 none，禁用动态 DNS 更新。将其更改为 interim 会配置 DHCP 服务器在分配租约时更新 DNS 服务器，以便 DNS 服务器知道网络中哪些计算机与哪些 IP 地址关联。除非已配置 DNS 服务器以支持动态 DNS，否则不要更改默认设置。|
|  | 创建一个可用 IP 地址池，这些地址保留供分配给 DHCP 客户端使用。地址范围必须在前一行指定的网络或子网中有效。                                                                                                 |
|  | 声明默认网关，该网关适用于前面在 { 括号内指定的网络或子网。                                                                                                                                                |
|  | 指定客户端的硬件 MAC 地址，以便 DHCP 服务器在客户端发出请求时能够识别客户端。                                                                                                                              |
|  | 指定此主机始终应该获得同一个 IP 地址。使用主机名是正确的，因为 DHCP 服务器将在返回租约信息之前解析主机名。                                                                                                |

此配置文件支持更多选项。有关详细信息和示例，请参阅与服务器一起安装的 dhcpd.conf(5)。

若 dhcpd.conf 的配置完成，就在/etc/rc.conf 中启用 DHCP 服务器：

```
dhcpd_enable="YES"
dhcpd_ifaces="dc0"
```

用接口（或用空格分隔的多个接口）替换 dc0，以便 DHCP 服务器监听 DHCP 客户端请求。

通过以下命令启动服务器：

```
# service isc-dhcpd start
```

对服务器配置的任何未来更改都需要停止 dhcpd 服务，然后使用 service(8)重启。

DHCP 服务器使用以下文件。请注意手册页面是与服务器软件一起安装的。

* /usr/local/sbin/dhcpd 有关 dhcpd 服务器的更多信息，请参阅 dhcpd(8)。
* /usr/local/etc/dhcpd.conf 服务器配置文件需要包含应提供给客户端的所有信息，以及有关服务器操作的信息。有关此配置文件的说明，请参阅 dhcpd.conf(5)。
* /var/db/dhcpd.leases DHCP 服务器将其发出的租约保留在此文件中，作为日志记录。请参阅 dhcpd.leases(5)，其中提供了稍长一点的说明。
* /usr/local/sbin/dhcrelay 此守护程序用于高级环境，其中一个 DHCP 服务器将来自客户端的请求转发到另一个位于不同网络上的 DHCP 服务器。如果需要此功能，请安装 net/isc-dhcp44-relay 软件包或port。安装包括提供更多详细信息的 dhcrelay(8)。
