# 32.7.域名系统（DNS）

域名系统 (DNS) 是通过将域名映射到 IP 地址及其反向映射的协议。DNS 通过一个相对复杂的权威根域名服务器、顶级域 (TLD) 和其他小规模名称服务器系统在整个互联网中进行协调，这些服务器托管和缓存各个域名信息。在系统上执行 DNS 查询不需要运行名称服务器。

下表说明了一些与 DNS 相关的术语：

表 4. DNS 术语

| 术语     | 定义                                                                             |
| ---------- | ---------------------------------------------------------------------------------- |
| 正向 DNS | 主机名到 IP 地址的映射。                                          |
| 源头     | 指的是特定区域文件中涉及的域名。                                  |
| 解析器   | 一种系统处理过程，通过该过程，机器向名称服务器查询区域信息。      |
| 反向 DNS | IP 地址到主机名的映射。                                           |
| 根区     | 互联网区域层次的开始。所有区域都属于根区，类似于文件系统中所有文件都属于根目录。|
| 区域     | 由同一机构管理的单个域、子域或 DNS 的部分。                       |

 区域的示例：

* 在文档中通常将 . 称为根区域。
* org. 是根域下的顶级域名（TLD）。
* example.org. 是 org. TLD 下的一个区域。
* 1.168.192.in-addr.arpa 是引用所有 192.168.1.* IP 地址空间下 IP 地址的一个区域。

因为人们可以看出，主机名的更具体部分出现在左侧。例如，example.org. 比 org. 更具体，因为 org. 比根区更具体。主机名的每个部分的布局很像文件系统：/dev 目录位于根目录内，依此类推。

### 32.7.1. 运行名称服务器的原因

名称服务器通常有两种形式：权威名称服务器和缓存(也称为解析)名称服务器。

当需要一个权威的域名服务器时：

* 当希望向世界提供 DNS 信息并对查询做出权威回复时。
* 当注册了一个域名，比如 example.org，并且需要为其下的主机名分配 IP 地址时。
* IP 地址块需要反向 DNS 条目（IP 到主机名）。
* 备份或第二名称服务器，称为从服务器，将回复查询。

当需要缓存名称服务器时：

* 本地 DNS 服务器可以比查询外部名称服务器更快地进行缓存和响应。

当查询 www.FreeBSD.org 时，解析器通常会查询上行 ISP 的名称服务器，并获取回复。使用本地缓存 DNS 服务器时，查询只需由缓存 DNS 服务器向外界进行一次。由于信息在本地缓存，额外的查询不需要离开本地网络。

### 32.7.2. DNS 服务器配置

FreeBSD 基本系统中提供了 Unbound。默认情况下，它只为本地机器提供 DNS 解析。虽然可以配置基本系统包以提供超出本地机器的解析服务，但建议通过从 FreeBSD 1001 收集安装 Unbound 来解决此类需求。

要启用 Unbound，请将以下内容添加到 /etc/rc.conf：

```
local_unbound_enable="YES"
```

/etc/resolv.conf 中的任何现有域名服务器都将配置为新 Unbound 配置中的转发器。

```
% drill -S FreeBSD.org @192.168.1.1
```

若每个名称服务器被确认支持 DNSSEC，启动 Unbound：

```
# service local_unbound onestart
```

这将负责更新 /etc/resolv.conf，以便对 DNSSEC 安全域的查询现在可以工作。例如，运行以下命令来验证 FreeBSD.org 的 DNSSEC 信任树：

```
% drill -S FreeBSD.org
;; Number of trusted keys: 1
;; Chasing: freebsd.org. A

DNSSEC Trust tree:
freebsd.org. (A)
|---freebsd.org. (DNSKEY keytag: 36786 alg: 8 flags: 256)
    |---freebsd.org. (DNSKEY keytag: 32659 alg: 8 flags: 257)
    |---freebsd.org. (DS keytag: 32659 digest type: 2)
        |---org. (DNSKEY keytag: 49587 alg: 7 flags: 256)
            |---org. (DNSKEY keytag: 9795 alg: 7 flags: 257)
            |---org. (DNSKEY keytag: 21366 alg: 7 flags: 257)
            |---org. (DS keytag: 21366 digest type: 1)
            |   |---. (DNSKEY keytag: 40926 alg: 8 flags: 256)
            |       |---. (DNSKEY keytag: 19036 alg: 8 flags: 257)
            |---org. (DS keytag: 21366 digest type: 2)
                |---. (DNSKEY keytag: 40926 alg: 8 flags: 256)
                    |---. (DNSKEY keytag: 19036 alg: 8 flags: 257)
;; Chase successful
```

### 32.7.3. 权威名称服务器配置

FreeBSD 在基本系统中不提供权威名称服务器软件。建议用户安装第三方应用程序，如 dns/nsd 或 dns/bind918 软件包或port。
