# 32.9.Apache HTTP 服务器

开源的 Apache HTTP Server 是使用最广泛的 web 服务器。FreeBSD 默认不安装此 web 服务器，但可以从 www/apache24 软件包或 port 安装。

本节总结了如何在 FreeBSD 上配置和启动 Apache HTTP 服务器的 2.x 版本。有关 Apache 2.X 及其配置指令的更详细信息，请参考 httpd.apache.org。

### 32.9.1. 配置和启动 Apache

在 FreeBSD 中，主要的 Apache HTTP 服务器配置文件安装在/usr/local/etc/apache2x/httpd.conf，其中 x 表示版本号。这个 ASCII 文本文件以 # 开头的注释行。最经常修改的指令包括：

`ServerRoot "/usr/local"`

指定 Apache 安装的默认目录层次结构。二进制文件存储在服务器根目录的 bin 和 sbin 子目录中，配置文件存储在 etc/apache2x 子目录中。

`ServerAdmin you@example.com`

将此更改为接收服务器问题的电子邮件地址。此地址也会出现在一些服务器生成的页面上，例如错误文档。

`ServerName www.example.com:80`

能让管理员设置一个主机名，该主机名会发送回客户端。例如，可以使用 www 代替实际的主机名。如果系统没有注册的 DNS 名称，请输入其 IP 地址。如果服务器将监听替代端口，请将 80 更改为替代的port号。

`DocumentRoot "/usr/local/www/apache2_x_/data"`

文档将被提供的目录。默认情况下，所有请求都从此目录获取，但可以使用符号链接和别名指向其他位置。

在修改默认 Apache 配置文件之前，制作备份副本始终是个好主意。完成 Apache 配置后，请保存文件并使用 apachectl 验证配置。运行 apachectl configtest 应返回 Syntax OK。

要在系统启动时启动 Apache，请将以下行添加到 /etc/rc.conf 中：

```
apache24_enable="YES"
```

如果要使用非默认选项启动 Apache，则可以将以下行添加到 /etc/rc.conf 中指定所需的标志：

```
apache24_flags=""
```

如果 apachectl 没有报告配置错误，请立即启动 httpd ：

```
# service apache24 start
```

可以通过在 Web 浏览器中输入 http://<em>localhost</em> 来测试 httpd 服务，将 localhost 替换为运行 httpd 的机器的完全限定域名。显示的默认网页是 /usr/local/www/apache24/data/index.html。

可以使用以下命令在 httpd 运行时测试 Apache 配置更改后的错误：

```
# service apache24 configtest
```

|  | 需要注意的是，configtest 不是 rc(8)标准，不应期望适用于所有启动脚本。|
| -- | ------------------------------------------------------------------------ |

### 32.9.2. 虚拟主机

虚拟主机能让多个网站在一个 Apache 服务器上运行。虚拟主机可以基于 IP 或基于名称。基于 IP 的虚拟主机为每个网站使用不同的 IP 地址。基于名称的虚拟主机使用客户端的 HTTP/1.1 标头来确定主机名，这能让多个网站共享同一个 IP 地址。

要设置 Apache 使用基于名称的虚拟主机，请为每个网站添加一个 VirtualHost 块。例如，对于名为 www.domain.tld 的 Web 服务器，虚拟域为 www.someotherdomain.tld，请将以下条目添加到 httpd.conf 中：

```
<VirtualHost *>
    ServerName www.domain.tld
    DocumentRoot /www/domain.tld
</VirtualHost>

<VirtualHost *>
    ServerName www.someotherdomain.tld
    DocumentRoot /www/someotherdomain.tld
</VirtualHost>
```

对于每个虚拟主机，请替换要使用的 ServerName 和 DocumentRoot 的值。

有关设置虚拟主机的更多信息，请参阅官方 Apache 文档：http://httpd.apache.org/docs/vhosts/。

### 32.9.3. Apache 模块

Apache 使用模块来增强基本服务器提供的功能。请参阅 http://httpd.apache.org/docs/current/mod/，了解所有可用模块的完整列表和配置详细信息。

在 FreeBSD 中，一些模块可以使用 www/apache24 port编译。在/usr/ports/www/apache24 中键入 make config 以查看可用的模块以及默认启用的模块。如果模块未与port编译，FreeBSD ports 提供了安装许多模块的简便方法。本节说明了三个最常用的模块。

#### 32.9.3.1. SSL 支持

有一段时间，Apache 内部支持 SSL 需要一个名为 mod_ssl 的辅助模块。现在不再需要这样做，因为默认安装的 Apache 已经内置 SSL 到 Web 服务器中。在安装目录/usr/local/etc/apache24/extra 中有一个名为 httpd-ssl.conf 的示例文件，其中包含启用 SSL 网站支持的示例。在该目录中还有一个名为 ssl.conf-sample 的示例文件。建议评估这两个文件，以正确设置 Apache Web 服务器中的安全网站。

SSL 配置完成后，必须取消注释主要 http.conf 中的以下行，以在 Apache 下次重启或重新加载时激活更改：

```
#Include etc/apache24/extra/httpd-ssl.conf
```

|  | SSL 版本 2 和版本 3 存在已知的安全漏洞。强烈建议在较旧的 SSL 选项之前启用 TLS 版本 1.2 和 1.3。可以通过在 ssl.conf 中设置以下选项来实现此目的： |
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------- |

```
SSLProtocol all -SSLv3 -SSLv2 +TLSv1.2 +TLSv1.3
SSLProxyProtocol all -SSLv2 -SSLv3 -TLSv1 -TLSv1.1
```

要完成 Web 服务器中 SSL 的配置，请取消注释以下行，以确保在重启或重新加载 Apache 时将配置引入其中：

```
# Secure (SSL/TLS) connections
Include etc/apache24/extra/httpd-ssl.conf
```

要完全支持 Apache 中的 SSL，还必须取消 httpd.conf 中的以下行的注释：

```
LoadModule authn_socache_module libexec/apache24/mod_authn_socache.so
LoadModule socache_shmcb_module libexec/apache24/mod_socache_shmcb.so
LoadModule ssl_module libexec/apache24/mod_ssl.so
```

下一步是与证书颁发机构合作，在系统上安装适当的证书。这将为网站建立信任链，并防止出现自签名证书的警告。

#### 32.9.3.2。mod_perl

mod_perl 模块使得在 Perl 中编写 Apache 模块成为可能。此外，嵌入服务器中的持久解释器避免了启动外部解释器的开销以及 Perl 启动时间的惩罚。

使用 www/mod_perl2 包或 port 可以安装 mod_perl。有关使用此模块的文档，请访问 http://perl.apache.org/docs/2.0/index.html。

#### 32.9.3.3. mod_php

PHP：超文本预处理器（PHP）是一种通用脚本语言，特别适用于 Web 开发。能够嵌入到 HTML 中，其语法借鉴了 C、Java™和 Perl，旨在让 Web 开发人员快速编写动态生成的网页。

通过安装适当的port，可以为 Apache 和用该语言编写的任何其他功能提供对 PHP 的支持。

对所有支持的版本，使用 pkg 搜索软件包数据库：

```
# pkg search php
```

将显示一个列表，其中包括版本和它们提供的附加功能。组件是完全模块化的，这意味着通过安装适当的port来启用功能。要为 Apache 安装 PHP 7.4 版本，请执行以下命令：

```
# pkg install mod_php74
```

如果需要安装任何依赖软件包，它们也会被安装。

默认情况下，PHP 不会启用。需要将以下几行添加到位于 /usr/local/etc/apache24 的 Apache 配置文件中以使其生效：

```
<FilesMatch "\.php$">
    SetHandler application/x-httpd-php
</FilesMatch>
<FilesMatch "\.phps$">
    SetHandler application/x-httpd-php-source
</FilesMatch>
```

另外，配置文件中的 DirectoryIndex 也需要更新，并且需要重启或重新加载 Apache 才能使更改生效。

通过 pkg 也可以安装许多 PHP 功能的支持。例如，要安装 XML 或 SSL 支持，请安装它们各自的ports：

```
# pkg install php74-xml php74-openssl
```

与以往一样，即使只是安装了一个模块，在使更改生效时也需要重新加载 Apache 配置。

执行优雅重启以重新加载配置，请执行以下命令：

```
# apachectl graceful
```

安装完成后，有两种方法可以获取已安装的 PHP 支持模块和构建的环境信息。第一种方法是安装完整的 PHP 二进制文件，并运行命令以获取信息：

```
# pkg install php74
```

```
# php -i | less
```

必须将输出传递给一个分页器，例如 more 或 less，以更轻松地消化大量输出。

最后，要对 PHP 的全局配置进行任何更改，需要修改一个文档良好的文件，安装在 /usr/local/etc/php.ini。在安装时，该文件不存在，因为有两个可供选择的版本，一个是 php.ini-development，另一个是 php.ini-production。这些是管理者在部署过程中的起点。

#### 32.9.3.4. HTTP2 支持

安装port和 pkg 时，默认包含 Apache 对 HTTP2 协议的支持。新版本的 HTTP 相比以前的版本有很多改进，包括利用单个连接访问网站，减少 TCP 连接的总往返次数。同时，数据包头数据被压缩，HTTP2 默认要求加密。

當 Apache 配置為僅使用 HTTP2 時，Web 瀏覽器將需要安全的加密 HTTPS 連接。當 Apache 配置為使用兩個版本時，如果在連接期間出現任何問題，則 HTTP1.1 將被視為備用選項。

雖然這個變化確實需要管理員進行更改，但這些都是積極的，對於每個人來說都等於更安全的互聯網。這些更改只適用於目前尚未實施 SSL 和 TLS 的站點。

|  | 這個配置取決於前面的部分，包括 TLS 支持。建議在繼續進行這個配置之前先遵循那些說明。|
| -- | ------------------------------------------------------------------------------------- |

通过取消注释/usr/local/etc/apache24/httpd.conf 中的一行来启用 http2 模块，将 mpm_prefork 模块替换为 mpm_event，因为前者不支持 HTTP2，从而启动这一过程。

```
LoadModule http2_module libexec/apache24/mod_http2.so
LoadModule mpm_event_module libexec/apache24/mod_mpm_event.so
```

|  | 有一个单独的 mod_http2 port可供使用。它的存在是为了更快地提供安全性和错误修复，优于捆绑的 apache24 port中安装的模块。虽然不是必需的支持 HTTP2，但它是可用的。当安装时，应该在 Apache 配置中使用 mod_h2.so 取代 mod_http2.so。|
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

在 Apache 中实现 HTTP2 有两种方法；一种是针对系统上运行的所有站点以及每个 VirtualHost 全局启用 HTTP2。要全局启用 HTTP2，请在 ServerName 指令下添加以下行：

```
Protocols h2 http/1.1
```

|  | 要在明文上启用 HTTP2，请在 httpd.conf 中使用 h2h2chttp/1.1。|
| -- | -------------------------------------------------------------- |

在这里使用 h2c 将能让明文 HTTP2 数据通过系统，但不建议这样做。此外，在这里使用 http/1.1 将能让系统在需要时回退到协议的 HTTP1.1 版本。

要为单独的虚拟主机启用 HTTP2，请在 httpd.conf 或 httpd-ssl.conf 中的 VirtualHost 指令中添加相同的行。

使用 apachectl 重载命令重新加载配置，并在访问其中一个托管页面后使用以下任一方法测试配置：

```
# grep "HTTP/2.0" /var/log/httpd-access.log
```

这应该返回类似以下内容：

```
192.168.1.205 - - [18/Oct/2020:18:34:36 -0400] "GET / HTTP/2.0" 304 -
192.0.2.205 - - [18/Oct/2020:19:19:57 -0400] "GET / HTTP/2.0" 304 -
192.0.0.205 - - [18/Oct/2020:19:20:52 -0400] "GET / HTTP/2.0" 304 -
192.0.2.205 - - [18/Oct/2020:19:23:10 -0400] "GET / HTTP/2.0" 304 -
```

另一种方法是使用网页浏览器的内置站点调试器或 tcpdump ；但是，使用任一方法都超出了本文档的范围。

通过使用 mod_proxy_http2.so 模块支持 HTTP2 反向代理连接。在配置 ProxyPass 或 RewriteRules [P] 语句时，应使用 h2:// 进行连接。

### 32.9.4. 动态网站

除了 mod_perl 和 mod_php，还有其他语言可用于创建动态网页内容。这些包括 Django 和 Ruby on Rails。

#### 32.9.4.1. Django

Django 是一个 BSD 许可的框架，旨在使开发人员能够快速编写高性能、优雅的 Web 应用程序。它提供了一个对象关系映射器，以便数据类型被开发为 Python 对象。提供了一个丰富的动态数据库访问 API，使得这些对象无需开发人员编写 SQL 就能使用。它还提供一个可扩展的模板系统，以便将应用程序的逻辑与 HTML 呈现分离。

Django 依赖于 mod_python 和 SQL 数据库引擎。在 FreeBSD 中，www/py-django port会自动安装 mod_python，并支持 PostgreSQL、MySQL 或 SQLite 数据库，其中默认值为 SQLite。要更改数据库引擎，请在/usr/ports/www/py-django 内键入 make config，然后安装port。

若安装了 Django，应用程序将需要一个项目目录以及 Apache 配置，以便使用嵌入式 Python 解释器。此解释器用于在站点上为特定 URL 调用应用程序。

要配置 Apache 将针对某些 URL 的请求传递到 Web 应用程序，请将以下内容添加到 httpd.conf 中，指定项目目录的完整路径：

```
<Location "/">
    SetHandler python-program
    PythonPath "['/dir/to/the/django/packages/'] + sys.path"
    PythonHandler django.core.handlers.modpython
    SetEnv DJANGO_SETTINGS_MODULE mysite.settings
    PythonAutoReload On
    PythonDebug On
</Location>
```

有关如何使用 Django 的更多信息，请参阅 https://docs.djangoproject.com。

#### 32.9.4.2. Ruby on Rails

Ruby on Rails 是另一个提供完整开发堆栈的开源 Web 框架。它经过优化，可以使 Web 开发人员更加高效，能够快速编写强大的应用程序。在 FreeBSD 上，可以使用 www/rubygem-rails 软件包或port进行安装。

有关如何使用 Ruby on Rails 的更多信息，请参阅 http://guides.rubyonrails.org。
