# 33.1.概述

防火墙使得可以过滤流经系统的进出流量。防火墙可以使用一组或多组“规则”来检查网络数据包，当它们进入或离开网络连接时，允许流量通过或阻止它。防火墙的规则可以检查数据包的一个或多个特征，例如协议类型、源或目标主机地址以及源或目标port。

防火墙可以增强主机或网络的安全性。它们可用于执行以下一项或多项操作：

* 保护和隔离内部网络中的应用程序、服务和设备免受来自公共互联网的不必要流量。
* 限制或禁用内部网络主机访问公共互联网服务。
* 支持网络地址转换（NAT），允许内部网络使用私有 IP 地址，并使用单个 IP 地址或共享一组自动分配的公共地址共享与公共互联网的连接。

FreeBSD 在基本系统中内置了三个防火墙：PF、IPFW 和 IPFILTER，也称为 IPF。FreeBSD 还提供两种流量整形器来控制带宽使用：altq(4)和 dummynet(4)。ALTQ 传统上与 PF 紧密关联，dummynet 与 IPFW 关联。每个防火墙使用规则来控制数据包对 FreeBSD 系统的访问，尽管它们采用不同的方式进行，每个都有不同的规则语法。

FreeBSD 提供多个防火墙，以满足各种用户的不同需求和偏好。每个用户都应评估哪种防火墙最符合他们的需求。

阅读完本章后，你将会了解：

* 如何定义数据包过滤规则。
* FreeBSD 内置防火墙之间的区别。
* 如何使用和配置 PF 防火墙。
* 如何使用和配置 IPFW 防火墙。
* 如何使用和配置 IPFILTER 防火墙。

阅读本章之前，你应该：

* 理解基本的 FreeBSD 和互联网概念。

|  | 由于所有防火墙都基于检查选定数据包控制字段的值，因此防火墙规则集的创建者必须理解 TCP/IP 的工作原理，数据包控制字段中的不同值是什么，以及这些值如何在正常会话中使用。有关良好的介绍，请参阅 Daryl 的 TCP/IP 入门指南。|
| -- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
