# 33.2.防火墙的概念

一组规则集包含一组规则，这些规则根据数据包中包含的值来传递或阻止数据包。主机之间数据包的双向交换组成一个会话对话。防火墙规则集处理来自公共互联网的数据包，以及系统作为响应它们而产生的数据包。每个 TCP/IP 服务都由其协议和监听port预定义。封装到特定服务的数据包源自使用一个非特权port的源地址，并将目标地址上的特定服务port作为目标。所有上述参数都可以作为选择标准用来创建将传递或阻止服务的规则。

查找未知的port号码，请参考/etc/services。或者，访问 http://en.wikipedia.org/wiki/List_of_TCP_and_UDP_port_numbers 并进行port号码查找以找到特定port号码的目的。

点击此链接查看特洛伊木马使用的port号码。

FTP 有两种模式：主动模式和被动模式。区别在于数据通道的获取方式。被动模式更安全，因为数据通道是由原 ftp 会话请求者获取的。想要了解 FTP 和不同模式的详细解释，请参见 http://www.slacksite.com/other/ftp.html。

防火墙规则集可以是“排他性”或“包容性”。排他性防火墙允许所有流量通过，除了与规则集匹配的流量。包容性防火墙则相反，只允许与规则匹配的流量通过，阻止其余所有流量。

包容性防火墙提供了对传出流量更好的控制，使其成为为向公共互联网提供服务的系统更好的选择。它还控制了来自公共互联网的流量类型，可以访问私人网络。所有不匹配规则的流量都将被阻止并记录。包容性防火墙通常比排他性防火墙更安全，因为它显著降低了允许不需要的流量的风险。

|  | 除非另有说明，本章节中的所有配置和示例规则集均创建包容性防火墙规则集。|
| -- | ------------------------------------------------------------------------ |

使用“有状态防火墙”可以进一步加强安全性。这种类型的防火墙跟踪已打开的连接，并且只允许符合现有连接或者打开新的允许连接的流量通过。

有状态过滤将流量视为会话的双向交换，由数据包组成。当匹配规则上指定了状态时，防火墙会动态生成每个预期在会话期间交换的数据包的内部规则。它具有足够的匹配能力来确定数据包是否适合会话。任何不符合会话模板的数据包都会被自动拒绝。

当会话完成时，它会从动态状态表中移除。

有状态过滤允许用户专注于阻止/通过新会话。如果新会话被通过，所有随后的数据包将自动允许通过，任何冒充数据包将被自动拒绝。如果新会话被阻止，将不允许通过任何随后的数据包。有状态过滤提供了高级匹配能力，能够抵御攻击者采用的各种攻击方法的洪水攻击。

NAT 代表网络地址转换。NAT 功能使得防火墙后面的私有局域网能够共享单个由 ISP 分配的 IP 地址，即使该地址是动态分配的。NAT 允许局域网中的每台计算机都能够访问互联网，而无需为多个互联网账户或 IP 地址向 ISP 支付费用。

NAT 将在数据包离开防火墙前自动将私有局域网上每台系统的 IP 地址转换为单个公共 IP 地址。它还为返回的数据包执行相反的转换。

根据 RFC 1918，以下 IP 地址范围专用于私有网络，永远不会直接路由到公共互联网，因此可以与 NAT 一起使用：

* `10.0.0.0/8`.
* `172.16.0.0/12`.
* `192.168.0.0/16`.

|  | 在处理防火墙规则时，请非常小心。某些配置可能会将管理员锁定在服务器外。为了安全起见，考虑从本地控制台而不是通过 SSH 远程执行初始防火墙配置。|
| -- | --------------------------------------------------------------------------------------------------------------------------------------------- |
