# 34.10.使用 PXE 进行无盘操作

Intel® 预启动执行环境 (PXE) 能让操作系统通过网络启动。例如，FreeBSD 系统可以通过网络启动并在没有本地磁盘的情况下运行，使用从 NFS 服务器挂载的文件系统。PXE 支持通常在 BIOS 中可用。要在机器启动时使用 PXE，请在 BIOS 设置中选择 Boot from network 选项或在系统初始化期间按下功能键。

为了提供操作系统网络引导所需的文件，PXE 设置还需要正确配置的 DHCP、TFTP 和 NFS 服务器，其中：

* 初始参数，如 IP 地址、可执行引导文件名和位置、服务器名称和根路径都是从 DHCP 服务器获得的。
* 操作系统加载程序文件是通过 TFTP 引导的。
* 文件系统使用 NFS 加载。

当计算机进行 PXE 引导时，它通过 DHCP 接收关于初始引导加载程序文件获取位置的信息。主机计算机接收到这些信息后，通过 TFTP 下载引导加载程序，然后执行引导加载程序。在 FreeBSD 中，引导加载程序文件为/boot/pxeboot。/boot/pxeboot 执行后，加载 FreeBSD 内核，然后继续 FreeBSD 引导序列的其余部分，如《FreeBSD 引导过程》中所述。

|  | 对于基于 UEFI PXE 的引导，要使用的实际引导加载程序文件是/boot/loader.efi。请参阅下面的《调试 PXE 问题》部分，了解如何使用/boot/loader.efi。|
| -- | --------------------------------------------------------------------------------------------------------------------------------------------- |

本部分说明了如何在 FreeBSD 系统上配置这些服务，以便其他系统可以 PXE 引导到 FreeBSD。有关更多信息，请参阅 diskless(8)。

|  | 如所述，提供这些服务的系统是不安全的。它应该位于网络的受保护区域，并且不被其他主机所信任。|
| -- | -------------------------------------------------------------------------------------------- |

### 34.10.1. 配置 PXE 环境

本节中显示的步骤配置内置的 NFS 和 TFTP 服务器。下一节演示如何安装和配置 DHCP 服务器。在这个例子中，将包含 PXE 用户使用的文件的目录是/b/tftpboot/FreeBSD/install。确保此目录存在并且在/etc/inetd.conf 和/usr/local/etc/dhcpd.conf 中设置相同的目录名称是很重要的。

|  | 下面的命令示例假定使用 sh(1) shell。csh(1) 和 tcsh(1) 用户需要启动 sh(1) shell 或者将命令适应 csh(1) 语法。|
| -- | ------------------------------------------------------------------------------------------------------------- |

1. 创建将包含要通过 NFS 挂载的 FreeBSD 安装的根目录：

    ```
    # export NFSROOTDIR=/b/tftpboot/FreeBSD/install
    # mkdir -p ${NFSROOTDIR}
    ```
2. 将以下内容添加到 /etc/rc.conf 中启用 NFS 服务器：

    ```
    nfs_server_enable="YES"
    ```
3. 将以下内容添加到 /etc/exports 中导出无盘根目录：

    ```
    /b -ro -alldirs -maproot=root
    ```
4. 启动 NFS 服务器：

    ```
    # service nfsd start
    ```
5. 通过将以下行添加到 /etc/rc.conf 启用 inetd(8)：

    ```
    inetd_enable="YES"
    ```
6. 通过确保不以 # 符号开头来取消注释 /etc/inetd.conf 中的以下行：

    ```
    tftp dgram udp wait root /usr/libexec/tftpd tftpd blocksize 1468 -l -s /b/tftpboot
    ```

    |  | 指定的 tftp 块大小，例如 1468 字节，替换默认大小 512 字节。一些 PXE 版本需要 TFTP 的 TCP 版本。在这种情况下，取消注释包含 stream tcp 的第二 tftp 行。|
    | -- | ------------------------------------------------------------------------------------------------------------------------------------------------------- |
7. 启动 inetd（8）：

    ```
    # service inetd start
    ```
8. 将基本系统安装到${NFSROOTDIR}中，可以通过解压官方存档或重新构建 FreeBSD 内核和用户空间来完成（更详细的说明请参阅“从源代码更新 FreeBSD”），但在运行 make installkernel 和 make installworld 命令时不要忘记添加 DESTDIR=<em>${NFSROOTDIR}</em>。
9. 测试 TFTP 服务器是否正常工作，并能够通过 PXE 下载引导加载程序：

    ```
    # tftp localhost
    tftp> get FreeBSD/install/boot/pxeboot
    Received 264951 bytes in 0.1 seconds
    ```
10. 编辑${NFSROOTDIR}/etc/fstab，并创建一个条目以通过 NFS 挂载根文件系统：

     ```
     # Device                                         Mountpoint    FSType   Options  Dump Pass
     myhost.example.com:/b/tftpboot/FreeBSD/install       /         nfs      ro        0    0
     ```

     用 NFS 服务器的主机名或 IP 地址替换 myhost.example.com。在此示例中，为防止 NFS 客户端可能删除根文件系统内容，将根文件系统以只读方式挂载。
11. 为通过 PXE 引导的客户端机器在 PXE 环境中设置根密码：

     ```
     # chroot ${NFSROOTDIR}
     # passwd
     ```
12. 如果需要，通过编辑 ${NFSROOTDIR}/etc/ssh/sshd_config 并启用 PermitRootLogin 来为 PXE 引导的客户端机器启用 ssh(1) root 登录。此选项在 sshd_config(5) 中有记录。
13. 在 ${NFSROOTDIR} 中执行 PXE 环境的任何其他定制。这些定制可能包括安装软件包或使用 vipw(8) 编辑密码文件。

从 NFS 根卷启动时，/etc/rc 检测到 NFS 引导并运行 /etc/rc.initdiskless。在这种情况下，/etc 和 /var 需要是内存支持的文件系统，以便这些目录可写，但 NFS 根目录是只读的：

```
# chroot ${NFSROOTDIR}
# mkdir -p conf/base
# tar -c -v -f conf/base/etc.cpio.gz --format cpio --gzip etc
# tar -c -v -f conf/base/var.cpio.gz --format cpio --gzip var
```

系统启动时，将创建并挂载 /etc 和 /var 的内存文件系统，并将 cpio.gz 文件的内容复制到其中。默认情况下，这些文件系统的最大容量为 5 兆字节。如果你的存档不适合（通常是对于已安装二进制包的 /var），请通过在 ${NFSROOTDIR}/conf/base/etc/md_size 和 ${NFSROOTDIR}/conf/base/var/md_size 文件中分别放置所需的 512 字节扇区数（例如，5 兆字节为 10240 扇区）来请求更大的尺寸。

### 34.10.2. 配置 DHCP 服务器

DHCP 服务器不需要与 TFTP 和 NFS 服务器相同的机器，但它需要在网络中可访问。

DHCP 不是 FreeBSD 基本系统的一部分，但可以使用 net/isc-dhcp44-serverport或包进行安装。

安装后，编辑配置文件/usr/local/etc/dhcpd.conf。按照这个示例中所示的方式配置 next-server，filename 和 root-path 设置。

```
subnet 192.168.0.0 netmask 255.255.255.0 {
   range 192.168.0.2 192.168.0.3 ;
   option subnet-mask 255.255.255.0 ;
   option routers 192.168.0.1 ;
   option broadcast-address 192.168.0.255 ;
   option domain-name-servers 192.168.35.35, 192.168.35.36 ;
   option domain-name "example.com";

   # IP address of TFTP server
   next-server 192.168.0.1 ;

   # path of boot loader obtained via tftp
   filename "FreeBSD/install/boot/pxeboot" ;

   # pxeboot boot loader will try to NFS mount this directory for root FS
   option root-path "192.168.0.1:/b/tftpboot/FreeBSD/install/" ;

}
```

next-server 指令用于指定 TFTP 服务器的 IP 地址。

filename 指令定义了路径到 /boot/pxeboot。使用相对文件名，意味着路径中不包括 /b/tftpboot。

root-path 选项定义了 NFS 根文件系统的路径。

编辑保存后，在 /etc/rc.conf 中添加以下行以在启动时启用 DHCP：

```
dhcpd_enable="YES"
```

然后启动 DHCP 服务：

```
# service isc-dhcpd start
```

### 34.10.3. 调试 PXE 问题

若所有服务都配置并启动，PXE 客户端应该能够自动通过网络加载 FreeBSD。如果某个客户端无法连接，当该客户端机器启动时，进入 BIOS 配置菜单并确认它设置为从网络启动。

如果没有客户端能够进行 PXE 引导，则本节将介绍一些故障排除技巧，用于分离配置问题的来源。

1. 使用 net/wireshark 软件包或 port 来调试 PXE 引导过程中涉及的网络流量，在下面的图表中有所说明。![pxe nfs](https://docs.freebsd.org/images/books/handbook/advanced-networking/pxe-nfs.png)
    图 1. 具有 NFS Root Mount 的 PXE 引导过程

    1. 客户端广播 DHCPDISCOVER 消息。
    2. DHCP 服务器响应 IP 地址、next-server、文件名和根路径值。
    3. 客户端向 next-server 发送 TFTP 请求，请求检索文件名。
    4. TFTP 服务器响应并将文件名发送给客户端。
    5. 客户端执行文件名，即 pxeboot（8），然后加载内核。当内核执行时，由 root-path 指定的根文件系统将挂载到 NFS 上。
2. 在 TFTP 服务器上，读取/var/log/xferlog 以确保从正确位置检索 pxeboot。要测试此示例配置：

    ```
    # tftp 192.168.0.1
    tftp> get FreeBSD/install/boot/pxeboot
    Received 264951 bytes in 0.1 seconds
    ```

    tftpd(8)和 tftp(1)文档中的 BUGS 部分记录了 TFTP 的一些限制。
3. 确保可以通过 NFS 挂载根文件系统。要测试此示例配置：

    ```
    # mount -t nfs 192.168.0.1:/b/tftpboot/FreeBSD/install /mnt
    ```
4. 对于基于 UEFI PXE 引导，请用 boot/loader.efi 文件替换 boot/pxeboot 文件：

```
# chroot ${NFSROOTDIR}
# mv boot/pxeboot boot/pxeboot.original
# cp boot/loader.efi boot/pxeboot
```
