# 34.11.共用地址冗余协议（CARP）


通用地址冗余协议 (CARP) 能让多个主机共享相同的 IP 地址和虚拟主机 ID (VHID)，以便为一个或多个服务提供高可用性。这意味着一个或多个主机可能会发生故障，而其他主机将透明地接管，从而用户不会看到服务故障。

除了共享 IP 地址外，每个主机还有自己用于管理和配置的 IP 地址。共享同一 IP 地址的所有机器都具有相同的 VHID。每个虚拟 IP 地址的 VHID 必须在网络接口的广播域中是唯一的。

在 FreeBSD 中内置了使用 CARP 实现高可用性，尽管配置它的步骤略有不同取决于 FreeBSD 版本。本节为 FreeBSD 10 及其之前或之后的版本提供相同的示例配置。

该示例配置了三台主机的故障转移支持，所有主机都具有唯一的 IP 地址，但提供相同的网络内容。它有两个不同的主节点，名为 hosta.example.org 和 hostb.example.org，以及一个名为 hostc.example.org 的共享备用节点。

这些机器使用循环 Robin DNS 配置进行负载均衡。主备机器的配置相同，除了它们的主机名和管理 IP 地址不同。这些服务器必须具有相同的配置并运行相同的服务。当故障切换发生时，只有备用服务器访问相同的内容，才能正确响应共享 IP 地址上的服务请求。备用机器有两个额外的 CARP 接口，一个用于每个主内容服务器的 IP 地址。当发生故障时，备用服务器将接管失败的主机器的 IP 地址。

### 使用 CARP

通过在 /boot/loader.conf 中添加 carp.ko 内核模块的条目，启用 CARP 的启动支持。

```
carp_load="YES"
```

现在加载模块而无需重启：

```
# kldload carp
```

对于喜欢使用定制内核的用户，请在定制内核配置文件中包含以下行，并按照在配置 FreeBSD 内核中说明的步骤编译内核：

```
device	carp
```

主机名、管理 IP 地址和子网掩码、共享 IP 地址和 VHID 都通过在 /etc/rc.conf 中添加条目来设置。此示例适用于 hosta.example.org ：

```
hostname="hosta.example.org"
ifconfig_em0="inet 192.168.1.3 netmask 255.255.255.0"
ifconfig_em0_alias0="inet vhid 1 pass testpass alias 192.168.1.50/32"
```

下一组条目是为了 hostb.example.org。由于它代表第二主机，因此使用不同的共享 IP 地址和 VHID。但是，必须使用与 pass 指定的密码相同，因为 CARP 只会接收来自具有正确密码的机器的广告。

```
hostname="hostb.example.org"
ifconfig_em0="inet 192.168.1.4 netmask 255.255.255.0"
ifconfig_em0_alias0="inet vhid 2 pass testpass alias 192.168.1.51/32"
```

第三台机器，hostc.example.org，配置为处理来自任一主机的故障转移。该机器配置有两个 CARPVHID，一个用于处理每个主机的虚拟 IP 地址。CARP 广告偏移，advskew，设置为确保备份主机的广告比主机晚，因为 advskew 控制了多个备份服务器时的优先顺序。

```
hostname="hostc.example.org"
ifconfig_em0="inet 192.168.1.5 netmask 255.255.255.0"
ifconfig_em0_alias0="inet vhid 1 advskew 100 pass testpass alias 192.168.1.50/32"
ifconfig_em0_alias1="inet vhid 2 advskew 100 pass testpass alias 192.168.1.51/32"
```

配置了两个 CARPVHID 意味着 hostc.example.org 会注意到任一主服务器变得不可用。如果主服务器在备份服务器之前未能进行广告发布，则备份服务器将接管共享 IP 地址，直到主服务器再次变为可用。

```
# ifconfig em0 vhid 1 state backup
```

配置完成后，要么重启网络，要么重启每个系统。高可用性现在已启用。

CARP 功能可以通过 carp(4)手册页面中记录的几个 sysctl(8)变量来控制。通过 devd(8)可以触发 CARP 事件的其他操作。
